# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3006 (phpMyAdmin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63670);
 script_version ("$");
 name["english"] = "Fedora Core 10 FEDORA-2009-3006 (phpMyAdmin)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to phpMyAdmin
announced via advisory FEDORA-2009-3006.

Update Information:

Improvements for 3.1.3.1:
- [security] HTTP Response Splitting and file inclusion vulnerabilities
- [security] XSS vulnerability on export page
- [security] Insufficient output sanitizing when generating configuration file

ChangeLog:

* Wed Mar 25 2009 Robert Scheck  3.1.3.1-1
- Upstream released 3.1.3.1 (#492066)

References:

[ 1 ] Bug #492066 - phpMyAdmin: Insufficient output sanitizing when generating configuration file (PMASA-2009-3)
https://bugzilla.redhat.com/show_bug.cgi?id=492066

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update phpMyAdmin' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3006

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 10 FEDORA-2009-3006 (phpMyAdmin)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"<td>phpMyAdmin", rpm:"<td>phpMyAdmin~3.1.3.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"phpMyAdmin", rpm:"phpMyAdmin~3.1.3.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
