# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-1276 (nss)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63328);
 script_cve_id("CVE-2004-2761");
 script_version ("$");
 name["english"] = "Fedora Core 9 FEDORA-2009-1276 (nss)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to nss
announced via advisory FEDORA-2009-1276.

Network Security Services (NSS) is a set of libraries designed to
support cross-platform development of security-enabled client and
server applications. Applications built with NSS can support SSL v2
and v3, TLS, PKCS #5, PKCS #7, PKCS #11, PKCS #12, S/MIME, X.509
v3 certificates, and other security standards.

Update Information:

This updates adds protection against rogue CA that was generated as a proof-of-
concept of the MD5 collision attacks against X509 signatures:
http://www.win.tue.nl/hashclash/rogue-ca/ , related to CVE-2004-2761.
ChangeLog:

* Fri Jan 23 2009 Kai Engert  - 3.12.2.0-2
- Update to NSS_3_12_2_WITH_CKBI_1_73_RTM

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update nss' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-1276

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 9 FEDORA-2009-1276 (nss)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"nss", rpm:"nss~3.12.2.0~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nss-devel", rpm:"nss-devel~3.12.2.0~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nss-pkcs11-devel", rpm:"nss-pkcs11-devel~3.12.2.0~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nss-tools", rpm:"nss-tools~3.12.2.0~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nss-debuginfo", rpm:"nss-debuginfo~3.12.2.0~2.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
