# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0297 (nfs-utils)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63212);
 script_version ("$");
 name["english"] = "Fedora Core 9 FEDORA-2009-0297 (nfs-utils)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to nfs-utils
announced via advisory FEDORA-2009-0297.

Update Information:

- Added warnings to tcp wrapper code when mounts are
  denied due to misconfigured DNS configurations.
- gssd: By default, don't spam syslog when users'
  credentials expire
  Re-enabled and fixed/enhanced tcp wrappers.

ChangeLog:

* Mon Jan  5 2009 Steve Dickson  1.1.2-9
- Added warnings to tcp wrapper code when mounts are
denied due to misconfigured DNS configurations.
- gssd: By default, don't spam syslog when users' credentials expire
* Sat Dec 20 2008 Steve Dickson  1.1.2-8
- Re-enabled and fixed/enhanced tcp wrappers.

References:

[ 1 ] Bug #477864 - nfs-utils: missing tcp_wrappers support in Fedora 9 and 10
https://bugzilla.redhat.com/show_bug.cgi?id=477864

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update nfs-utils' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0297

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 9 FEDORA-2009-0297 (nfs-utils)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"nfs-utils", rpm:"nfs-utils~1.1.2~9.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nfs-utils-debuginfo", rpm:"nfs-utils-debuginfo~1.1.2~9.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
