# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 670-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53499);
 script_cve_id("CVE-2005-0100");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 670-1 (emacs20)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to emacs20
announced via advisory DSA 670-1.

Max Vozeler discovered several format string vulnerabilities in the
movemail utility of Emacs, the well-known editor.  Via connecting to a
malicious POP server an attacker can execute arbitrary code under the
privileges of group mail.

For the stable distribution (woody) these problems have been fixed in
version 20.7-13.3.

The unstable distribution (sid) does not contain an Emacs20 package
anymore.

We recommend that you upgrade your emacs packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20670-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 670-1 (emacs20)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"emacs20-el", ver:"20.7-13.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"emacs20", ver:"20.7-13.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
