# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 415-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53113);
 script_cve_id("CVE-2003-0795", "CVE-2003-0858");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 415-1 (zebra)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to zebra
announced via advisory DSA 415-1.

Two vulnerabilities were discovered in zebra, an IP routing daemon:

CVE-2003-0795 - a bug in the telnet CLI could allow a remote attacker
to cause a zebra process to crash, resulting in a denial of service.

CVE-2003-0858 - netlink messages sent by other users (rather than the
kernel) would be accepted, leading to a denial of service.

For the current stable distribution (woody) this problem has been
fixed in version 0.92a-5woody2.

The zebra package has been obsoleted in the unstable distribution by
GNU Quagga, where this problem was fixed in version 0.96.4x-4.

We recommend that you update your zebra package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20415-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 415-1 (zebra)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"zebra-doc", ver:"0.92a-5woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"zebra", ver:"0.92a-5woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
