# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 385-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53669);
 script_cve_id("CVE-2003-0783");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 385-1 (hztty)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to hztty
announced via advisory DSA 385-1.

Jens Steube reported a pair of buffer overflow vulnerabilities in
hztty, a program to translate Chinese character encodings in a
terminal session.  These vulnerabilities could be exploited by a local
attacker to gain root privileges on a system where hztty is installed.

Additionally, hztty had been incorrectly installed setuid root, when
it only requires the privileges of group utmp.  This has also been
corrected in this update.

For the stable distribution (woody) this problem has been fixed in
version 2.0-5.2woody1.

For the unstable distribution (sid) this problem will befixed in
version 2.0-6.

We recommend that you update your hztty package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20385-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 385-1 (hztty)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"hztty", ver:"2.0-5.2woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
