# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 189-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53437);
 script_bugtraq_id(6113);
 script_cve_id("CVE-2002-1245");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 189-1 (luxman)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to luxman
announced via advisory DSA 189-1.

iDEFENSE reported about a vulnerability in LuxMan, a maze game for
GNU/Linux, similar to the PacMan arcade game.  When successfully
exploited it a local attacker with read write access to the Memory,
leading to a local root compromise in many ways, examples of which
include scanning the file for fragments of the master password file
and modifying kernel memory to re-map system calls.

This problem has been fixed in version 0.41-17.1 the current stable
distribution (woody) and in version 0.41-19 for the unstable
distribution (sid).  The old stable distribution (potato) is not
affected since it doesn't contain a luxman package

We recommend that you upgrade your luxman package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20189-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 189-1 (luxman)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"luxman", ver:"0.41-17.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
