# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1802-1 (squirrelmail)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64033);
 script_cve_id("CVE-2009-1578", "CVE-2009-1579", "CVE-2009-1580", "CVE-2009-1581");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1802-1 (squirrelmail)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to squirrelmail
announced via advisory DSA 1802-1.

Several remote vulnerabilities have been discovered in SquirrelMail,
a webmail application. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2009-1578

Cross site scripting was possible through a number of pages which
allowed an attacker to steal sensitive session data.

CVE-2009-1579

Code injection was possible when SquirrelMail was configured to
use the map_yp_alias function to authenticate users. This is not
the default.

CVE-2009-1580

It was possible to hijack an active user session by planting a
specially crafted cookie into the user's browser.

CVE-2009-1581

Specially crafted HTML emails could use the CSS positioning feature
to place email content over the SquirrelMail user interface, allowing
for phishing.

For the old stable distribution (etch), these problems have been fixed in
version 1.4.9a-4.

For the stable distribution (lenny), these problems have been fixed in
version 1.4.15-4+lenny1.

For the unstable distribution (sid), these problems have been fixed in
version 1.4.18-1.

We recommend that you upgrade your squirrelmail package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201802-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1802-1 (squirrelmail)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"squirrelmail", ver:"1.4.9a-4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squirrelmail", ver:"1.4.15-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
