# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1765-1 (horde3)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63792);
 script_cve_id("CVE-2009-0932", "CVE-2008-3330", "CVE-2008-5917");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1765-1 (horde3)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to horde3
announced via advisory DSA 1765-1.

Several vulnerabilities have been found in horde3, the horde web application
framework. The Common Vulnerabilities and Exposures project identifies
the following problems:

CVE-2009-0932

Gunnar Wrobel discovered a directory traversal vulnerability, which
allows attackers to include and execute arbitrary local files via the
driver parameter in Horde_Image.

CVE-2008-3330

It was discovered that an attacker could perform a cross-site scripting
attack via the contact name, which allows attackers to inject arbitrary
html code. This requires that the attacker has access to create
contacts.

CVE-2008-5917

It was discovered that the horde XSS filter is prone to a cross-site
scripting attack, which allows attackers to inject arbitrary html code.
This is only exploitable when Internet Explorer is used.


For the oldstable distribution (etch), these problems have been fixed in
version 3.1.3-4etch5.

For the stable distribution (lenny), these problems have been fixed in
version 3.2.2+debian0-2, which was already included in the lenny
release.

For the testing distribution (squeeze) and the unstable distribution
(sid), these problems have been fixed in version 3.2.2+debian0-2.


We recommend that you upgrade your horde3 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201765-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1765-1 (horde3)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"horde3", ver:"3.1.3-4etch5", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
