# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1743-1 (libtk-img)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63608);
 script_cve_id("CVE-2007-5137", "CVE-2007-5378");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1743-1 (libtk-img)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to libtk-img
announced via advisory DSA 1743-1.

Two buffer overflows have been found in the GIF image parsing code of
Tk, a cross-platform graphical toolkit, which could lead to the execution
of arbitrary code. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2007-5137

It was discovered that libtk-img is prone to a buffer overflow via
specially crafted multi-frame interlaced GIF files.

CVE-2007-5378

It was discovered that libtk-img is prone to a buffer overflow via
specially crafted GIF files with certain subimage sizes.


For the stable distribution (lenny), these problems have been fixed in
version 1.3-release-7+lenny1.

For the oldstable distribution (etch), these problems have been fixed in
version 1.3-15etch3.

For the testing distribution (squeeze) and the unstable distribution
(sid), these problems have been fixed in version 1.3-release-8.

We recommend that you upgrade your libtk-img packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201743-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1743-1 (libtk-img)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libtk-img", ver:"1.3-15etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtk-img-doc", ver:"1.3-release-7+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtk-img", ver:"1.3-release-7+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtk-img-dev", ver:"1.3-release-7+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
