# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1738-1 (curl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63577);
 script_cve_id("CVE-2009-0037");
 script_bugtraq_id(33962);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1738-1 (curl)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to curl
announced via advisory DSA 1738-1.

David Kierznowski discovered that libcurl, a multi-protocol file transfer
library, when configured to follow URL redirects automatically, does not
question the new target location.  As libcurl also supports file:// and
scp:// URLs - depending on the setup - an untrusted server could use that
to expose local files, overwrite local files or even execute arbitrary
code via a malicious URL redirect.

This update introduces a new option called CURLOPT_REDIR_PROTOCOLS which by
default does not include the scp and file protocol handlers.


For the oldstable distribution (etch) this problem has been fixed in
version 7.15.5-1etch2.

For the stable distribution (lenny) this problem has been fixed in
version 7.18.2-8lenny2.

For the unstable distribution (sid) this problem has been fixed in
version 7.18.2-8.1.

We recommend that you upgrade your curl packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201738-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1738-1 (curl)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libcurl3-dev", ver:"7.15.5-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"curl", ver:"7.15.5-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-dbg", ver:"7.15.5-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-openssl-dev", ver:"7.15.5-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-gnutls-dev", ver:"7.15.5-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3", ver:"7.15.5-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-gnutls", ver:"7.15.5-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"curl", ver:"7.18.2-8lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-gnutls", ver:"7.18.2-8lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl4-openssl-dev", ver:"7.18.2-8lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-dbg", ver:"7.18.2-8lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3", ver:"7.18.2-8lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl4-gnutls-dev", ver:"7.18.2-8lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
