# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1637-1 (git-core)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61595);
 script_cve_id("CVE-2008-3546");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1637-1 (git-core)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to git-core
announced via advisory DSA 1637-1.

Multiple vulnerabilities have been identified in git-core, the core of
the git distributed revision control system.  Improper path length
limitations in git's diff and grep functions, in combination with
maliciously crafted repositories or changes, could enable a stack
buffer overflow and potentially the execution of arbitrary code.

The Common Vulnerabilities and Exposures project identifies this
vulnerabilitiy as CVE-2008-3546.

For the stable distribution (etch), this problem has been fixed in
version 1.4.4.4-2.1+etch1.

For the unstable distribution (sid), this problem has been fixed in
version 1.5.6.5-1.

We recommend that you upgrade your git-core packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201637-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1637-1 (git-core)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"git-arch", ver:"1.4.4.4-2.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-cvs", ver:"1.4.4.4-2.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-email", ver:"1.4.4.4-2.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gitweb", ver:"1.4.4.4-2.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-daemon-run", ver:"1.4.4.4-2.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-doc", ver:"1.4.4.4-2.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-svn", ver:"1.4.4.4-2.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gitk", ver:"1.4.4.4-2.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-core", ver:"1.4.4.4-2.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
