# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1524-1 (krb5)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60578);
 script_cve_id("CVE-2008-0062", "CVE-2008-0063", "CVE-2008-0947");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1524-1 (krb5)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to krb5
announced via advisory DSA 1524-1.

Several remote vulnerabilities have been discovered in the kdc component
of the krb5, a system for authenticating users and services on a
network.

CVE-2008-0062

An unauthenticated remote attacker may cause a krb4-enabled KDC to
crash, expose information, or execute arbitrary code.  Successful
exploitation of this vulnerability could compromise the Kerberos key
database and host security on the KDC host.

CVE-2008-0063

An unauthenticated remote attacker may cause a krb4-enabled KDC to
expose information.  It is theoretically possible for the exposed
information to include secret key data on some platforms.

CVE-2008-0947

An unauthenticated remote attacker can cause memory corruption in the
kadmind process, which is likely to cause kadmind to crash, resulting in
a denial of service. It is at least theoretically possible for such
corruption to result in database corruption or arbitrary code execution,
though we have no such exploit and are not aware of any such exploits in
use in the wild.  In versions of MIT Kerberos shipped by Debian, this
bug can only be triggered in configurations that allow large numbers of
open file descriptors in a process.

For the stable distribution (etch), these problems have been fixed in
version 1.4.4-7etch5.

For the old stable distribution (sarge), these problems have been fixed
in version krb5 1.3.6-2sarge6.

We recommend that you upgrade your krb5 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201524-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1524-1 (krb5)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"krb5-doc", ver:"1.3.6-2sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-user", ver:"1.3.6-2sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm55", ver:"1.3.6-2sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.3.6-2sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.3.6-2sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.3.6-2sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb53", ver:"1.3.6-2sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.3.6-2sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.3.6-2sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.3.6-2sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-clients", ver:"1.3.6-2sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-doc", ver:"1.4.4-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.4.4-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb53", ver:"1.4.4-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.4.4-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-dbg", ver:"1.4.4-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-clients", ver:"1.4.4-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.4.4-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-user", ver:"1.4.4-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm55", ver:"1.4.4-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.4.4-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.4.4-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.4.4-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
