# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1482-1 (squid)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60358);
 script_cve_id("CVE-2007-6239");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1482-1 (squid)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to squid
announced via advisory DSA 1482-1.

It was discovered that malformed cache update replies against the Squid
WWW proxy cache could lead to the exhaustion of system memory, resulting
in potential denial of service.

For the stable distribution (etch), this problem has been fixed in
version 2.6.5-6etch1.

For the old stable distribution (sarge), the update cannot currently
be processed on the buildd security network due to a bug in the archive
management script. This will be resolved soon. An update for i386
is temporarily available at at http://people.debian.org/~jmm/squid/.

We recommend that you upgrade your squid packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201482-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1482-1 (squid)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"squid-common", ver:"2.6.5-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid", ver:"2.6.5-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squidclient", ver:"2.6.5-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid-cgi", ver:"2.6.5-6etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
