# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1427-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60006);
 script_cve_id("CVE-2007-6015");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1427-1 (samba)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to samba
announced via advisory DSA 1427-1.

Alin Rad Pop discovered that Samba, a LanManager-like file and printer
server for Unix, is vulnerable to a buffer overflow in the nmbd code
which handles GETDC mailslot requests, which might lead to the execution
of arbitrary code.

For the stable distribution (etch), this problem has been fixed in
version 3.0.24-6etch9.

For the old stable distribution (sarge), this problem has been fixed in
version samba 3.0.14a-3sarge11. Packages for m68k will be provided
later.

For the unstable distribution (sid), this problem will be fixed soon.

We recommend that you upgrade your samba packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201427-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1427-1 (samba)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"samba-doc", ver:"3.0.14a-3sarge11", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbfs", ver:"3.0.14a-3sarge11", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-common", ver:"3.0.14a-3sarge11", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba", ver:"3.0.14a-3sarge11", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"swat", ver:"3.0.14a-3sarge11", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbclient", ver:"3.0.14a-3sarge11", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.0.14a-3sarge11", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient", ver:"3.0.14a-3sarge11", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.0.14a-3sarge11", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"winbind", ver:"3.0.14a-3sarge11", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-dbg", ver:"3.0.14a-3sarge11", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.3-samba", ver:"3.0.14a-3sarge11", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-doc", ver:"3.0.24-6etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.0.24-6etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-samba", ver:"3.0.24-6etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.0.24-6etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbfs", ver:"3.0.24-6etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.0.24-6etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbclient", ver:"3.0.24-6etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient", ver:"3.0.24-6etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"swat", ver:"3.0.24-6etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"winbind", ver:"3.0.24-6etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-dbg", ver:"3.0.24-6etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba", ver:"3.0.24-6etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-common", ver:"3.0.24-6etch9", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
