# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1422-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(59957);
 script_cve_id("CVE-2007-5497");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1422-1 (e2fsprogs)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to e2fsprogs
announced via advisory DSA 1422-1.

Rafal Wojtczuk of McAfee AVERT Research discovered that e2fsprogs,
ext2 file system utilities and libraries, contained multiple
integer overflows in memory allocations, based on sizes taken directly
from filesystem information.  These could result in heap-based
overflows potentially allowing the execution of arbitrary code.

For the stable distribution (etch), this problem has been fixed in version
1.39+1.40-WIP-2006.11.14+dfsg-2etch1.

For the unstable distribution (sid), this problem will be fixed shortly.

We recommend that you upgrade your e2fsprogs package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201422-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1422-1 (e2fsprogs)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libblkid-dev", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"e2fsck-static", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libuuid1", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"e2fslibs-dev", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"uuid-dev", ver:"1.2-1.39+1.40-WIP-2006.11.14+dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ss-dev", ver:"2.0-1.39+1.40-WIP-2006.11.14+dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libblkid1", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"e2fslibs", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libss2", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"comerr-dev", ver:"2.1-1.39+1.40-WIP-2006.11.14+dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"e2fsprogs", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcomerr2", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
