# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 139-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53401);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 139-1 (super)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to super
announced via advisory DSA 139-1.

GOBBLES found an insecure use of format strings in the super package.
The included program super is intended to provide access to certain
system users for particular users and programs, similar to the program
super.  Exploiting this format string vulnerability a local user can
gain unauthorized root accesss.

This problem has been fixed in version 3.12.2-2.1 for the old stable
distribution (potato), in version 3.16.1-1.1 for the current stable
distribution (woody) and in version 3.18.0-3 for the unstable
distribution (sid).

We recommend that you upgrade your super package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20139-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 139-1 (super)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"super", ver:"3.12.2-2.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"super", ver:"3.16.1-1.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
