# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1190-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57484);
 script_cve_id("CVE-2006-4305");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1190-1 (maxdb-7.5.00)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to maxdb-7.5.00
announced via advisory DSA 1190-1.

Oliver Karow discovered that the WebDBM frontend of the MaxDB database
performs insufficient sanitising of requests passed to it, which might
lead to the execution of arbitrary code.

For the stable distribution (sarge) this problem has been fixed in
version 7.5.00.24-4.

For the unstable distribution (sid) this problem will be fixed soon.

We recommend that you upgrade your maxdb-7.5.00 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201190-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1190-1 (maxdb-7.5.00)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libsqldbc7.5.00", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsqldbc7.5.00-dev", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsqlod7.5.00", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsqlod7.5.00-dev", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"maxdb-dbanalyzer", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"maxdb-dbmcli", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"maxdb-loadercli", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"maxdb-lserver", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"maxdb-server", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"maxdb-server-7.5.00", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"maxdb-server-dbg-7.5.00", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"maxdb-sqlcli", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"maxdb-webtools", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-maxdb", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-maxdb-loader", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.3-maxdb", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.3-maxdb-loader", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-maxdb", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-maxdb-loader", ver:"7.5.00.24-4", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
