# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 043-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53804);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 043-1 (zope)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to zope
announced via advisory DSA 043-1.

This advisory covers several vulnerabilities in Zope that have been
addressed.

1. Hotfix 08_09_2000 'Zope security alert and hotfix product'

The issue involves the fact that the getRoles method of user objects
contained in the default UserFolder implementation returns a mutable
Python type.  Because the mutable object is still associated with
the persistent User object, users with the ability to edit DTML
could arrange to give themselves extra roles for the duration of a
single request by mutating the roles list as a part of the request
processing.

2. Hotfix 2000-10-02 'ZPublisher security update'

It is sometimes possible to access, through an URL only, objects
protected by a role which the user has in some context, but not in
the context of the accessed object.

3. Hotfix 2000-10-11 'ObjectManager subscripting'

The issue involves the fact that the 'subscript notation' that can
be used to access items of ObjectManagers (Folders) did not
correctly restrict return values to only actual sub items.  This
made it possible to access names that should be private from DTML
(objects with names beginning with the underscore '_' character).
This could allow DTML authors to see private implementation data
structures and in certain cases possibly call methods that they
shouldn't have access to from DTML.

4. Hotfix 2001-02-23 'Class attribute access'

The issue is related to ZClasses in that a user with through-the-web
scripting capabilities on a Zope site can view and assign class
attributes to ZClasses, possibly allowing them to make inappropriate
changes to ZClass instances.

A second part fixes problems in the ObjectManager, PropertyManager,
and PropertySheet classes related to mutability of method return
values which could be perceived as a security problem.

We recommend you upgrade your zope package immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20043-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 043-1 (zope)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"zope", ver:"2.1.6-7", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
