###############################################################################
# OpenVAS Vulnerability Test
# $Id: Turnkey_eBook_store_xss_34324.nasl 3393 2009-05-15 16:22:08Z mime $
#
# Turnkey eBook Store 'keywords' Parameter Cross Site Scripting
# Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100098);
 script_bugtraq_id(34324);
 script_version ("1.0");

 script_name(english:"Turnkey eBook Store 'keywords' Parameter Cross Site Scripting Vulnerability");
 desc["english"] = "

 Overview:
  
  Turnkey eBook Store is prone to a cross-site scripting vulnerability.

  An attacker may leverage this issue to execute arbitrary script code
  in the browser of an unsuspecting user in the context of the affected
  site and to steal cookie-based authentication credentials.

  Turnkey eBook Store 1.1 is vulnerable; other versions may also be
  affected.
 
 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if Turnkey eBook Store is prone to Cross Site Scripting vulnerabilitie");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Web application abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);

dir = make_list(cgi_dirs());

foreach d (dir)
{ 
 url = string(d, '/index.php?cmd=search&keywords="><script>alert(document.cookie);</script>');
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
 if( buf == NULL )continue;

 if ( egrep(pattern:"<script>alert\(document\.cookie\);</script>", string: buf) )
     
 	{    
       	  security_warning(port:port);
          exit(0);
        }
}

exit(0);
