# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0459 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63911);
 script_cve_id("CVE-2008-4307", "CVE-2009-0028", "CVE-2009-0676", "CVE-2009-0834");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0459";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates to the kernel announced in
advisory RHSA-2009:0459.

Security fixes:

* a logic error was found in the do_setlk() function of the Linux kernel
Network File System (NFS) implementation. If a signal interrupted a lock
request, the local POSIX lock was incorrectly created. This could cause a
denial of service on the NFS server if a file descriptor was closed before
its corresponding lock request returned. (CVE-2008-4307, Important)

* a deficiency was found in the Linux kernel system call auditing
implementation on 64-bit systems. This could allow a local, unprivileged
user to circumvent a system call audit configuration, if that configuration
filtered based on the syscall number or arguments.
(CVE-2009-0834, Important)

* Chris Evans reported a deficiency in the Linux kernel signals
implementation. The clone() system call permits the caller to indicate the
signal it wants to receive when its child exits. When clone() is called
with the CLONE_PARENT flag, it permits the caller to clone a new child that
shares the same parent as itself, enabling the indicated signal to be sent
to the caller's parent (instead of the caller), even if the caller's parent
has different real and effective user IDs. This could lead to a denial of
service of the parent. (CVE-2009-0028, Moderate)

* the sock_getsockopt() function in the Linux kernel did not properly
initialize a data structure that can be directly returned to user-space
when the getsockopt() function is called with SO_BSDCOMPAT optname set.
This flaw could possibly lead to memory disclosure.
(CVE-2009-0676, Moderate)

For details on other non-security related bug fixes, please visit
the referenced advisories.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0459.html
http://www.redhat.com/security/updates/classification/#important

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0459";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.9~78.0.22.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.9~78.0.22.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.9~78.0.22.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-hugemem", rpm:"kernel-hugemem~2.6.9~78.0.22.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-hugemem-devel", rpm:"kernel-hugemem-devel~2.6.9~78.0.22.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.9~78.0.22.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.9~78.0.22.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xenU", rpm:"kernel-xenU~2.6.9~78.0.22.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xenU-devel", rpm:"kernel-xenU-devel~2.6.9~78.0.22.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-largesmp", rpm:"kernel-largesmp~2.6.9~78.0.22.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-largesmp-devel", rpm:"kernel-largesmp-devel~2.6.9~78.0.22.EL", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.9~78.0.22.EL", rls:"RHENT_4")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
