# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0451 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63908);
 script_cve_id("CVE-2008-4307", "CVE-2009-0028", "CVE-2009-0834", "CVE-2009-0835", "CVE-2009-1046", "CVE-2009-1337");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0451";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0451.

The kernel-rt packages contain the Linux kernel, the core of any Linux
operating system.

These updated packages fix the following security issues:

* a logic error was found in the do_setlk() function of the Linux kernel
Network File System (NFS) implementation. If a signal interrupted a lock
request, the local POSIX lock was incorrectly created. This could cause a
denial of service on the NFS server if a file descriptor was closed before
its corresponding lock request returned. (CVE-2008-4307, Important)

* a deficiency was found in the Linux kernel system call auditing
implementation on 64-bit systems. This could allow a local, unprivileged
user to circumvent a system call audit configuration, if that configuration
filtered based on the syscall number or arguments.
(CVE-2009-0834, Important)

* Chris Evans reported a deficiency in the Linux kernel secure-computing
implementation on 64-bit systems. This could allow a local, unprivileged
user to bypass intended access restrictions, if those access restriction
filters were based on the syscall number or arguments.
(CVE-2009-0835, Important)

* the exit_notify() function in the Linux kernel did not properly reset the
exit signal if a process executed a set user ID (setuid) application before
exiting. This could allow a local, unprivileged user to elevate their
privileges. (CVE-2009-1337, Important)

* Chris Evans reported a deficiency in the Linux kernel signals
implementation. The clone() system call permits the caller to indicate the
signal it wants to receive when its child exits. When clone() is called
with the CLONE_PARENT flag, it permits the caller to clone a new child that
shares the same parent as itself, enabling the indicated signal to be sent
to the caller's parent (instead of the caller), even if the caller's parent
has different real and effective user IDs. This could lead to a denial of
service of the parent. (CVE-2009-0028, Moderate)

* an off-by-two error was found in the set_selection() function of the
Linux kernel. This could allow a local, unprivileged user to cause a denial
of service when making a selection of characters in a UTF-8 console. Note:
physical console access is required to exploit this issue.
(CVE-2009-1046, Low)

These updated packages also fix the following bug:

* the __scsi_device_lookup_by_target() function was always returning the
first matching device, regardless of the state of the device. This meant
that any valid device listed after a deleted device would not be found. The
__scsi_device_lookup_by_target() function was modified so that deleted
devices are skipped, and valid devices are now found. (BZ#495976)

All Red Hat Enterprise MRG users should install this update, which resolves
these issues. For this update to take effect, the system must be rebooted.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0451.html
http://www.redhat.com/security/updates/classification/#important

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0451";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel-rt", rpm:"kernel-rt~2.6.24.7~111.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-debug", rpm:"kernel-rt-debug~2.6.24.7~111.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-debug-debuginfo", rpm:"kernel-rt-debug-debuginfo~2.6.24.7~111.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-debug-devel", rpm:"kernel-rt-debug-devel~2.6.24.7~111.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-debuginfo", rpm:"kernel-rt-debuginfo~2.6.24.7~111.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-debuginfo-common", rpm:"kernel-rt-debuginfo-common~2.6.24.7~111.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-devel", rpm:"kernel-rt-devel~2.6.24.7~111.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-trace", rpm:"kernel-rt-trace~2.6.24.7~111.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-trace-debuginfo", rpm:"kernel-rt-trace-debuginfo~2.6.24.7~111.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-trace-devel", rpm:"kernel-rt-trace-devel~2.6.24.7~111.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-vanilla", rpm:"kernel-rt-vanilla~2.6.24.7~111.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-vanilla-debuginfo", rpm:"kernel-rt-vanilla-debuginfo~2.6.24.7~111.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-vanilla-devel", rpm:"kernel-rt-vanilla-devel~2.6.24.7~111.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt-doc", rpm:"kernel-rt-doc~2.6.24.7~111.el5rt", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
