# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0259 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63369);
 script_cve_id("CVE-2008-2384");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0259";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0259.

The mod_auth_mysql package includes an extension module for the Apache HTTP
Server which can be used to implement web user authentication against a
MySQL database.

A flaw was found in the way mod_auth_mysql escaped certain
multibyte-encoded strings. If mod_auth_mysql was configured to use a
multibyte character set that allowed a backslash '\' as part of the
character encodings, a remote attacker could inject arbitrary SQL commands
into a login request. (CVE-2008-2384)

Note: This flaw only affected non-default installations where
AuthMySQLCharacterSet is configured to use one of the affected multibyte
character sets. Installations that did not use the AuthMySQLCharacterSet
configuration option were not vulnerable to this flaw.

All mod_auth_mysql users are advised to upgrade to the updated package,
which contains a backported patch to resolve this issue. After installing
the update, the httpd daemon must be restarted for the fix to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0259.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0259";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"mod_auth_mysql", rpm:"mod_auth_mysql~3.0.0~3.2.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mod_auth_mysql-debuginfo", rpm:"mod_auth_mysql-debuginfo~3.0.0~3.2.el5_3", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
