# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0012 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63368);
 script_cve_id("CVE-2007-2721", "CVE-2008-3520");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0012";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0012.

The netpbm package contains a library of functions for editing and
converting between various graphics file formats, including .pbm (portable
bitmaps), .pgm (portable graymaps), .pnm (portable anymaps), .ppm (portable
pixmaps), and others.

An input validation flaw and multiple integer overflows were discovered in
the JasPer library providing support for JPEG-2000 image format and used in
the jpeg2ktopam and pamtojpeg2k converters. An attacker could create a
carefully-crafted JPEG file which could cause jpeg2ktopam to crash or,
possibly, execute arbitrary code as the user running jpeg2ktopam.
(CVE-2007-2721, CVE-2008-3520)

All users are advised to upgrade to these updated packages which contain
backported patches which resolve these issues.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0012.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0012";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"netpbm", rpm:"netpbm~10.25~2.1.el4_7.4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"netpbm-debuginfo", rpm:"netpbm-debuginfo~10.25~2.1.el4_7.4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"netpbm-devel", rpm:"netpbm-devel~10.25~2.1.el4_7.4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"netpbm-progs", rpm:"netpbm-progs~10.25~2.1.el4_7.4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"netpbm", rpm:"netpbm~10.35~6.1.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"netpbm-debuginfo", rpm:"netpbm-debuginfo~10.35~6.1.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"netpbm-progs", rpm:"netpbm-progs~10.35~6.1.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"netpbm-devel", rpm:"netpbm-devel~10.35~6.1.el5_3.1", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
