#! /usr/bin/env python
# -*- coding: utf-8 -*-

#	Copyright 2010, David D Lowe
#	Copyright 2010-2012, Marten de Vries
#
#	This file is part of OpenTeacher.
#
#	OpenTeacher is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#
#	OpenTeacher is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with OpenTeacher.  If not, see <http://www.gnu.org/licenses/>.

from distutils.core import setup

setup(
	name = "OpenTeacher",
	version = "3.0",
	description = "Your personal tutor",
	author = "OpenTeacher auteurs",
	author_email = "openteachermaintainers@lists.launchpad.net",
	url = "http://openteacher.org/",
	license = 'GNU GPL',
	packages = ["openteacher"],
	package_data = {"openteacher": [
		"modules/org/openteacher/otxxsaver/otxxsaver.py",
		"modules/org/openteacher/gui/ui.py",
		"modules/org/openteacher/gui/gui.py",
		"modules/org/openteacher/gui/icons/add.png",
		"modules/org/openteacher/gui/icons/about.png",
		"modules/org/openteacher/gui/icons/quit.png",
		"modules/org/openteacher/gui/icons/print.png",
		"modules/org/openteacher/gui/icons/save.png",
		"modules/org/openteacher/gui/icons/save_as.png",
		"modules/org/openteacher/gui/icons/help.png",
		"modules/org/openteacher/gui/icons/COPYING",
		"modules/org/openteacher/gui/icons/settings.png",
		"modules/org/openteacher/gui/icons/new.png",
		"modules/org/openteacher/gui/icons/open.png",
		"modules/org/openteacher/gui/translations/ar.po",
		"modules/org/openteacher/gui/translations/es.mo",
		"modules/org/openteacher/gui/translations/cs.mo",
		"modules/org/openteacher/gui/translations/zh_CN.po",
		"modules/org/openteacher/gui/translations/af.po",
		"modules/org/openteacher/gui/translations/es.po",
		"modules/org/openteacher/gui/translations/hu.mo",
		"modules/org/openteacher/gui/translations/af.mo",
		"modules/org/openteacher/gui/translations/ru.po",
		"modules/org/openteacher/gui/translations/en_AU.mo",
		"modules/org/openteacher/gui/translations/org.openteacher.gui.pot",
		"modules/org/openteacher/gui/translations/fi.mo",
		"modules/org/openteacher/gui/translations/pt_BR.po",
		"modules/org/openteacher/gui/translations/nl.po",
		"modules/org/openteacher/gui/translations/de.mo",
		"modules/org/openteacher/gui/translations/pt_BR.mo",
		"modules/org/openteacher/gui/translations/en_AU.po",
		"modules/org/openteacher/gui/translations/eo.po",
		"modules/org/openteacher/gui/translations/fy.mo",
		"modules/org/openteacher/gui/translations/sk.po",
		"modules/org/openteacher/gui/translations/el.po",
		"modules/org/openteacher/gui/translations/si.mo",
		"modules/org/openteacher/gui/translations/ja.mo",
		"modules/org/openteacher/gui/translations/fr.po",
		"modules/org/openteacher/gui/translations/fr.mo",
		"modules/org/openteacher/gui/translations/sk.mo",
		"modules/org/openteacher/gui/translations/it.mo",
		"modules/org/openteacher/gui/translations/ja.po",
		"modules/org/openteacher/gui/translations/de.po",
		"modules/org/openteacher/gui/translations/cs.po",
		"modules/org/openteacher/gui/translations/ar.mo",
		"modules/org/openteacher/gui/translations/eo.mo",
		"modules/org/openteacher/gui/translations/el.mo",
		"modules/org/openteacher/gui/translations/fi.po",
		"modules/org/openteacher/gui/translations/ru.mo",
		"modules/org/openteacher/gui/translations/fy.po",
		"modules/org/openteacher/gui/translations/zh_TW.po",
		"modules/org/openteacher/gui/translations/zh_TW.mo",
		"modules/org/openteacher/gui/translations/hu.po",
		"modules/org/openteacher/gui/translations/zh_CN.mo",
		"modules/org/openteacher/gui/translations/nl.mo",
		"modules/org/openteacher/gui/translations/si.po",
		"modules/org/openteacher/gui/translations/it.po",
		"modules/org/openteacher/enterers/media/media.py",
		"modules/org/openteacher/enterers/media/translations/es.mo",
		"modules/org/openteacher/enterers/media/translations/cs.mo",
		"modules/org/openteacher/enterers/media/translations/org.openteacher.enterers.media.pot",
		"modules/org/openteacher/enterers/media/translations/es.po",
		"modules/org/openteacher/enterers/media/translations/fi.mo",
		"modules/org/openteacher/enterers/media/translations/pt_BR.po",
		"modules/org/openteacher/enterers/media/translations/nl.po",
		"modules/org/openteacher/enterers/media/translations/pt_BR.mo",
		"modules/org/openteacher/enterers/media/translations/fy.mo",
		"modules/org/openteacher/enterers/media/translations/el.po",
		"modules/org/openteacher/enterers/media/translations/fr.po",
		"modules/org/openteacher/enterers/media/translations/fr.mo",
		"modules/org/openteacher/enterers/media/translations/cs.po",
		"modules/org/openteacher/enterers/media/translations/el.mo",
		"modules/org/openteacher/enterers/media/translations/fi.po",
		"modules/org/openteacher/enterers/media/translations/fy.po",
		"modules/org/openteacher/enterers/media/translations/zh_TW.po",
		"modules/org/openteacher/enterers/media/translations/zh_TW.mo",
		"modules/org/openteacher/enterers/media/translations/nl.mo",
		"modules/org/openteacher/enterers/topo/topo.py",
		"modules/org/openteacher/enterers/topo/translations/es.mo",
		"modules/org/openteacher/enterers/topo/translations/cs.mo",
		"modules/org/openteacher/enterers/topo/translations/es.po",
		"modules/org/openteacher/enterers/topo/translations/fi.mo",
		"modules/org/openteacher/enterers/topo/translations/pt_BR.po",
		"modules/org/openteacher/enterers/topo/translations/nl.po",
		"modules/org/openteacher/enterers/topo/translations/pt_BR.mo",
		"modules/org/openteacher/enterers/topo/translations/fy.mo",
		"modules/org/openteacher/enterers/topo/translations/fr.po",
		"modules/org/openteacher/enterers/topo/translations/fr.mo",
		"modules/org/openteacher/enterers/topo/translations/cs.po",
		"modules/org/openteacher/enterers/topo/translations/fi.po",
		"modules/org/openteacher/enterers/topo/translations/fy.po",
		"modules/org/openteacher/enterers/topo/translations/zh_TW.po",
		"modules/org/openteacher/enterers/topo/translations/zh_TW.mo",
		"modules/org/openteacher/enterers/topo/translations/nl.mo",
		"modules/org/openteacher/enterers/topo/translations/org.openteacher.enterers.topo.pot",
		"modules/org/openteacher/enterers/words/words.py",
		"modules/org/openteacher/enterers/words/translations/ar.po",
		"modules/org/openteacher/enterers/words/translations/es.mo",
		"modules/org/openteacher/enterers/words/translations/cs.mo",
		"modules/org/openteacher/enterers/words/translations/zh_CN.po",
		"modules/org/openteacher/enterers/words/translations/af.po",
		"modules/org/openteacher/enterers/words/translations/es.po",
		"modules/org/openteacher/enterers/words/translations/hu.mo",
		"modules/org/openteacher/enterers/words/translations/af.mo",
		"modules/org/openteacher/enterers/words/translations/ru.po",
		"modules/org/openteacher/enterers/words/translations/fi.mo",
		"modules/org/openteacher/enterers/words/translations/pt_BR.po",
		"modules/org/openteacher/enterers/words/translations/org.openteacher.wordsEnterer.pot",
		"modules/org/openteacher/enterers/words/translations/nl.po",
		"modules/org/openteacher/enterers/words/translations/de.mo",
		"modules/org/openteacher/enterers/words/translations/pt_BR.mo",
		"modules/org/openteacher/enterers/words/translations/eo.po",
		"modules/org/openteacher/enterers/words/translations/fy.mo",
		"modules/org/openteacher/enterers/words/translations/sk.po",
		"modules/org/openteacher/enterers/words/translations/el.po",
		"modules/org/openteacher/enterers/words/translations/si.mo",
		"modules/org/openteacher/enterers/words/translations/ja.mo",
		"modules/org/openteacher/enterers/words/translations/fr.po",
		"modules/org/openteacher/enterers/words/translations/fr.mo",
		"modules/org/openteacher/enterers/words/translations/sk.mo",
		"modules/org/openteacher/enterers/words/translations/ja.po",
		"modules/org/openteacher/enterers/words/translations/de.po",
		"modules/org/openteacher/enterers/words/translations/cs.po",
		"modules/org/openteacher/enterers/words/translations/ar.mo",
		"modules/org/openteacher/enterers/words/translations/eo.mo",
		"modules/org/openteacher/enterers/words/translations/el.mo",
		"modules/org/openteacher/enterers/words/translations/fi.po",
		"modules/org/openteacher/enterers/words/translations/ru.mo",
		"modules/org/openteacher/enterers/words/translations/fy.po",
		"modules/org/openteacher/enterers/words/translations/zh_TW.po",
		"modules/org/openteacher/enterers/words/translations/zh_TW.mo",
		"modules/org/openteacher/enterers/words/translations/hu.po",
		"modules/org/openteacher/enterers/words/translations/zh_CN.mo",
		"modules/org/openteacher/enterers/words/translations/nl.mo",
		"modules/org/openteacher/enterers/words/translations/si.po",
		"modules/org/openteacher/enterers/plainTextWords/plainTextWords.py",
		"modules/org/openteacher/enterers/plainTextWords/translations/ar.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/es.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/cs.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/zh_CN.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/es.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/pt_BR.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/nl.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/de.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/pt_BR.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/fy.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/el.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/fr.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/fr.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/de.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/cs.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/ar.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/el.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/fy.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/zh_TW.po",
		"modules/org/openteacher/enterers/plainTextWords/translations/zh_TW.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/zh_CN.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/nl.mo",
		"modules/org/openteacher/enterers/plainTextWords/translations/org.openteacher.plainTextWordsEnterer.pot",
		"modules/org/openteacher/openteacherAuthors/openteacherAuthors.py",
		"modules/org/openteacher/openteacherAuthors/translations/ar.po",
		"modules/org/openteacher/openteacherAuthors/translations/es.mo",
		"modules/org/openteacher/openteacherAuthors/translations/cs.mo",
		"modules/org/openteacher/openteacherAuthors/translations/zh_CN.po",
		"modules/org/openteacher/openteacherAuthors/translations/org.openteacher.openteacherAuthors.pot",
		"modules/org/openteacher/openteacherAuthors/translations/es.po",
		"modules/org/openteacher/openteacherAuthors/translations/fi.mo",
		"modules/org/openteacher/openteacherAuthors/translations/pt_BR.po",
		"modules/org/openteacher/openteacherAuthors/translations/nl.po",
		"modules/org/openteacher/openteacherAuthors/translations/de.mo",
		"modules/org/openteacher/openteacherAuthors/translations/pt_BR.mo",
		"modules/org/openteacher/openteacherAuthors/translations/fy.mo",
		"modules/org/openteacher/openteacherAuthors/translations/fr.po",
		"modules/org/openteacher/openteacherAuthors/translations/fr.mo",
		"modules/org/openteacher/openteacherAuthors/translations/de.po",
		"modules/org/openteacher/openteacherAuthors/translations/cs.po",
		"modules/org/openteacher/openteacherAuthors/translations/ar.mo",
		"modules/org/openteacher/openteacherAuthors/translations/fi.po",
		"modules/org/openteacher/openteacherAuthors/translations/fy.po",
		"modules/org/openteacher/openteacherAuthors/translations/zh_TW.po",
		"modules/org/openteacher/openteacherAuthors/translations/zh_TW.mo",
		"modules/org/openteacher/openteacherAuthors/translations/zh_CN.mo",
		"modules/org/openteacher/openteacherAuthors/translations/nl.mo",
		"modules/org/openteacher/profilesHelp/profilesHelp.py",
		"modules/org/openteacher/packagers/source/source.py",
		"modules/org/openteacher/packagers/sourceWithSetup/sourceWithSetup.py",
		"modules/org/openteacher/packagers/arch/PKGBUILD.templ",
		"modules/org/openteacher/packagers/arch/arch.py",
		"modules/org/openteacher/packagers/debian/debian.py",
		"modules/org/openteacher/packagers/rpm/rpm.py",
		"modules/org/openteacher/packagers/windowsPortable/windowsPortable.py",
		"modules/org/openteacher/packagers/windowsMsi/openteacher.ico",
		"modules/org/openteacher/packagers/windowsMsi/windowsMsi.py",
		"modules/org/openteacher/packagers/windowsMsi/topbanner.bmp",
		"modules/org/openteacher/packagers/windowsMsi/leftbanner.bmp",
		"modules/org/openteacher/packagers/windowsMsi/COPYING.rtf",
		"modules/org/openteacher/translationTest/translationTest.py",
		"modules/org/openteacher/javaScript/lessonType/lessonType.js",
		"modules/org/openteacher/javaScript/lessonType/lessonType.py",
		"modules/org/openteacher/javaScript/implementationTest/implementationTest.py",
		"modules/org/openteacher/javaScript/event/event.py",
		"modules/org/openteacher/javaScript/event/event.js",
		"modules/org/openteacher/moduleGraph/moduleGraph.py",
		"modules/org/openteacher/codeDocs/codeDocs.py",
		"modules/org/openteacher/codeDocs/templ/modules.html",
		"modules/org/openteacher/codeDocs/templ/module.html",
		"modules/org/openteacher/codeDocs/templ/priorities.html",
		"modules/org/openteacher/codeDocs/resources/jquery.quicksearch.js",
		"modules/org/openteacher/codeDocs/resources/jquery.tablesorter.js",
		"modules/org/openteacher/codeDocs/resources/style.css",
		"modules/org/openteacher/codeDocs/resources/jquery.js",
		"modules/org/openteacher/codeDocs/resources/tablesorter/asc.gif",
		"modules/org/openteacher/codeDocs/resources/tablesorter/desc.gif",
		"modules/org/openteacher/codeDocs/resources/tablesorter/bg.gif",
		"modules/org/openteacher/textToSpeech/textToSpeech.py",
		"modules/org/openteacher/textToSpeech/tts/__init__.py",
		"modules/org/openteacher/textToSpeech/tts/pyttsx/__init__.py",
		"modules/org/openteacher/textToSpeech/tts/pyttsx/voice.py",
		"modules/org/openteacher/textToSpeech/tts/pyttsx/engine.py",
		"modules/org/openteacher/textToSpeech/tts/pyttsx/driver.py",
		"modules/org/openteacher/textToSpeech/tts/pyttsx/COPYING",
		"modules/org/openteacher/textToSpeech/tts/pyttsx/drivers/__init__.py",
		"modules/org/openteacher/textToSpeech/tts/pyttsx/drivers/sapi5.py",
		"modules/org/openteacher/textToSpeech/tts/pyttsx/drivers/nsss.py",
		"modules/org/openteacher/textToSpeech/tts/pyttsx/drivers/dummy.py",
		"modules/org/openteacher/textToSpeech/translations/ar.po",
		"modules/org/openteacher/textToSpeech/translations/es.mo",
		"modules/org/openteacher/textToSpeech/translations/es.po",
		"modules/org/openteacher/textToSpeech/translations/hu.mo",
		"modules/org/openteacher/textToSpeech/translations/org.openteacher.textToSpeech.pot",
		"modules/org/openteacher/textToSpeech/translations/fi.mo",
		"modules/org/openteacher/textToSpeech/translations/pt_BR.po",
		"modules/org/openteacher/textToSpeech/translations/nl.po",
		"modules/org/openteacher/textToSpeech/translations/de.mo",
		"modules/org/openteacher/textToSpeech/translations/pt_BR.mo",
		"modules/org/openteacher/textToSpeech/translations/fy.mo",
		"modules/org/openteacher/textToSpeech/translations/sk.po",
		"modules/org/openteacher/textToSpeech/translations/si.mo",
		"modules/org/openteacher/textToSpeech/translations/fr.po",
		"modules/org/openteacher/textToSpeech/translations/fr.mo",
		"modules/org/openteacher/textToSpeech/translations/sk.mo",
		"modules/org/openteacher/textToSpeech/translations/de.po",
		"modules/org/openteacher/textToSpeech/translations/ar.mo",
		"modules/org/openteacher/textToSpeech/translations/fi.po",
		"modules/org/openteacher/textToSpeech/translations/fy.po",
		"modules/org/openteacher/textToSpeech/translations/zh_TW.po",
		"modules/org/openteacher/textToSpeech/translations/zh_TW.mo",
		"modules/org/openteacher/textToSpeech/translations/hu.po",
		"modules/org/openteacher/textToSpeech/translations/nl.mo",
		"modules/org/openteacher/textToSpeech/translations/si.po",
		"modules/org/openteacher/buttonRegister/buttonRegister.py",
		"modules/org/openteacher/chars/test/test.py",
		"modules/org/openteacher/chars/symbols/symbols.py",
		"modules/org/openteacher/chars/symbols/translations/ar.po",
		"modules/org/openteacher/chars/symbols/translations/es.mo",
		"modules/org/openteacher/chars/symbols/translations/cs.mo",
		"modules/org/openteacher/chars/symbols/translations/zh_CN.po",
		"modules/org/openteacher/chars/symbols/translations/es.po",
		"modules/org/openteacher/chars/symbols/translations/hu.mo",
		"modules/org/openteacher/chars/symbols/translations/fi.mo",
		"modules/org/openteacher/chars/symbols/translations/pt_BR.po",
		"modules/org/openteacher/chars/symbols/translations/nl.po",
		"modules/org/openteacher/chars/symbols/translations/de.mo",
		"modules/org/openteacher/chars/symbols/translations/pt_BR.mo",
		"modules/org/openteacher/chars/symbols/translations/fy.mo",
		"modules/org/openteacher/chars/symbols/translations/el.po",
		"modules/org/openteacher/chars/symbols/translations/si.mo",
		"modules/org/openteacher/chars/symbols/translations/ja.mo",
		"modules/org/openteacher/chars/symbols/translations/fr.po",
		"modules/org/openteacher/chars/symbols/translations/fr.mo",
		"modules/org/openteacher/chars/symbols/translations/ja.po",
		"modules/org/openteacher/chars/symbols/translations/org.openteacher.chars.symbols.pot",
		"modules/org/openteacher/chars/symbols/translations/de.po",
		"modules/org/openteacher/chars/symbols/translations/cs.po",
		"modules/org/openteacher/chars/symbols/translations/ar.mo",
		"modules/org/openteacher/chars/symbols/translations/el.mo",
		"modules/org/openteacher/chars/symbols/translations/fi.po",
		"modules/org/openteacher/chars/symbols/translations/fy.po",
		"modules/org/openteacher/chars/symbols/translations/zh_TW.po",
		"modules/org/openteacher/chars/symbols/translations/zh_TW.mo",
		"modules/org/openteacher/chars/symbols/translations/hu.po",
		"modules/org/openteacher/chars/symbols/translations/zh_CN.mo",
		"modules/org/openteacher/chars/symbols/translations/nl.mo",
		"modules/org/openteacher/chars/symbols/translations/si.po",
		"modules/org/openteacher/chars/greek/greek.py",
		"modules/org/openteacher/chars/greek/translations/ar.po",
		"modules/org/openteacher/chars/greek/translations/es.mo",
		"modules/org/openteacher/chars/greek/translations/cs.mo",
		"modules/org/openteacher/chars/greek/translations/zh_CN.po",
		"modules/org/openteacher/chars/greek/translations/es.po",
		"modules/org/openteacher/chars/greek/translations/hu.mo",
		"modules/org/openteacher/chars/greek/translations/fi.mo",
		"modules/org/openteacher/chars/greek/translations/pt_BR.po",
		"modules/org/openteacher/chars/greek/translations/nl.po",
		"modules/org/openteacher/chars/greek/translations/de.mo",
		"modules/org/openteacher/chars/greek/translations/pt_BR.mo",
		"modules/org/openteacher/chars/greek/translations/fy.mo",
		"modules/org/openteacher/chars/greek/translations/el.po",
		"modules/org/openteacher/chars/greek/translations/si.mo",
		"modules/org/openteacher/chars/greek/translations/org.openteacher.chars.greek.pot",
		"modules/org/openteacher/chars/greek/translations/fr.po",
		"modules/org/openteacher/chars/greek/translations/fr.mo",
		"modules/org/openteacher/chars/greek/translations/de.po",
		"modules/org/openteacher/chars/greek/translations/cs.po",
		"modules/org/openteacher/chars/greek/translations/ar.mo",
		"modules/org/openteacher/chars/greek/translations/el.mo",
		"modules/org/openteacher/chars/greek/translations/fi.po",
		"modules/org/openteacher/chars/greek/translations/fy.po",
		"modules/org/openteacher/chars/greek/translations/zh_TW.po",
		"modules/org/openteacher/chars/greek/translations/zh_TW.mo",
		"modules/org/openteacher/chars/greek/translations/hu.po",
		"modules/org/openteacher/chars/greek/translations/zh_CN.mo",
		"modules/org/openteacher/chars/greek/translations/nl.mo",
		"modules/org/openteacher/chars/greek/translations/si.po",
		"modules/org/openteacher/chars/cyrillic/cyrillic.py",
		"modules/org/openteacher/chars/cyrillic/translations/ar.po",
		"modules/org/openteacher/chars/cyrillic/translations/es.mo",
		"modules/org/openteacher/chars/cyrillic/translations/cs.mo",
		"modules/org/openteacher/chars/cyrillic/translations/zh_CN.po",
		"modules/org/openteacher/chars/cyrillic/translations/org.openteacher.chars.cyrillic.pot",
		"modules/org/openteacher/chars/cyrillic/translations/es.po",
		"modules/org/openteacher/chars/cyrillic/translations/hu.mo",
		"modules/org/openteacher/chars/cyrillic/translations/fi.mo",
		"modules/org/openteacher/chars/cyrillic/translations/pt_BR.po",
		"modules/org/openteacher/chars/cyrillic/translations/nl.po",
		"modules/org/openteacher/chars/cyrillic/translations/de.mo",
		"modules/org/openteacher/chars/cyrillic/translations/pt_BR.mo",
		"modules/org/openteacher/chars/cyrillic/translations/fy.mo",
		"modules/org/openteacher/chars/cyrillic/translations/el.po",
		"modules/org/openteacher/chars/cyrillic/translations/fr.po",
		"modules/org/openteacher/chars/cyrillic/translations/fr.mo",
		"modules/org/openteacher/chars/cyrillic/translations/de.po",
		"modules/org/openteacher/chars/cyrillic/translations/cs.po",
		"modules/org/openteacher/chars/cyrillic/translations/ar.mo",
		"modules/org/openteacher/chars/cyrillic/translations/el.mo",
		"modules/org/openteacher/chars/cyrillic/translations/fi.po",
		"modules/org/openteacher/chars/cyrillic/translations/fy.po",
		"modules/org/openteacher/chars/cyrillic/translations/zh_TW.po",
		"modules/org/openteacher/chars/cyrillic/translations/zh_TW.mo",
		"modules/org/openteacher/chars/cyrillic/translations/hu.po",
		"modules/org/openteacher/chars/cyrillic/translations/zh_CN.mo",
		"modules/org/openteacher/chars/cyrillic/translations/nl.mo",
		"modules/org/openteacher/lessonDialogs/lessonDialogs.py",
		"modules/org/openteacher/lessonDialogs/translations/es.mo",
		"modules/org/openteacher/lessonDialogs/translations/es.po",
		"modules/org/openteacher/lessonDialogs/translations/fi.mo",
		"modules/org/openteacher/lessonDialogs/translations/pt_BR.po",
		"modules/org/openteacher/lessonDialogs/translations/nl.po",
		"modules/org/openteacher/lessonDialogs/translations/pt_BR.mo",
		"modules/org/openteacher/lessonDialogs/translations/fy.mo",
		"modules/org/openteacher/lessonDialogs/translations/fr.po",
		"modules/org/openteacher/lessonDialogs/translations/fr.mo",
		"modules/org/openteacher/lessonDialogs/translations/org.openteacher.lessonDialogs.pot",
		"modules/org/openteacher/lessonDialogs/translations/fi.po",
		"modules/org/openteacher/lessonDialogs/translations/fy.po",
		"modules/org/openteacher/lessonDialogs/translations/zh_TW.po",
		"modules/org/openteacher/lessonDialogs/translations/zh_TW.mo",
		"modules/org/openteacher/lessonDialogs/translations/nl.mo",
		"modules/org/openteacher/settings/settings.py",
		"modules/org/openteacher/recentlyOpened/recentlyOpened.py",
		"modules/org/openteacher/recentlyOpened/translations/org.openteacher.recentlyOpened.pot",
		"modules/org/openteacher/recentlyOpened/translations/es.mo",
		"modules/org/openteacher/recentlyOpened/translations/cs.mo",
		"modules/org/openteacher/recentlyOpened/translations/zh_CN.po",
		"modules/org/openteacher/recentlyOpened/translations/es.po",
		"modules/org/openteacher/recentlyOpened/translations/pt_BR.po",
		"modules/org/openteacher/recentlyOpened/translations/nl.po",
		"modules/org/openteacher/recentlyOpened/translations/de.mo",
		"modules/org/openteacher/recentlyOpened/translations/pt_BR.mo",
		"modules/org/openteacher/recentlyOpened/translations/fy.mo",
		"modules/org/openteacher/recentlyOpened/translations/fr.po",
		"modules/org/openteacher/recentlyOpened/translations/fr.mo",
		"modules/org/openteacher/recentlyOpened/translations/de.po",
		"modules/org/openteacher/recentlyOpened/translations/cs.po",
		"modules/org/openteacher/recentlyOpened/translations/fy.po",
		"modules/org/openteacher/recentlyOpened/translations/zh_TW.po",
		"modules/org/openteacher/recentlyOpened/translations/zh_TW.mo",
		"modules/org/openteacher/recentlyOpened/translations/zh_CN.mo",
		"modules/org/openteacher/recentlyOpened/translations/nl.mo",
		"modules/org/openteacher/metadata/openteacher.png",
		"modules/org/openteacher/metadata/license.txt",
		"modules/org/openteacher/metadata/comic.png",
		"modules/org/openteacher/metadata/metadata.py",
		"modules/org/openteacher/metadata/COPYING",
		"modules/org/openteacher/metadata/license_intro.txt",
		"modules/org/openteacher/metadata/translations/org.openteacher.listModifiers.metadata.pot",
		"modules/org/openteacher/metadata/translations/ar.po",
		"modules/org/openteacher/metadata/translations/es.mo",
		"modules/org/openteacher/metadata/translations/cs.mo",
		"modules/org/openteacher/metadata/translations/zh_CN.po",
		"modules/org/openteacher/metadata/translations/es.po",
		"modules/org/openteacher/metadata/translations/hu.mo",
		"modules/org/openteacher/metadata/translations/ru.po",
		"modules/org/openteacher/metadata/translations/fi.mo",
		"modules/org/openteacher/metadata/translations/pt_BR.po",
		"modules/org/openteacher/metadata/translations/nl.po",
		"modules/org/openteacher/metadata/translations/de.mo",
		"modules/org/openteacher/metadata/translations/pt_BR.mo",
		"modules/org/openteacher/metadata/translations/fy.mo",
		"modules/org/openteacher/metadata/translations/sk.po",
		"modules/org/openteacher/metadata/translations/el.po",
		"modules/org/openteacher/metadata/translations/si.mo",
		"modules/org/openteacher/metadata/translations/ja.mo",
		"modules/org/openteacher/metadata/translations/fr.po",
		"modules/org/openteacher/metadata/translations/fr.mo",
		"modules/org/openteacher/metadata/translations/sk.mo",
		"modules/org/openteacher/metadata/translations/ja.po",
		"modules/org/openteacher/metadata/translations/de.po",
		"modules/org/openteacher/metadata/translations/cs.po",
		"modules/org/openteacher/metadata/translations/ar.mo",
		"modules/org/openteacher/metadata/translations/el.mo",
		"modules/org/openteacher/metadata/translations/fi.po",
		"modules/org/openteacher/metadata/translations/ru.mo",
		"modules/org/openteacher/metadata/translations/fy.po",
		"modules/org/openteacher/metadata/translations/zh_TW.po",
		"modules/org/openteacher/metadata/translations/zh_TW.mo",
		"modules/org/openteacher/metadata/translations/hu.po",
		"modules/org/openteacher/metadata/translations/zh_CN.mo",
		"modules/org/openteacher/metadata/translations/nl.mo",
		"modules/org/openteacher/metadata/translations/si.po",
		"modules/org/openteacher/wordListString/parserTest/parserTest.py",
		"modules/org/openteacher/wordListString/javascriptParser/parser.js",
		"modules/org/openteacher/wordListString/javascriptParser/javascriptParser.py",
		"modules/org/openteacher/wordListString/composerTest/composerTest.py",
		"modules/org/openteacher/wordListString/parser/parser.py",
		"modules/org/openteacher/wordListString/javascriptComposer/javascriptComposer.py",
		"modules/org/openteacher/wordListString/javascriptComposer/composer.js",
		"modules/org/openteacher/mediaDisplay/mediaDisplay.py",
		"modules/org/openteacher/mediaDisplay/icons/player_play.png",
		"modules/org/openteacher/mediaDisplay/icons/player_pause.png",
		"modules/org/openteacher/mediaDisplay/icons/COPYING",
		"modules/org/openteacher/mediaDisplay/translations/es.mo",
		"modules/org/openteacher/mediaDisplay/translations/cs.mo",
		"modules/org/openteacher/mediaDisplay/translations/es.po",
		"modules/org/openteacher/mediaDisplay/translations/pt_BR.po",
		"modules/org/openteacher/mediaDisplay/translations/nl.po",
		"modules/org/openteacher/mediaDisplay/translations/pt_BR.mo",
		"modules/org/openteacher/mediaDisplay/translations/fy.mo",
		"modules/org/openteacher/mediaDisplay/translations/fr.po",
		"modules/org/openteacher/mediaDisplay/translations/fr.mo",
		"modules/org/openteacher/mediaDisplay/translations/cs.po",
		"modules/org/openteacher/mediaDisplay/translations/org.openteacher.mediaDisplay.pot",
		"modules/org/openteacher/mediaDisplay/translations/fy.po",
		"modules/org/openteacher/mediaDisplay/translations/zh_TW.po",
		"modules/org/openteacher/mediaDisplay/translations/zh_TW.mo",
		"modules/org/openteacher/mediaDisplay/translations/nl.mo",
		"modules/org/openteacher/sourceSaver/sourceSaver.py",
		"modules/org/openteacher/updates/updates.py",
		"modules/org/openteacher/onscreenKeyboard/onscreenKeyboard.py",
		"modules/org/openteacher/lessonTypes/allOnce/allOnce.py",
		"modules/org/openteacher/lessonTypes/allOnce/translations/ar.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/es.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/cs.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/es.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/hu.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/ru.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/fi.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/pt_BR.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/mus.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/nl.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/de.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/pt_BR.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/fy.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/sk.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/el.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/si.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/ja.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/fr.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/fr.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/sk.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/ja.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/mus.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/de.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/cs.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/ar.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/el.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/fi.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/ru.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/fy.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/zh_TW.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/zh_TW.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/hu.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/nl.mo",
		"modules/org/openteacher/lessonTypes/allOnce/translations/si.po",
		"modules/org/openteacher/lessonTypes/allOnce/translations/org.openteacher.lessonTypes.allOnce.pot",
		"modules/org/openteacher/lessonTypes/smart/smart.py",
		"modules/org/openteacher/lessonTypes/smart/translations/ar.po",
		"modules/org/openteacher/lessonTypes/smart/translations/es.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/cs.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/zh_CN.po",
		"modules/org/openteacher/lessonTypes/smart/translations/es.po",
		"modules/org/openteacher/lessonTypes/smart/translations/org.openteacher.lessonTypes.smart.pot",
		"modules/org/openteacher/lessonTypes/smart/translations/hu.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/fi.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/pt_BR.po",
		"modules/org/openteacher/lessonTypes/smart/translations/nl.po",
		"modules/org/openteacher/lessonTypes/smart/translations/de.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/pt_BR.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/fy.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/sk.po",
		"modules/org/openteacher/lessonTypes/smart/translations/el.po",
		"modules/org/openteacher/lessonTypes/smart/translations/ja.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/fr.po",
		"modules/org/openteacher/lessonTypes/smart/translations/fr.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/sk.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/ja.po",
		"modules/org/openteacher/lessonTypes/smart/translations/de.po",
		"modules/org/openteacher/lessonTypes/smart/translations/cs.po",
		"modules/org/openteacher/lessonTypes/smart/translations/ar.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/el.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/fi.po",
		"modules/org/openteacher/lessonTypes/smart/translations/fy.po",
		"modules/org/openteacher/lessonTypes/smart/translations/zh_TW.po",
		"modules/org/openteacher/lessonTypes/smart/translations/zh_TW.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/hu.po",
		"modules/org/openteacher/lessonTypes/smart/translations/zh_CN.mo",
		"modules/org/openteacher/lessonTypes/smart/translations/nl.mo",
		"modules/org/openteacher/lessonTypes/interval/interval.py",
		"modules/org/openteacher/lessonTypes/interval/translations/ar.po",
		"modules/org/openteacher/lessonTypes/interval/translations/es.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/cs.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/zh_CN.po",
		"modules/org/openteacher/lessonTypes/interval/translations/es.po",
		"modules/org/openteacher/lessonTypes/interval/translations/hu.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/ru.po",
		"modules/org/openteacher/lessonTypes/interval/translations/fi.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/pt_BR.po",
		"modules/org/openteacher/lessonTypes/interval/translations/nl.po",
		"modules/org/openteacher/lessonTypes/interval/translations/de.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/pt_BR.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/fy.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/el.po",
		"modules/org/openteacher/lessonTypes/interval/translations/si.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/org.openteacher.lessonTypes.interval.pot",
		"modules/org/openteacher/lessonTypes/interval/translations/ja.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/fr.po",
		"modules/org/openteacher/lessonTypes/interval/translations/fr.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/ja.po",
		"modules/org/openteacher/lessonTypes/interval/translations/de.po",
		"modules/org/openteacher/lessonTypes/interval/translations/cs.po",
		"modules/org/openteacher/lessonTypes/interval/translations/ar.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/el.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/fi.po",
		"modules/org/openteacher/lessonTypes/interval/translations/ru.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/fy.po",
		"modules/org/openteacher/lessonTypes/interval/translations/zh_TW.po",
		"modules/org/openteacher/lessonTypes/interval/translations/zh_TW.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/hu.po",
		"modules/org/openteacher/lessonTypes/interval/translations/zh_CN.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/nl.mo",
		"modules/org/openteacher/lessonTypes/interval/translations/si.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/wordsNeverAnsweredCorrectly.py",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/ar.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/es.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/cs.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/zh_CN.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/es.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/hu.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/ru.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/fi.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/pt_BR.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/nl.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/de.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/pt_BR.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/fy.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/sk.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/el.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/ja.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/fr.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/fr.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/sk.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/ja.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/de.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/cs.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/ar.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/org.openteacher.listModifiers.wordsNeverAnsweredCorrectly.pot",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/el.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/fi.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/ru.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/fy.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/zh_TW.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/zh_TW.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/hu.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/zh_CN.mo",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectly/translations/nl.mo",
		"modules/org/openteacher/listModifiers/reverse/reverse.py",
		"modules/org/openteacher/listModifiers/reverse/translations/ar.po",
		"modules/org/openteacher/listModifiers/reverse/translations/es.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/cs.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/zh_CN.po",
		"modules/org/openteacher/listModifiers/reverse/translations/af.po",
		"modules/org/openteacher/listModifiers/reverse/translations/es.po",
		"modules/org/openteacher/listModifiers/reverse/translations/hu.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/af.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/ru.po",
		"modules/org/openteacher/listModifiers/reverse/translations/fi.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/pt_BR.po",
		"modules/org/openteacher/listModifiers/reverse/translations/nl.po",
		"modules/org/openteacher/listModifiers/reverse/translations/de.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/pt_BR.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/org.openteacher.listModifiers.reverse.pot",
		"modules/org/openteacher/listModifiers/reverse/translations/fy.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/sk.po",
		"modules/org/openteacher/listModifiers/reverse/translations/el.po",
		"modules/org/openteacher/listModifiers/reverse/translations/si.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/ja.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/fr.po",
		"modules/org/openteacher/listModifiers/reverse/translations/fr.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/sk.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/ja.po",
		"modules/org/openteacher/listModifiers/reverse/translations/de.po",
		"modules/org/openteacher/listModifiers/reverse/translations/cs.po",
		"modules/org/openteacher/listModifiers/reverse/translations/ar.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/el.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/fi.po",
		"modules/org/openteacher/listModifiers/reverse/translations/ru.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/fy.po",
		"modules/org/openteacher/listModifiers/reverse/translations/zh_TW.po",
		"modules/org/openteacher/listModifiers/reverse/translations/zh_TW.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/hu.po",
		"modules/org/openteacher/listModifiers/reverse/translations/zh_CN.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/nl.mo",
		"modules/org/openteacher/listModifiers/reverse/translations/si.po",
		"modules/org/openteacher/listModifiers/random_/random_.py",
		"modules/org/openteacher/listModifiers/random_/translations/ar.po",
		"modules/org/openteacher/listModifiers/random_/translations/es.mo",
		"modules/org/openteacher/listModifiers/random_/translations/cs.mo",
		"modules/org/openteacher/listModifiers/random_/translations/zh_CN.po",
		"modules/org/openteacher/listModifiers/random_/translations/es.po",
		"modules/org/openteacher/listModifiers/random_/translations/hu.mo",
		"modules/org/openteacher/listModifiers/random_/translations/ru.po",
		"modules/org/openteacher/listModifiers/random_/translations/fi.mo",
		"modules/org/openteacher/listModifiers/random_/translations/pt_BR.po",
		"modules/org/openteacher/listModifiers/random_/translations/nl.po",
		"modules/org/openteacher/listModifiers/random_/translations/de.mo",
		"modules/org/openteacher/listModifiers/random_/translations/pt_BR.mo",
		"modules/org/openteacher/listModifiers/random_/translations/org.openteacher.listModifiers.random_.pot",
		"modules/org/openteacher/listModifiers/random_/translations/fy.mo",
		"modules/org/openteacher/listModifiers/random_/translations/sk.po",
		"modules/org/openteacher/listModifiers/random_/translations/el.po",
		"modules/org/openteacher/listModifiers/random_/translations/si.mo",
		"modules/org/openteacher/listModifiers/random_/translations/ja.mo",
		"modules/org/openteacher/listModifiers/random_/translations/fr.po",
		"modules/org/openteacher/listModifiers/random_/translations/fr.mo",
		"modules/org/openteacher/listModifiers/random_/translations/sk.mo",
		"modules/org/openteacher/listModifiers/random_/translations/ja.po",
		"modules/org/openteacher/listModifiers/random_/translations/de.po",
		"modules/org/openteacher/listModifiers/random_/translations/cs.po",
		"modules/org/openteacher/listModifiers/random_/translations/ar.mo",
		"modules/org/openteacher/listModifiers/random_/translations/el.mo",
		"modules/org/openteacher/listModifiers/random_/translations/fi.po",
		"modules/org/openteacher/listModifiers/random_/translations/ru.mo",
		"modules/org/openteacher/listModifiers/random_/translations/fy.po",
		"modules/org/openteacher/listModifiers/random_/translations/zh_TW.po",
		"modules/org/openteacher/listModifiers/random_/translations/zh_TW.mo",
		"modules/org/openteacher/listModifiers/random_/translations/hu.po",
		"modules/org/openteacher/listModifiers/random_/translations/zh_CN.mo",
		"modules/org/openteacher/listModifiers/random_/translations/nl.mo",
		"modules/org/openteacher/listModifiers/random_/translations/si.po",
		"modules/org/openteacher/listModifiers/hardWords/hardWords.py",
		"modules/org/openteacher/listModifiers/hardWords/translations/ar.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/es.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/cs.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/org.openteacher.listModifiers.hardWords.pot",
		"modules/org/openteacher/listModifiers/hardWords/translations/zh_CN.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/es.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/hu.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/ru.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/fi.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/pt_BR.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/nl.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/de.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/pt_BR.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/fy.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/sk.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/el.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/ja.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/fr.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/fr.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/sk.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/ja.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/de.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/cs.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/ar.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/el.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/fi.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/ru.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/fy.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/zh_TW.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/zh_TW.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/hu.po",
		"modules/org/openteacher/listModifiers/hardWords/translations/zh_CN.mo",
		"modules/org/openteacher/listModifiers/hardWords/translations/nl.mo",
		"modules/org/openteacher/listModifiers/sort/sort.py",
		"modules/org/openteacher/listModifiers/sort/translations/ar.po",
		"modules/org/openteacher/listModifiers/sort/translations/es.mo",
		"modules/org/openteacher/listModifiers/sort/translations/cs.mo",
		"modules/org/openteacher/listModifiers/sort/translations/zh_CN.po",
		"modules/org/openteacher/listModifiers/sort/translations/af.po",
		"modules/org/openteacher/listModifiers/sort/translations/es.po",
		"modules/org/openteacher/listModifiers/sort/translations/hu.mo",
		"modules/org/openteacher/listModifiers/sort/translations/af.mo",
		"modules/org/openteacher/listModifiers/sort/translations/ru.po",
		"modules/org/openteacher/listModifiers/sort/translations/fi.mo",
		"modules/org/openteacher/listModifiers/sort/translations/pt_BR.po",
		"modules/org/openteacher/listModifiers/sort/translations/nl.po",
		"modules/org/openteacher/listModifiers/sort/translations/de.mo",
		"modules/org/openteacher/listModifiers/sort/translations/pt_BR.mo",
		"modules/org/openteacher/listModifiers/sort/translations/fy.mo",
		"modules/org/openteacher/listModifiers/sort/translations/sk.po",
		"modules/org/openteacher/listModifiers/sort/translations/el.po",
		"modules/org/openteacher/listModifiers/sort/translations/si.mo",
		"modules/org/openteacher/listModifiers/sort/translations/ja.mo",
		"modules/org/openteacher/listModifiers/sort/translations/fr.po",
		"modules/org/openteacher/listModifiers/sort/translations/fr.mo",
		"modules/org/openteacher/listModifiers/sort/translations/sk.mo",
		"modules/org/openteacher/listModifiers/sort/translations/ja.po",
		"modules/org/openteacher/listModifiers/sort/translations/de.po",
		"modules/org/openteacher/listModifiers/sort/translations/cs.po",
		"modules/org/openteacher/listModifiers/sort/translations/ar.mo",
		"modules/org/openteacher/listModifiers/sort/translations/el.mo",
		"modules/org/openteacher/listModifiers/sort/translations/fi.po",
		"modules/org/openteacher/listModifiers/sort/translations/ru.mo",
		"modules/org/openteacher/listModifiers/sort/translations/fy.po",
		"modules/org/openteacher/listModifiers/sort/translations/zh_TW.po",
		"modules/org/openteacher/listModifiers/sort/translations/zh_TW.mo",
		"modules/org/openteacher/listModifiers/sort/translations/hu.po",
		"modules/org/openteacher/listModifiers/sort/translations/org.openteacher.listModifiers.sort.pot",
		"modules/org/openteacher/listModifiers/sort/translations/zh_CN.mo",
		"modules/org/openteacher/listModifiers/sort/translations/nl.mo",
		"modules/org/openteacher/listModifiers/sort/translations/si.po",
		"modules/org/openteacher/listModifiers/wordsNeverAnsweredCorrectlyTest/wordsNeverAnsweredCorrectlyTest.py",
		"modules/org/openteacher/listModifiers/hardWordsTest/hardWordsTest.py",
		"modules/org/openteacher/noteCalculatorChooser/noteCalculatorChooser.py",
		"modules/org/openteacher/noteCalculatorChooser/translations/es.mo",
		"modules/org/openteacher/noteCalculatorChooser/translations/es.po",
		"modules/org/openteacher/noteCalculatorChooser/translations/pt_BR.po",
		"modules/org/openteacher/noteCalculatorChooser/translations/nl.po",
		"modules/org/openteacher/noteCalculatorChooser/translations/pt_BR.mo",
		"modules/org/openteacher/noteCalculatorChooser/translations/fy.mo",
		"modules/org/openteacher/noteCalculatorChooser/translations/fy.po",
		"modules/org/openteacher/noteCalculatorChooser/translations/zh_TW.po",
		"modules/org/openteacher/noteCalculatorChooser/translations/org.openteacher.noteCalculatorChooser.pot",
		"modules/org/openteacher/noteCalculatorChooser/translations/zh_TW.mo",
		"modules/org/openteacher/noteCalculatorChooser/translations/nl.mo",
		"modules/org/openteacher/settingsWidget/longText/longText.py",
		"modules/org/openteacher/settingsWidget/password/password.py",
		"modules/org/openteacher/settingsWidget/language/language.py",
		"modules/org/openteacher/settingsWidget/language/translations/ar.po",
		"modules/org/openteacher/settingsWidget/language/translations/es.mo",
		"modules/org/openteacher/settingsWidget/language/translations/cs.mo",
		"modules/org/openteacher/settingsWidget/language/translations/zh_CN.po",
		"modules/org/openteacher/settingsWidget/language/translations/af.po",
		"modules/org/openteacher/settingsWidget/language/translations/es.po",
		"modules/org/openteacher/settingsWidget/language/translations/hu.mo",
		"modules/org/openteacher/settingsWidget/language/translations/af.mo",
		"modules/org/openteacher/settingsWidget/language/translations/ru.po",
		"modules/org/openteacher/settingsWidget/language/translations/fi.mo",
		"modules/org/openteacher/settingsWidget/language/translations/pt_BR.po",
		"modules/org/openteacher/settingsWidget/language/translations/nl.po",
		"modules/org/openteacher/settingsWidget/language/translations/de.mo",
		"modules/org/openteacher/settingsWidget/language/translations/pt_BR.mo",
		"modules/org/openteacher/settingsWidget/language/translations/fy.mo",
		"modules/org/openteacher/settingsWidget/language/translations/el.po",
		"modules/org/openteacher/settingsWidget/language/translations/si.mo",
		"modules/org/openteacher/settingsWidget/language/translations/ja.mo",
		"modules/org/openteacher/settingsWidget/language/translations/fr.po",
		"modules/org/openteacher/settingsWidget/language/translations/fr.mo",
		"modules/org/openteacher/settingsWidget/language/translations/ja.po",
		"modules/org/openteacher/settingsWidget/language/translations/de.po",
		"modules/org/openteacher/settingsWidget/language/translations/cs.po",
		"modules/org/openteacher/settingsWidget/language/translations/org.openteacher.languageChooser.pot",
		"modules/org/openteacher/settingsWidget/language/translations/ar.mo",
		"modules/org/openteacher/settingsWidget/language/translations/el.mo",
		"modules/org/openteacher/settingsWidget/language/translations/fi.po",
		"modules/org/openteacher/settingsWidget/language/translations/ru.mo",
		"modules/org/openteacher/settingsWidget/language/translations/fy.po",
		"modules/org/openteacher/settingsWidget/language/translations/zh_TW.po",
		"modules/org/openteacher/settingsWidget/language/translations/zh_TW.mo",
		"modules/org/openteacher/settingsWidget/language/translations/hu.po",
		"modules/org/openteacher/settingsWidget/language/translations/zh_CN.mo",
		"modules/org/openteacher/settingsWidget/language/translations/nl.mo",
		"modules/org/openteacher/settingsWidget/language/translations/si.po",
		"modules/org/openteacher/settingsWidget/shortText/shortText.py",
		"modules/org/openteacher/settingsWidget/profile/profile.py",
		"modules/org/openteacher/settingsWidget/characterTable/characterTable.py",
		"modules/org/openteacher/settingsWidget/boolean/boolean.py",
		"modules/org/openteacher/settingsWidget/number/number.py",
		"modules/org/openteacher/settingsWidget/option/option.py",
		"modules/org/openteacher/settingsWidget/multiOption/multiOption.py",
		"modules/org/openteacher/hiddenBrowser/hiddenBrowser.py",
		"modules/org/openteacher/hiddenBrowser/icons/reload.png",
		"modules/org/openteacher/hiddenBrowser/icons/forward.png",
		"modules/org/openteacher/hiddenBrowser/icons/COPYING",
		"modules/org/openteacher/hiddenBrowser/icons/back.png",
		"modules/org/openteacher/hiddenBrowser/translations/es.mo",
		"modules/org/openteacher/hiddenBrowser/translations/org.openteacher.hiddenBrowser.pot",
		"modules/org/openteacher/hiddenBrowser/translations/es.po",
		"modules/org/openteacher/hiddenBrowser/translations/fi.mo",
		"modules/org/openteacher/hiddenBrowser/translations/pt_BR.po",
		"modules/org/openteacher/hiddenBrowser/translations/nl.po",
		"modules/org/openteacher/hiddenBrowser/translations/pt_BR.mo",
		"modules/org/openteacher/hiddenBrowser/translations/fy.mo",
		"modules/org/openteacher/hiddenBrowser/translations/fi.po",
		"modules/org/openteacher/hiddenBrowser/translations/fy.po",
		"modules/org/openteacher/hiddenBrowser/translations/zh_TW.po",
		"modules/org/openteacher/hiddenBrowser/translations/zh_TW.mo",
		"modules/org/openteacher/hiddenBrowser/translations/nl.mo",
		"modules/org/openteacher/loaders/ottp/ottp.py",
		"modules/org/openteacher/loaders/ottp/translations/es.mo",
		"modules/org/openteacher/loaders/ottp/translations/cs.mo",
		"modules/org/openteacher/loaders/ottp/translations/es.po",
		"modules/org/openteacher/loaders/ottp/translations/fi.mo",
		"modules/org/openteacher/loaders/ottp/translations/pt_BR.po",
		"modules/org/openteacher/loaders/ottp/translations/nl.po",
		"modules/org/openteacher/loaders/ottp/translations/de.mo",
		"modules/org/openteacher/loaders/ottp/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/ottp/translations/fy.mo",
		"modules/org/openteacher/loaders/ottp/translations/fr.po",
		"modules/org/openteacher/loaders/ottp/translations/fr.mo",
		"modules/org/openteacher/loaders/ottp/translations/de.po",
		"modules/org/openteacher/loaders/ottp/translations/org.openteacher.loaders.ottp.pot",
		"modules/org/openteacher/loaders/ottp/translations/cs.po",
		"modules/org/openteacher/loaders/ottp/translations/fi.po",
		"modules/org/openteacher/loaders/ottp/translations/fy.po",
		"modules/org/openteacher/loaders/ottp/translations/zh_TW.po",
		"modules/org/openteacher/loaders/ottp/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/ottp/translations/nl.mo",
		"modules/org/openteacher/loaders/otmd/otmd.py",
		"modules/org/openteacher/loaders/otmd/translations/es.mo",
		"modules/org/openteacher/loaders/otmd/translations/cs.mo",
		"modules/org/openteacher/loaders/otmd/translations/zh_CN.po",
		"modules/org/openteacher/loaders/otmd/translations/es.po",
		"modules/org/openteacher/loaders/otmd/translations/fi.mo",
		"modules/org/openteacher/loaders/otmd/translations/pt_BR.po",
		"modules/org/openteacher/loaders/otmd/translations/nl.po",
		"modules/org/openteacher/loaders/otmd/translations/de.mo",
		"modules/org/openteacher/loaders/otmd/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/otmd/translations/fy.mo",
		"modules/org/openteacher/loaders/otmd/translations/org.openteacher.loaders.otmd.pot",
		"modules/org/openteacher/loaders/otmd/translations/fr.po",
		"modules/org/openteacher/loaders/otmd/translations/fr.mo",
		"modules/org/openteacher/loaders/otmd/translations/de.po",
		"modules/org/openteacher/loaders/otmd/translations/cs.po",
		"modules/org/openteacher/loaders/otmd/translations/fi.po",
		"modules/org/openteacher/loaders/otmd/translations/fy.po",
		"modules/org/openteacher/loaders/otmd/translations/zh_TW.po",
		"modules/org/openteacher/loaders/otmd/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/otmd/translations/zh_CN.mo",
		"modules/org/openteacher/loaders/otmd/translations/nl.mo",
		"modules/org/openteacher/loaders/wrts/wrts.py",
		"modules/org/openteacher/loaders/wrts/translations/es.mo",
		"modules/org/openteacher/loaders/wrts/translations/cs.mo",
		"modules/org/openteacher/loaders/wrts/translations/zh_CN.po",
		"modules/org/openteacher/loaders/wrts/translations/es.po",
		"modules/org/openteacher/loaders/wrts/translations/fi.mo",
		"modules/org/openteacher/loaders/wrts/translations/pt_BR.po",
		"modules/org/openteacher/loaders/wrts/translations/nl.po",
		"modules/org/openteacher/loaders/wrts/translations/de.mo",
		"modules/org/openteacher/loaders/wrts/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/wrts/translations/fy.mo",
		"modules/org/openteacher/loaders/wrts/translations/si.mo",
		"modules/org/openteacher/loaders/wrts/translations/fr.po",
		"modules/org/openteacher/loaders/wrts/translations/fr.mo",
		"modules/org/openteacher/loaders/wrts/translations/de.po",
		"modules/org/openteacher/loaders/wrts/translations/cs.po",
		"modules/org/openteacher/loaders/wrts/translations/org.openteacher.loaders.wrts.pot",
		"modules/org/openteacher/loaders/wrts/translations/fi.po",
		"modules/org/openteacher/loaders/wrts/translations/fy.po",
		"modules/org/openteacher/loaders/wrts/translations/zh_TW.po",
		"modules/org/openteacher/loaders/wrts/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/wrts/translations/zh_CN.mo",
		"modules/org/openteacher/loaders/wrts/translations/nl.mo",
		"modules/org/openteacher/loaders/wrts/translations/si.po",
		"modules/org/openteacher/loaders/otwd/otwd.py",
		"modules/org/openteacher/loaders/otwd/translations/es.mo",
		"modules/org/openteacher/loaders/otwd/translations/cs.mo",
		"modules/org/openteacher/loaders/otwd/translations/zh_CN.po",
		"modules/org/openteacher/loaders/otwd/translations/es.po",
		"modules/org/openteacher/loaders/otwd/translations/fi.mo",
		"modules/org/openteacher/loaders/otwd/translations/pt_BR.po",
		"modules/org/openteacher/loaders/otwd/translations/nl.po",
		"modules/org/openteacher/loaders/otwd/translations/de.mo",
		"modules/org/openteacher/loaders/otwd/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/otwd/translations/fy.mo",
		"modules/org/openteacher/loaders/otwd/translations/fr.po",
		"modules/org/openteacher/loaders/otwd/translations/org.openteacher.loaders.otwd.pot",
		"modules/org/openteacher/loaders/otwd/translations/fr.mo",
		"modules/org/openteacher/loaders/otwd/translations/de.po",
		"modules/org/openteacher/loaders/otwd/translations/cs.po",
		"modules/org/openteacher/loaders/otwd/translations/fi.po",
		"modules/org/openteacher/loaders/otwd/translations/fy.po",
		"modules/org/openteacher/loaders/otwd/translations/zh_TW.po",
		"modules/org/openteacher/loaders/otwd/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/otwd/translations/zh_CN.mo",
		"modules/org/openteacher/loaders/otwd/translations/nl.mo",
		"modules/org/openteacher/loaders/abby/abby.py",
		"modules/org/openteacher/loaders/abby/translations/es.mo",
		"modules/org/openteacher/loaders/abby/translations/es.po",
		"modules/org/openteacher/loaders/abby/translations/fi.mo",
		"modules/org/openteacher/loaders/abby/translations/pt_BR.po",
		"modules/org/openteacher/loaders/abby/translations/nl.po",
		"modules/org/openteacher/loaders/abby/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/abby/translations/fy.mo",
		"modules/org/openteacher/loaders/abby/translations/org.openteacher.loaders.abby.pot",
		"modules/org/openteacher/loaders/abby/translations/fi.po",
		"modules/org/openteacher/loaders/abby/translations/fy.po",
		"modules/org/openteacher/loaders/abby/translations/zh_TW.po",
		"modules/org/openteacher/loaders/abby/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/abby/translations/nl.mo",
		"modules/org/openteacher/loaders/ot/ot.py",
		"modules/org/openteacher/loaders/ot/translations/ar.po",
		"modules/org/openteacher/loaders/ot/translations/es.mo",
		"modules/org/openteacher/loaders/ot/translations/cs.mo",
		"modules/org/openteacher/loaders/ot/translations/zh_CN.po",
		"modules/org/openteacher/loaders/ot/translations/es.po",
		"modules/org/openteacher/loaders/ot/translations/fi.mo",
		"modules/org/openteacher/loaders/ot/translations/pt_BR.po",
		"modules/org/openteacher/loaders/ot/translations/nl.po",
		"modules/org/openteacher/loaders/ot/translations/de.mo",
		"modules/org/openteacher/loaders/ot/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/ot/translations/fy.mo",
		"modules/org/openteacher/loaders/ot/translations/org.openteacher.loaders.ot.pot",
		"modules/org/openteacher/loaders/ot/translations/si.mo",
		"modules/org/openteacher/loaders/ot/translations/fr.po",
		"modules/org/openteacher/loaders/ot/translations/fr.mo",
		"modules/org/openteacher/loaders/ot/translations/de.po",
		"modules/org/openteacher/loaders/ot/translations/cs.po",
		"modules/org/openteacher/loaders/ot/translations/ar.mo",
		"modules/org/openteacher/loaders/ot/translations/fi.po",
		"modules/org/openteacher/loaders/ot/translations/fy.po",
		"modules/org/openteacher/loaders/ot/translations/zh_TW.po",
		"modules/org/openteacher/loaders/ot/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/ot/translations/zh_CN.mo",
		"modules/org/openteacher/loaders/ot/translations/nl.mo",
		"modules/org/openteacher/loaders/ot/translations/si.po",
		"modules/org/openteacher/loaders/t2k/t2k.py",
		"modules/org/openteacher/loaders/t2k/translations/es.mo",
		"modules/org/openteacher/loaders/t2k/translations/cs.mo",
		"modules/org/openteacher/loaders/t2k/translations/zh_CN.po",
		"modules/org/openteacher/loaders/t2k/translations/org.openteacher.loaders.t2k.pot",
		"modules/org/openteacher/loaders/t2k/translations/es.po",
		"modules/org/openteacher/loaders/t2k/translations/fi.mo",
		"modules/org/openteacher/loaders/t2k/translations/pt_BR.po",
		"modules/org/openteacher/loaders/t2k/translations/nl.po",
		"modules/org/openteacher/loaders/t2k/translations/de.mo",
		"modules/org/openteacher/loaders/t2k/translations/pt_BR.mo",
		"modules/org/openteacher/loaders/t2k/translations/fy.mo",
		"modules/org/openteacher/loaders/t2k/translations/si.mo",
		"modules/org/openteacher/loaders/t2k/translations/fr.po",
		"modules/org/openteacher/loaders/t2k/translations/fr.mo",
		"modules/org/openteacher/loaders/t2k/translations/de.po",
		"modules/org/openteacher/loaders/t2k/translations/cs.po",
		"modules/org/openteacher/loaders/t2k/translations/fi.po",
		"modules/org/openteacher/loaders/t2k/translations/fy.po",
		"modules/org/openteacher/loaders/t2k/translations/zh_TW.po",
		"modules/org/openteacher/loaders/t2k/translations/zh_TW.mo",
		"modules/org/openteacher/loaders/t2k/translations/zh_CN.mo",
		"modules/org/openteacher/loaders/t2k/translations/nl.mo",
		"modules/org/openteacher/loaders/t2k/translations/si.po",
		"modules/org/openteacher/dialogs/settings/settings.py",
		"modules/org/openteacher/dialogs/settings/translations/ar.po",
		"modules/org/openteacher/dialogs/settings/translations/es.mo",
		"modules/org/openteacher/dialogs/settings/translations/cs.mo",
		"modules/org/openteacher/dialogs/settings/translations/zh_CN.po",
		"modules/org/openteacher/dialogs/settings/translations/es.po",
		"modules/org/openteacher/dialogs/settings/translations/hu.mo",
		"modules/org/openteacher/dialogs/settings/translations/fi.mo",
		"modules/org/openteacher/dialogs/settings/translations/pt_BR.po",
		"modules/org/openteacher/dialogs/settings/translations/nl.po",
		"modules/org/openteacher/dialogs/settings/translations/de.mo",
		"modules/org/openteacher/dialogs/settings/translations/pt_BR.mo",
		"modules/org/openteacher/dialogs/settings/translations/fy.mo",
		"modules/org/openteacher/dialogs/settings/translations/sk.po",
		"modules/org/openteacher/dialogs/settings/translations/el.po",
		"modules/org/openteacher/dialogs/settings/translations/org.openteacher.settingsDialog.pot",
		"modules/org/openteacher/dialogs/settings/translations/si.mo",
		"modules/org/openteacher/dialogs/settings/translations/ja.mo",
		"modules/org/openteacher/dialogs/settings/translations/fr.po",
		"modules/org/openteacher/dialogs/settings/translations/fr.mo",
		"modules/org/openteacher/dialogs/settings/translations/sk.mo",
		"modules/org/openteacher/dialogs/settings/translations/ja.po",
		"modules/org/openteacher/dialogs/settings/translations/de.po",
		"modules/org/openteacher/dialogs/settings/translations/cs.po",
		"modules/org/openteacher/dialogs/settings/translations/ar.mo",
		"modules/org/openteacher/dialogs/settings/translations/el.mo",
		"modules/org/openteacher/dialogs/settings/translations/fi.po",
		"modules/org/openteacher/dialogs/settings/translations/fy.po",
		"modules/org/openteacher/dialogs/settings/translations/zh_TW.po",
		"modules/org/openteacher/dialogs/settings/translations/zh_TW.mo",
		"modules/org/openteacher/dialogs/settings/translations/hu.po",
		"modules/org/openteacher/dialogs/settings/translations/zh_CN.mo",
		"modules/org/openteacher/dialogs/settings/translations/nl.mo",
		"modules/org/openteacher/dialogs/settings/translations/si.po",
		"modules/org/openteacher/dialogs/file/file.py",
		"modules/org/openteacher/dialogs/updates/updates.py",
		"modules/org/openteacher/dialogs/updates/translations/es.mo",
		"modules/org/openteacher/dialogs/updates/translations/cs.mo",
		"modules/org/openteacher/dialogs/updates/translations/zh_CN.po",
		"modules/org/openteacher/dialogs/updates/translations/es.po",
		"modules/org/openteacher/dialogs/updates/translations/fi.mo",
		"modules/org/openteacher/dialogs/updates/translations/pt_BR.po",
		"modules/org/openteacher/dialogs/updates/translations/nl.po",
		"modules/org/openteacher/dialogs/updates/translations/de.mo",
		"modules/org/openteacher/dialogs/updates/translations/pt_BR.mo",
		"modules/org/openteacher/dialogs/updates/translations/fr.po",
		"modules/org/openteacher/dialogs/updates/translations/fr.mo",
		"modules/org/openteacher/dialogs/updates/translations/de.po",
		"modules/org/openteacher/dialogs/updates/translations/cs.po",
		"modules/org/openteacher/dialogs/updates/translations/org.openteacher.dialogs.updates.pot",
		"modules/org/openteacher/dialogs/updates/translations/fi.po",
		"modules/org/openteacher/dialogs/updates/translations/zh_TW.po",
		"modules/org/openteacher/dialogs/updates/translations/zh_TW.mo",
		"modules/org/openteacher/dialogs/updates/translations/zh_CN.mo",
		"modules/org/openteacher/dialogs/updates/translations/nl.mo",
		"modules/org/openteacher/dialogs/about/about.html",
		"modules/org/openteacher/dialogs/about/about.py",
		"modules/org/openteacher/dialogs/about/translations/ar.po",
		"modules/org/openteacher/dialogs/about/translations/es.mo",
		"modules/org/openteacher/dialogs/about/translations/cs.mo",
		"modules/org/openteacher/dialogs/about/translations/zh_CN.po",
		"modules/org/openteacher/dialogs/about/translations/es.po",
		"modules/org/openteacher/dialogs/about/translations/hu.mo",
		"modules/org/openteacher/dialogs/about/translations/fi.mo",
		"modules/org/openteacher/dialogs/about/translations/pt_BR.po",
		"modules/org/openteacher/dialogs/about/translations/nl.po",
		"modules/org/openteacher/dialogs/about/translations/de.mo",
		"modules/org/openteacher/dialogs/about/translations/pt_BR.mo",
		"modules/org/openteacher/dialogs/about/translations/fy.mo",
		"modules/org/openteacher/dialogs/about/translations/sk.po",
		"modules/org/openteacher/dialogs/about/translations/el.po",
		"modules/org/openteacher/dialogs/about/translations/si.mo",
		"modules/org/openteacher/dialogs/about/translations/fr.po",
		"modules/org/openteacher/dialogs/about/translations/fr.mo",
		"modules/org/openteacher/dialogs/about/translations/sk.mo",
		"modules/org/openteacher/dialogs/about/translations/de.po",
		"modules/org/openteacher/dialogs/about/translations/cs.po",
		"modules/org/openteacher/dialogs/about/translations/ar.mo",
		"modules/org/openteacher/dialogs/about/translations/el.mo",
		"modules/org/openteacher/dialogs/about/translations/fi.po",
		"modules/org/openteacher/dialogs/about/translations/fy.po",
		"modules/org/openteacher/dialogs/about/translations/zh_TW.po",
		"modules/org/openteacher/dialogs/about/translations/zh_TW.mo",
		"modules/org/openteacher/dialogs/about/translations/hu.po",
		"modules/org/openteacher/dialogs/about/translations/zh_CN.mo",
		"modules/org/openteacher/dialogs/about/translations/nl.mo",
		"modules/org/openteacher/dialogs/about/translations/org.openteacher.about.pot",
		"modules/org/openteacher/dialogs/about/translations/si.po",
		"modules/org/openteacher/dialogs/results/results.py",
		"modules/org/openteacher/dialogs/print/print.py",
		"modules/org/openteacher/dialogs/documentation/documentation.py",
		"modules/org/openteacher/dialogs/documentation/docs/index.html",
		"modules/org/openteacher/dialogs/documentation/docs/static/qs6.png",
		"modules/org/openteacher/dialogs/documentation/docs/static/inst2.png",
		"modules/org/openteacher/dialogs/documentation/docs/static/qs4.png",
		"modules/org/openteacher/dialogs/documentation/docs/static/qs5.png",
		"modules/org/openteacher/dialogs/documentation/docs/static/qs2.png",
		"modules/org/openteacher/dialogs/documentation/translations/ar.po",
		"modules/org/openteacher/dialogs/documentation/translations/es.mo",
		"modules/org/openteacher/dialogs/documentation/translations/cs.mo",
		"modules/org/openteacher/dialogs/documentation/translations/zh_CN.po",
		"modules/org/openteacher/dialogs/documentation/translations/af.po",
		"modules/org/openteacher/dialogs/documentation/translations/es.po",
		"modules/org/openteacher/dialogs/documentation/translations/hu.mo",
		"modules/org/openteacher/dialogs/documentation/translations/af.mo",
		"modules/org/openteacher/dialogs/documentation/translations/fi.mo",
		"modules/org/openteacher/dialogs/documentation/translations/org.openteacher.documentation.pot",
		"modules/org/openteacher/dialogs/documentation/translations/pt_BR.po",
		"modules/org/openteacher/dialogs/documentation/translations/nl.po",
		"modules/org/openteacher/dialogs/documentation/translations/de.mo",
		"modules/org/openteacher/dialogs/documentation/translations/pt_BR.mo",
		"modules/org/openteacher/dialogs/documentation/translations/fy.mo",
		"modules/org/openteacher/dialogs/documentation/translations/sk.po",
		"modules/org/openteacher/dialogs/documentation/translations/el.po",
		"modules/org/openteacher/dialogs/documentation/translations/si.mo",
		"modules/org/openteacher/dialogs/documentation/translations/fr.po",
		"modules/org/openteacher/dialogs/documentation/translations/fr.mo",
		"modules/org/openteacher/dialogs/documentation/translations/sk.mo",
		"modules/org/openteacher/dialogs/documentation/translations/de.po",
		"modules/org/openteacher/dialogs/documentation/translations/cs.po",
		"modules/org/openteacher/dialogs/documentation/translations/ar.mo",
		"modules/org/openteacher/dialogs/documentation/translations/el.mo",
		"modules/org/openteacher/dialogs/documentation/translations/fi.po",
		"modules/org/openteacher/dialogs/documentation/translations/fy.po",
		"modules/org/openteacher/dialogs/documentation/translations/zh_TW.po",
		"modules/org/openteacher/dialogs/documentation/translations/zh_TW.mo",
		"modules/org/openteacher/dialogs/documentation/translations/hu.po",
		"modules/org/openteacher/dialogs/documentation/translations/zh_CN.mo",
		"modules/org/openteacher/dialogs/documentation/translations/nl.mo",
		"modules/org/openteacher/dialogs/documentation/translations/si.po",
		"modules/org/openteacher/wordsString/parserTest/parserTest.py",
		"modules/org/openteacher/wordsString/checker/checker.py",
		"modules/org/openteacher/wordsString/checkerTest/checkerTest.py",
		"modules/org/openteacher/wordsString/javaScriptComposer/composer.js",
		"modules/org/openteacher/wordsString/javaScriptComposer/javaScriptComposer.py",
		"modules/org/openteacher/wordsString/javaScriptChecker/javaScriptChecker.py",
		"modules/org/openteacher/wordsString/javaScriptChecker/checker.js",
		"modules/org/openteacher/wordsString/javaScriptParser/parser.js",
		"modules/org/openteacher/wordsString/javaScriptParser/javaScriptParser.py",
		"modules/org/openteacher/wordsString/composerTest/composerTest.py",
		"modules/org/openteacher/wordsString/parser/parser.py",
		"modules/org/openteacher/wordsString/composer/composer.py",
		"modules/org/openteacher/dialogShower/dialogShower.py",
		"modules/org/openteacher/dialogShower/images/ot2300.png",
		"modules/org/openteacher/dialogShower/images/otbroken240.png",
		"modules/org/openteacher/dialogShower/images/ot240.png",
		"modules/org/openteacher/dialogShower/images/COPYING",
		"modules/org/openteacher/dialogShower/images/otbroken2300.png",
		"modules/org/openteacher/sourceWithSetupSaver/desktop.templ",
		"modules/org/openteacher/sourceWithSetupSaver/setup.py.templ",
		"modules/org/openteacher/sourceWithSetupSaver/mimetypes.xml",
		"modules/org/openteacher/sourceWithSetupSaver/runner.templ",
		"modules/org/openteacher/sourceWithSetupSaver/sourceWithSetupSaver.py",
		"modules/org/openteacher/lessons/media/media.py",
		"modules/org/openteacher/lessons/media/translations/ar.po",
		"modules/org/openteacher/lessons/media/translations/es.mo",
		"modules/org/openteacher/lessons/media/translations/cs.mo",
		"modules/org/openteacher/lessons/media/translations/zh_CN.po",
		"modules/org/openteacher/lessons/media/translations/af.po",
		"modules/org/openteacher/lessons/media/translations/es.po",
		"modules/org/openteacher/lessons/media/translations/hu.mo",
		"modules/org/openteacher/lessons/media/translations/af.mo",
		"modules/org/openteacher/lessons/media/translations/fi.mo",
		"modules/org/openteacher/lessons/media/translations/pt_BR.po",
		"modules/org/openteacher/lessons/media/translations/nl.po",
		"modules/org/openteacher/lessons/media/translations/de.mo",
		"modules/org/openteacher/lessons/media/translations/pt_BR.mo",
		"modules/org/openteacher/lessons/media/translations/fy.mo",
		"modules/org/openteacher/lessons/media/translations/sk.po",
		"modules/org/openteacher/lessons/media/translations/el.po",
		"modules/org/openteacher/lessons/media/translations/si.mo",
		"modules/org/openteacher/lessons/media/translations/fr.po",
		"modules/org/openteacher/lessons/media/translations/fr.mo",
		"modules/org/openteacher/lessons/media/translations/sk.mo",
		"modules/org/openteacher/lessons/media/translations/de.po",
		"modules/org/openteacher/lessons/media/translations/org.openteacher.lessons.media.pot",
		"modules/org/openteacher/lessons/media/translations/cs.po",
		"modules/org/openteacher/lessons/media/translations/ar.mo",
		"modules/org/openteacher/lessons/media/translations/el.mo",
		"modules/org/openteacher/lessons/media/translations/fi.po",
		"modules/org/openteacher/lessons/media/translations/fy.po",
		"modules/org/openteacher/lessons/media/translations/zh_TW.po",
		"modules/org/openteacher/lessons/media/translations/zh_TW.mo",
		"modules/org/openteacher/lessons/media/translations/hu.po",
		"modules/org/openteacher/lessons/media/translations/zh_CN.mo",
		"modules/org/openteacher/lessons/media/translations/nl.mo",
		"modules/org/openteacher/lessons/media/translations/si.po",
		"modules/org/openteacher/lessons/topo/topo.py",
		"modules/org/openteacher/lessons/topo/translations/ar.po",
		"modules/org/openteacher/lessons/topo/translations/es.mo",
		"modules/org/openteacher/lessons/topo/translations/cs.mo",
		"modules/org/openteacher/lessons/topo/translations/zh_CN.po",
		"modules/org/openteacher/lessons/topo/translations/es.po",
		"modules/org/openteacher/lessons/topo/translations/hu.mo",
		"modules/org/openteacher/lessons/topo/translations/fi.mo",
		"modules/org/openteacher/lessons/topo/translations/pt_BR.po",
		"modules/org/openteacher/lessons/topo/translations/nl.po",
		"modules/org/openteacher/lessons/topo/translations/de.mo",
		"modules/org/openteacher/lessons/topo/translations/pt_BR.mo",
		"modules/org/openteacher/lessons/topo/translations/fy.mo",
		"modules/org/openteacher/lessons/topo/translations/sk.po",
		"modules/org/openteacher/lessons/topo/translations/el.po",
		"modules/org/openteacher/lessons/topo/translations/si.mo",
		"modules/org/openteacher/lessons/topo/translations/ja.mo",
		"modules/org/openteacher/lessons/topo/translations/fr.po",
		"modules/org/openteacher/lessons/topo/translations/fr.mo",
		"modules/org/openteacher/lessons/topo/translations/sk.mo",
		"modules/org/openteacher/lessons/topo/translations/ja.po",
		"modules/org/openteacher/lessons/topo/translations/de.po",
		"modules/org/openteacher/lessons/topo/translations/cs.po",
		"modules/org/openteacher/lessons/topo/translations/ar.mo",
		"modules/org/openteacher/lessons/topo/translations/org.openteacher.lessons.topo.pot",
		"modules/org/openteacher/lessons/topo/translations/el.mo",
		"modules/org/openteacher/lessons/topo/translations/fi.po",
		"modules/org/openteacher/lessons/topo/translations/fy.po",
		"modules/org/openteacher/lessons/topo/translations/zh_TW.po",
		"modules/org/openteacher/lessons/topo/translations/zh_TW.mo",
		"modules/org/openteacher/lessons/topo/translations/hu.po",
		"modules/org/openteacher/lessons/topo/translations/zh_CN.mo",
		"modules/org/openteacher/lessons/topo/translations/nl.mo",
		"modules/org/openteacher/lessons/topo/translations/si.po",
		"modules/org/openteacher/lessons/words/words.py",
		"modules/org/openteacher/lessons/words/translations/ar.po",
		"modules/org/openteacher/lessons/words/translations/es.mo",
		"modules/org/openteacher/lessons/words/translations/cs.mo",
		"modules/org/openteacher/lessons/words/translations/zh_CN.po",
		"modules/org/openteacher/lessons/words/translations/af.po",
		"modules/org/openteacher/lessons/words/translations/es.po",
		"modules/org/openteacher/lessons/words/translations/hu.mo",
		"modules/org/openteacher/lessons/words/translations/af.mo",
		"modules/org/openteacher/lessons/words/translations/ru.po",
		"modules/org/openteacher/lessons/words/translations/fi.mo",
		"modules/org/openteacher/lessons/words/translations/pt_BR.po",
		"modules/org/openteacher/lessons/words/translations/nl.po",
		"modules/org/openteacher/lessons/words/translations/de.mo",
		"modules/org/openteacher/lessons/words/translations/pt_BR.mo",
		"modules/org/openteacher/lessons/words/translations/eo.po",
		"modules/org/openteacher/lessons/words/translations/fy.mo",
		"modules/org/openteacher/lessons/words/translations/sk.po",
		"modules/org/openteacher/lessons/words/translations/el.po",
		"modules/org/openteacher/lessons/words/translations/si.mo",
		"modules/org/openteacher/lessons/words/translations/ja.mo",
		"modules/org/openteacher/lessons/words/translations/fr.po",
		"modules/org/openteacher/lessons/words/translations/fr.mo",
		"modules/org/openteacher/lessons/words/translations/sk.mo",
		"modules/org/openteacher/lessons/words/translations/ja.po",
		"modules/org/openteacher/lessons/words/translations/de.po",
		"modules/org/openteacher/lessons/words/translations/cs.po",
		"modules/org/openteacher/lessons/words/translations/ar.mo",
		"modules/org/openteacher/lessons/words/translations/eo.mo",
		"modules/org/openteacher/lessons/words/translations/el.mo",
		"modules/org/openteacher/lessons/words/translations/fi.po",
		"modules/org/openteacher/lessons/words/translations/ru.mo",
		"modules/org/openteacher/lessons/words/translations/org.openteacher.lessons.words.pot",
		"modules/org/openteacher/lessons/words/translations/fy.po",
		"modules/org/openteacher/lessons/words/translations/zh_TW.po",
		"modules/org/openteacher/lessons/words/translations/zh_TW.mo",
		"modules/org/openteacher/lessons/words/translations/hu.po",
		"modules/org/openteacher/lessons/words/translations/zh_CN.mo",
		"modules/org/openteacher/lessons/words/translations/nl.mo",
		"modules/org/openteacher/lessons/words/translations/si.po",
		"modules/org/openteacher/modulesTest/modulesTest.py",
		"modules/org/openteacher/event/event.py",
		"modules/org/openteacher/recentlyOpenedViewer/recentlyOpenedViewer.py",
		"modules/org/openteacher/shell/shell.py",
		"modules/org/openteacher/translationUpdater/translationUpdater.py",
		"modules/org/openteacher/teachTypes/typing/typing.py",
		"modules/org/openteacher/teachTypes/typing/translations/ar.po",
		"modules/org/openteacher/teachTypes/typing/translations/es.mo",
		"modules/org/openteacher/teachTypes/typing/translations/cs.mo",
		"modules/org/openteacher/teachTypes/typing/translations/zh_CN.po",
		"modules/org/openteacher/teachTypes/typing/translations/af.po",
		"modules/org/openteacher/teachTypes/typing/translations/es.po",
		"modules/org/openteacher/teachTypes/typing/translations/hu.mo",
		"modules/org/openteacher/teachTypes/typing/translations/af.mo",
		"modules/org/openteacher/teachTypes/typing/translations/ru.po",
		"modules/org/openteacher/teachTypes/typing/translations/fi.mo",
		"modules/org/openteacher/teachTypes/typing/translations/pt_BR.po",
		"modules/org/openteacher/teachTypes/typing/translations/nl.po",
		"modules/org/openteacher/teachTypes/typing/translations/de.mo",
		"modules/org/openteacher/teachTypes/typing/translations/pt_BR.mo",
		"modules/org/openteacher/teachTypes/typing/translations/fy.mo",
		"modules/org/openteacher/teachTypes/typing/translations/sk.po",
		"modules/org/openteacher/teachTypes/typing/translations/el.po",
		"modules/org/openteacher/teachTypes/typing/translations/si.mo",
		"modules/org/openteacher/teachTypes/typing/translations/ja.mo",
		"modules/org/openteacher/teachTypes/typing/translations/fr.po",
		"modules/org/openteacher/teachTypes/typing/translations/fr.mo",
		"modules/org/openteacher/teachTypes/typing/translations/sk.mo",
		"modules/org/openteacher/teachTypes/typing/translations/ja.po",
		"modules/org/openteacher/teachTypes/typing/translations/de.po",
		"modules/org/openteacher/teachTypes/typing/translations/cs.po",
		"modules/org/openteacher/teachTypes/typing/translations/ar.mo",
		"modules/org/openteacher/teachTypes/typing/translations/el.mo",
		"modules/org/openteacher/teachTypes/typing/translations/fi.po",
		"modules/org/openteacher/teachTypes/typing/translations/ru.mo",
		"modules/org/openteacher/teachTypes/typing/translations/fy.po",
		"modules/org/openteacher/teachTypes/typing/translations/zh_TW.po",
		"modules/org/openteacher/teachTypes/typing/translations/zh_TW.mo",
		"modules/org/openteacher/teachTypes/typing/translations/org.openteacher.teachTypes.typing.pot",
		"modules/org/openteacher/teachTypes/typing/translations/hu.po",
		"modules/org/openteacher/teachTypes/typing/translations/zh_CN.mo",
		"modules/org/openteacher/teachTypes/typing/translations/nl.mo",
		"modules/org/openteacher/teachTypes/typing/translations/si.po",
		"modules/org/openteacher/teachTypes/hangman/graphics.py",
		"modules/org/openteacher/teachTypes/hangman/hangman.py",
		"modules/org/openteacher/teachTypes/hangman/word.py",
		"modules/org/openteacher/teachTypes/hangman/translations/es.mo",
		"modules/org/openteacher/teachTypes/hangman/translations/es.po",
		"modules/org/openteacher/teachTypes/hangman/translations/pt_BR.po",
		"modules/org/openteacher/teachTypes/hangman/translations/nl.po",
		"modules/org/openteacher/teachTypes/hangman/translations/pt_BR.mo",
		"modules/org/openteacher/teachTypes/hangman/translations/fy.mo",
		"modules/org/openteacher/teachTypes/hangman/translations/org.openteacher.teachTypes.hangman.pot",
		"modules/org/openteacher/teachTypes/hangman/translations/fy.po",
		"modules/org/openteacher/teachTypes/hangman/translations/zh_TW.po",
		"modules/org/openteacher/teachTypes/hangman/translations/zh_TW.mo",
		"modules/org/openteacher/teachTypes/hangman/translations/nl.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/shuffleAnswer.py",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/ar.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/es.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/cs.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/zh_CN.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/af.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/org.openteacher.teachTypes.shuffleAnswer.pot",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/es.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/hu.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/af.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/ru.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/fi.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/pt_BR.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/nl.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/de.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/pt_BR.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/fy.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/sk.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/el.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/si.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/ja.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/fr.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/fr.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/sk.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/ja.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/de.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/cs.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/ar.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/el.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/fi.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/ru.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/fy.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/zh_TW.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/zh_TW.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/hu.po",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/zh_CN.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/nl.mo",
		"modules/org/openteacher/teachTypes/shuffleAnswer/translations/si.po",
		"modules/org/openteacher/teachTypes/inMind/inMind.py",
		"modules/org/openteacher/teachTypes/inMind/translations/org.openteacher.teachTypes.inMind.pot",
		"modules/org/openteacher/teachTypes/inMind/translations/ar.po",
		"modules/org/openteacher/teachTypes/inMind/translations/es.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/cs.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/zh_CN.po",
		"modules/org/openteacher/teachTypes/inMind/translations/es.po",
		"modules/org/openteacher/teachTypes/inMind/translations/hu.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/ru.po",
		"modules/org/openteacher/teachTypes/inMind/translations/fi.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/pt_BR.po",
		"modules/org/openteacher/teachTypes/inMind/translations/nl.po",
		"modules/org/openteacher/teachTypes/inMind/translations/de.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/pt_BR.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/fy.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/sk.po",
		"modules/org/openteacher/teachTypes/inMind/translations/el.po",
		"modules/org/openteacher/teachTypes/inMind/translations/si.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/ja.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/fr.po",
		"modules/org/openteacher/teachTypes/inMind/translations/fr.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/sk.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/ja.po",
		"modules/org/openteacher/teachTypes/inMind/translations/de.po",
		"modules/org/openteacher/teachTypes/inMind/translations/cs.po",
		"modules/org/openteacher/teachTypes/inMind/translations/ar.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/el.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/fi.po",
		"modules/org/openteacher/teachTypes/inMind/translations/ru.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/fy.po",
		"modules/org/openteacher/teachTypes/inMind/translations/zh_TW.po",
		"modules/org/openteacher/teachTypes/inMind/translations/zh_TW.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/hu.po",
		"modules/org/openteacher/teachTypes/inMind/translations/zh_CN.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/nl.mo",
		"modules/org/openteacher/teachTypes/inMind/translations/si.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/repeatAnswer.py",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/ar.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/es.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/cs.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/zh_CN.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/es.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/hu.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/ru.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/fi.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/pt_BR.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/nl.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/de.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/pt_BR.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/fy.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/sk.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/el.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/si.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/ja.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/fr.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/fr.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/sk.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/ja.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/de.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/cs.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/ar.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/el.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/fi.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/ru.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/fy.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/zh_TW.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/zh_TW.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/hu.po",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/org.openteacher.teachTypes.repeatAnswer.pot",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/zh_CN.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/nl.mo",
		"modules/org/openteacher/teachTypes/repeatAnswer/translations/si.po",
		"modules/org/openteacher/noteCalculators/ects/ects.py",
		"modules/org/openteacher/noteCalculators/ects/translations/ar.po",
		"modules/org/openteacher/noteCalculators/ects/translations/es.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/cs.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/zh_CN.po",
		"modules/org/openteacher/noteCalculators/ects/translations/es.po",
		"modules/org/openteacher/noteCalculators/ects/translations/fi.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/pt_BR.po",
		"modules/org/openteacher/noteCalculators/ects/translations/nl.po",
		"modules/org/openteacher/noteCalculators/ects/translations/de.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/pt_BR.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/fy.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/si.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/org.openteacher.noteCalculators.ects.pot",
		"modules/org/openteacher/noteCalculators/ects/translations/fr.po",
		"modules/org/openteacher/noteCalculators/ects/translations/fr.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/de.po",
		"modules/org/openteacher/noteCalculators/ects/translations/cs.po",
		"modules/org/openteacher/noteCalculators/ects/translations/ar.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/fi.po",
		"modules/org/openteacher/noteCalculators/ects/translations/fy.po",
		"modules/org/openteacher/noteCalculators/ects/translations/zh_TW.po",
		"modules/org/openteacher/noteCalculators/ects/translations/zh_TW.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/zh_CN.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/nl.mo",
		"modules/org/openteacher/noteCalculators/ects/translations/si.po",
		"modules/org/openteacher/noteCalculators/american/american.py",
		"modules/org/openteacher/noteCalculators/american/translations/ar.po",
		"modules/org/openteacher/noteCalculators/american/translations/es.mo",
		"modules/org/openteacher/noteCalculators/american/translations/cs.mo",
		"modules/org/openteacher/noteCalculators/american/translations/zh_CN.po",
		"modules/org/openteacher/noteCalculators/american/translations/es.po",
		"modules/org/openteacher/noteCalculators/american/translations/fi.mo",
		"modules/org/openteacher/noteCalculators/american/translations/org.openteacher.noteCalculators.american.pot",
		"modules/org/openteacher/noteCalculators/american/translations/pt_BR.po",
		"modules/org/openteacher/noteCalculators/american/translations/nl.po",
		"modules/org/openteacher/noteCalculators/american/translations/de.mo",
		"modules/org/openteacher/noteCalculators/american/translations/pt_BR.mo",
		"modules/org/openteacher/noteCalculators/american/translations/fy.mo",
		"modules/org/openteacher/noteCalculators/american/translations/si.mo",
		"modules/org/openteacher/noteCalculators/american/translations/fr.po",
		"modules/org/openteacher/noteCalculators/american/translations/fr.mo",
		"modules/org/openteacher/noteCalculators/american/translations/de.po",
		"modules/org/openteacher/noteCalculators/american/translations/cs.po",
		"modules/org/openteacher/noteCalculators/american/translations/ar.mo",
		"modules/org/openteacher/noteCalculators/american/translations/fi.po",
		"modules/org/openteacher/noteCalculators/american/translations/fy.po",
		"modules/org/openteacher/noteCalculators/american/translations/zh_TW.po",
		"modules/org/openteacher/noteCalculators/american/translations/zh_TW.mo",
		"modules/org/openteacher/noteCalculators/american/translations/zh_CN.mo",
		"modules/org/openteacher/noteCalculators/american/translations/nl.mo",
		"modules/org/openteacher/noteCalculators/american/translations/si.po",
		"modules/org/openteacher/noteCalculators/percents/percents.py",
		"modules/org/openteacher/noteCalculators/percents/translations/org.openteacher.noteCalculators.percents.pot",
		"modules/org/openteacher/noteCalculators/percents/translations/ar.po",
		"modules/org/openteacher/noteCalculators/percents/translations/es.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/cs.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/zh_CN.po",
		"modules/org/openteacher/noteCalculators/percents/translations/es.po",
		"modules/org/openteacher/noteCalculators/percents/translations/fi.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/pt_BR.po",
		"modules/org/openteacher/noteCalculators/percents/translations/nl.po",
		"modules/org/openteacher/noteCalculators/percents/translations/de.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/pt_BR.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/fy.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/si.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/fr.po",
		"modules/org/openteacher/noteCalculators/percents/translations/fr.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/de.po",
		"modules/org/openteacher/noteCalculators/percents/translations/cs.po",
		"modules/org/openteacher/noteCalculators/percents/translations/ar.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/fi.po",
		"modules/org/openteacher/noteCalculators/percents/translations/fy.po",
		"modules/org/openteacher/noteCalculators/percents/translations/zh_TW.po",
		"modules/org/openteacher/noteCalculators/percents/translations/zh_TW.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/zh_CN.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/nl.mo",
		"modules/org/openteacher/noteCalculators/percents/translations/si.po",
		"modules/org/openteacher/noteCalculators/dutch/dutch.py",
		"modules/org/openteacher/noteCalculators/dutch/translations/ar.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/es.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/cs.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/zh_CN.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/es.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/hu.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/org.openteacher.noteCalculators.dutch.pot",
		"modules/org/openteacher/noteCalculators/dutch/translations/fi.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/pt_BR.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/nl.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/de.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/pt_BR.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/fy.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/el.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/si.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/fr.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/fr.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/de.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/cs.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/ar.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/el.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/fi.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/fy.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/zh_TW.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/zh_TW.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/hu.po",
		"modules/org/openteacher/noteCalculators/dutch/translations/zh_CN.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/nl.mo",
		"modules/org/openteacher/noteCalculators/dutch/translations/si.po",
		"modules/org/openteacher/noteCalculators/test/test.py",
		"modules/org/openteacher/noteCalculators/german/german.py",
		"modules/org/openteacher/noteCalculators/german/translations/ar.po",
		"modules/org/openteacher/noteCalculators/german/translations/es.mo",
		"modules/org/openteacher/noteCalculators/german/translations/cs.mo",
		"modules/org/openteacher/noteCalculators/german/translations/zh_CN.po",
		"modules/org/openteacher/noteCalculators/german/translations/es.po",
		"modules/org/openteacher/noteCalculators/german/translations/fi.mo",
		"modules/org/openteacher/noteCalculators/german/translations/pt_BR.po",
		"modules/org/openteacher/noteCalculators/german/translations/nl.po",
		"modules/org/openteacher/noteCalculators/german/translations/de.mo",
		"modules/org/openteacher/noteCalculators/german/translations/pt_BR.mo",
		"modules/org/openteacher/noteCalculators/german/translations/fy.mo",
		"modules/org/openteacher/noteCalculators/german/translations/si.mo",
		"modules/org/openteacher/noteCalculators/german/translations/fr.po",
		"modules/org/openteacher/noteCalculators/german/translations/fr.mo",
		"modules/org/openteacher/noteCalculators/german/translations/de.po",
		"modules/org/openteacher/noteCalculators/german/translations/cs.po",
		"modules/org/openteacher/noteCalculators/german/translations/ar.mo",
		"modules/org/openteacher/noteCalculators/german/translations/fi.po",
		"modules/org/openteacher/noteCalculators/german/translations/org.openteacher.noteCalculators.german.pot",
		"modules/org/openteacher/noteCalculators/german/translations/fy.po",
		"modules/org/openteacher/noteCalculators/german/translations/zh_TW.po",
		"modules/org/openteacher/noteCalculators/german/translations/zh_TW.mo",
		"modules/org/openteacher/noteCalculators/german/translations/zh_CN.mo",
		"modules/org/openteacher/noteCalculators/german/translations/nl.mo",
		"modules/org/openteacher/noteCalculators/german/translations/si.po",
		"modules/org/openteacher/noteCalculators/french/french.py",
		"modules/org/openteacher/noteCalculators/french/translations/ar.po",
		"modules/org/openteacher/noteCalculators/french/translations/es.mo",
		"modules/org/openteacher/noteCalculators/french/translations/cs.mo",
		"modules/org/openteacher/noteCalculators/french/translations/zh_CN.po",
		"modules/org/openteacher/noteCalculators/french/translations/es.po",
		"modules/org/openteacher/noteCalculators/french/translations/fi.mo",
		"modules/org/openteacher/noteCalculators/french/translations/pt_BR.po",
		"modules/org/openteacher/noteCalculators/french/translations/nl.po",
		"modules/org/openteacher/noteCalculators/french/translations/de.mo",
		"modules/org/openteacher/noteCalculators/french/translations/pt_BR.mo",
		"modules/org/openteacher/noteCalculators/french/translations/fy.mo",
		"modules/org/openteacher/noteCalculators/french/translations/si.mo",
		"modules/org/openteacher/noteCalculators/french/translations/fr.po",
		"modules/org/openteacher/noteCalculators/french/translations/fr.mo",
		"modules/org/openteacher/noteCalculators/french/translations/de.po",
		"modules/org/openteacher/noteCalculators/french/translations/cs.po",
		"modules/org/openteacher/noteCalculators/french/translations/ar.mo",
		"modules/org/openteacher/noteCalculators/french/translations/fi.po",
		"modules/org/openteacher/noteCalculators/french/translations/fy.po",
		"modules/org/openteacher/noteCalculators/french/translations/zh_TW.po",
		"modules/org/openteacher/noteCalculators/french/translations/org.openteacher.noteCalculators.french.pot",
		"modules/org/openteacher/noteCalculators/french/translations/zh_TW.mo",
		"modules/org/openteacher/noteCalculators/french/translations/zh_CN.mo",
		"modules/org/openteacher/noteCalculators/french/translations/nl.mo",
		"modules/org/openteacher/noteCalculators/french/translations/si.po",
		"modules/org/openteacher/lessonTracker/lessonTracker.py",
		"modules/org/openteacher/percentsCalculator/percentsCalculator.py",
		"modules/org/openteacher/savers/ottp/ottp.py",
		"modules/org/openteacher/savers/ottp/translations/es.mo",
		"modules/org/openteacher/savers/ottp/translations/cs.mo",
		"modules/org/openteacher/savers/ottp/translations/es.po",
		"modules/org/openteacher/savers/ottp/translations/pt_BR.po",
		"modules/org/openteacher/savers/ottp/translations/nl.po",
		"modules/org/openteacher/savers/ottp/translations/de.mo",
		"modules/org/openteacher/savers/ottp/translations/pt_BR.mo",
		"modules/org/openteacher/savers/ottp/translations/fy.mo",
		"modules/org/openteacher/savers/ottp/translations/fr.po",
		"modules/org/openteacher/savers/ottp/translations/fr.mo",
		"modules/org/openteacher/savers/ottp/translations/de.po",
		"modules/org/openteacher/savers/ottp/translations/cs.po",
		"modules/org/openteacher/savers/ottp/translations/fy.po",
		"modules/org/openteacher/savers/ottp/translations/org.openteacher.savers.ottp.pot",
		"modules/org/openteacher/savers/ottp/translations/zh_TW.po",
		"modules/org/openteacher/savers/ottp/translations/zh_TW.mo",
		"modules/org/openteacher/savers/ottp/translations/nl.mo",
		"modules/org/openteacher/savers/html/html.py",
		"modules/org/openteacher/savers/html/translations/es.mo",
		"modules/org/openteacher/savers/html/translations/cs.mo",
		"modules/org/openteacher/savers/html/translations/zh_CN.po",
		"modules/org/openteacher/savers/html/translations/es.po",
		"modules/org/openteacher/savers/html/translations/pt_BR.po",
		"modules/org/openteacher/savers/html/translations/nl.po",
		"modules/org/openteacher/savers/html/translations/de.mo",
		"modules/org/openteacher/savers/html/translations/org.openteacher.savers.html.pot",
		"modules/org/openteacher/savers/html/translations/pt_BR.mo",
		"modules/org/openteacher/savers/html/translations/fy.mo",
		"modules/org/openteacher/savers/html/translations/si.mo",
		"modules/org/openteacher/savers/html/translations/fr.po",
		"modules/org/openteacher/savers/html/translations/fr.mo",
		"modules/org/openteacher/savers/html/translations/de.po",
		"modules/org/openteacher/savers/html/translations/cs.po",
		"modules/org/openteacher/savers/html/translations/fy.po",
		"modules/org/openteacher/savers/html/translations/zh_TW.po",
		"modules/org/openteacher/savers/html/translations/zh_TW.mo",
		"modules/org/openteacher/savers/html/translations/zh_CN.mo",
		"modules/org/openteacher/savers/html/translations/nl.mo",
		"modules/org/openteacher/savers/html/translations/si.po",
		"modules/org/openteacher/savers/png/png.py",
		"modules/org/openteacher/savers/png/translations/es.mo",
		"modules/org/openteacher/savers/png/translations/cs.mo",
		"modules/org/openteacher/savers/png/translations/zh_CN.po",
		"modules/org/openteacher/savers/png/translations/org.openteacher.savers.png.pot",
		"modules/org/openteacher/savers/png/translations/es.po",
		"modules/org/openteacher/savers/png/translations/pt_BR.po",
		"modules/org/openteacher/savers/png/translations/nl.po",
		"modules/org/openteacher/savers/png/translations/de.mo",
		"modules/org/openteacher/savers/png/translations/pt_BR.mo",
		"modules/org/openteacher/savers/png/translations/fy.mo",
		"modules/org/openteacher/savers/png/translations/si.mo",
		"modules/org/openteacher/savers/png/translations/fr.po",
		"modules/org/openteacher/savers/png/translations/fr.mo",
		"modules/org/openteacher/savers/png/translations/de.po",
		"modules/org/openteacher/savers/png/translations/cs.po",
		"modules/org/openteacher/savers/png/translations/fy.po",
		"modules/org/openteacher/savers/png/translations/zh_TW.po",
		"modules/org/openteacher/savers/png/translations/zh_TW.mo",
		"modules/org/openteacher/savers/png/translations/zh_CN.mo",
		"modules/org/openteacher/savers/png/translations/nl.mo",
		"modules/org/openteacher/savers/png/translations/si.po",
		"modules/org/openteacher/savers/otmd/otmd.py",
		"modules/org/openteacher/savers/otmd/translations/es.mo",
		"modules/org/openteacher/savers/otmd/translations/org.openteacher.savers.otmd.pot",
		"modules/org/openteacher/savers/otmd/translations/cs.mo",
		"modules/org/openteacher/savers/otmd/translations/zh_CN.po",
		"modules/org/openteacher/savers/otmd/translations/es.po",
		"modules/org/openteacher/savers/otmd/translations/pt_BR.po",
		"modules/org/openteacher/savers/otmd/translations/nl.po",
		"modules/org/openteacher/savers/otmd/translations/de.mo",
		"modules/org/openteacher/savers/otmd/translations/pt_BR.mo",
		"modules/org/openteacher/savers/otmd/translations/fy.mo",
		"modules/org/openteacher/savers/otmd/translations/fr.po",
		"modules/org/openteacher/savers/otmd/translations/fr.mo",
		"modules/org/openteacher/savers/otmd/translations/de.po",
		"modules/org/openteacher/savers/otmd/translations/cs.po",
		"modules/org/openteacher/savers/otmd/translations/fy.po",
		"modules/org/openteacher/savers/otmd/translations/zh_TW.po",
		"modules/org/openteacher/savers/otmd/translations/zh_TW.mo",
		"modules/org/openteacher/savers/otmd/translations/zh_CN.mo",
		"modules/org/openteacher/savers/otmd/translations/nl.mo",
		"modules/org/openteacher/savers/wrts/wrts.py",
		"modules/org/openteacher/savers/wrts/template.xml",
		"modules/org/openteacher/savers/wrts/translations/ar.po",
		"modules/org/openteacher/savers/wrts/translations/es.mo",
		"modules/org/openteacher/savers/wrts/translations/cs.mo",
		"modules/org/openteacher/savers/wrts/translations/zh_CN.po",
		"modules/org/openteacher/savers/wrts/translations/es.po",
		"modules/org/openteacher/savers/wrts/translations/pt_BR.po",
		"modules/org/openteacher/savers/wrts/translations/nl.po",
		"modules/org/openteacher/savers/wrts/translations/de.mo",
		"modules/org/openteacher/savers/wrts/translations/pt_BR.mo",
		"modules/org/openteacher/savers/wrts/translations/fy.mo",
		"modules/org/openteacher/savers/wrts/translations/si.mo",
		"modules/org/openteacher/savers/wrts/translations/fr.po",
		"modules/org/openteacher/savers/wrts/translations/fr.mo",
		"modules/org/openteacher/savers/wrts/translations/de.po",
		"modules/org/openteacher/savers/wrts/translations/cs.po",
		"modules/org/openteacher/savers/wrts/translations/ar.mo",
		"modules/org/openteacher/savers/wrts/translations/fy.po",
		"modules/org/openteacher/savers/wrts/translations/zh_TW.po",
		"modules/org/openteacher/savers/wrts/translations/org.openteacher.savers.wrts.pot",
		"modules/org/openteacher/savers/wrts/translations/zh_TW.mo",
		"modules/org/openteacher/savers/wrts/translations/zh_CN.mo",
		"modules/org/openteacher/savers/wrts/translations/nl.mo",
		"modules/org/openteacher/savers/wrts/translations/si.po",
		"modules/org/openteacher/savers/otwd/otwd.py",
		"modules/org/openteacher/savers/otwd/translations/es.mo",
		"modules/org/openteacher/savers/otwd/translations/cs.mo",
		"modules/org/openteacher/savers/otwd/translations/zh_CN.po",
		"modules/org/openteacher/savers/otwd/translations/es.po",
		"modules/org/openteacher/savers/otwd/translations/pt_BR.po",
		"modules/org/openteacher/savers/otwd/translations/nl.po",
		"modules/org/openteacher/savers/otwd/translations/de.mo",
		"modules/org/openteacher/savers/otwd/translations/pt_BR.mo",
		"modules/org/openteacher/savers/otwd/translations/fy.mo",
		"modules/org/openteacher/savers/otwd/translations/fr.po",
		"modules/org/openteacher/savers/otwd/translations/fr.mo",
		"modules/org/openteacher/savers/otwd/translations/org.openteacher.savers.otwd.pot",
		"modules/org/openteacher/savers/otwd/translations/de.po",
		"modules/org/openteacher/savers/otwd/translations/cs.po",
		"modules/org/openteacher/savers/otwd/translations/fy.po",
		"modules/org/openteacher/savers/otwd/translations/zh_TW.po",
		"modules/org/openteacher/savers/otwd/translations/zh_TW.mo",
		"modules/org/openteacher/savers/otwd/translations/zh_CN.mo",
		"modules/org/openteacher/savers/otwd/translations/nl.mo",
		"modules/org/openteacher/savers/ot/template.xml",
		"modules/org/openteacher/savers/ot/ot.py",
		"modules/org/openteacher/savers/ot/translations/es.mo",
		"modules/org/openteacher/savers/ot/translations/cs.mo",
		"modules/org/openteacher/savers/ot/translations/zh_CN.po",
		"modules/org/openteacher/savers/ot/translations/es.po",
		"modules/org/openteacher/savers/ot/translations/pt_BR.po",
		"modules/org/openteacher/savers/ot/translations/nl.po",
		"modules/org/openteacher/savers/ot/translations/de.mo",
		"modules/org/openteacher/savers/ot/translations/pt_BR.mo",
		"modules/org/openteacher/savers/ot/translations/fy.mo",
		"modules/org/openteacher/savers/ot/translations/si.mo",
		"modules/org/openteacher/savers/ot/translations/fr.po",
		"modules/org/openteacher/savers/ot/translations/fr.mo",
		"modules/org/openteacher/savers/ot/translations/de.po",
		"modules/org/openteacher/savers/ot/translations/cs.po",
		"modules/org/openteacher/savers/ot/translations/fy.po",
		"modules/org/openteacher/savers/ot/translations/zh_TW.po",
		"modules/org/openteacher/savers/ot/translations/zh_TW.mo",
		"modules/org/openteacher/savers/ot/translations/zh_CN.mo",
		"modules/org/openteacher/savers/ot/translations/nl.mo",
		"modules/org/openteacher/savers/ot/translations/si.po",
		"modules/org/openteacher/savers/ot/translations/org.openteacher.savers.ot.pot",
		"modules/org/openteacher/savers/t2k/t2k.py",
		"modules/org/openteacher/savers/t2k/template.xml",
		"modules/org/openteacher/savers/t2k/translations/es.mo",
		"modules/org/openteacher/savers/t2k/translations/cs.mo",
		"modules/org/openteacher/savers/t2k/translations/zh_CN.po",
		"modules/org/openteacher/savers/t2k/translations/es.po",
		"modules/org/openteacher/savers/t2k/translations/org.openteacher.savers.t2k.pot",
		"modules/org/openteacher/savers/t2k/translations/pt_BR.po",
		"modules/org/openteacher/savers/t2k/translations/nl.po",
		"modules/org/openteacher/savers/t2k/translations/de.mo",
		"modules/org/openteacher/savers/t2k/translations/pt_BR.mo",
		"modules/org/openteacher/savers/t2k/translations/fy.mo",
		"modules/org/openteacher/savers/t2k/translations/si.mo",
		"modules/org/openteacher/savers/t2k/translations/fr.po",
		"modules/org/openteacher/savers/t2k/translations/fr.mo",
		"modules/org/openteacher/savers/t2k/translations/de.po",
		"modules/org/openteacher/savers/t2k/translations/cs.po",
		"modules/org/openteacher/savers/t2k/translations/fy.po",
		"modules/org/openteacher/savers/t2k/translations/zh_TW.po",
		"modules/org/openteacher/savers/t2k/translations/zh_TW.mo",
		"modules/org/openteacher/savers/t2k/translations/zh_CN.mo",
		"modules/org/openteacher/savers/t2k/translations/nl.mo",
		"modules/org/openteacher/savers/t2k/translations/si.po",
		"modules/org/openteacher/savers/pdf/pdf.py",
		"modules/org/openteacher/savers/pdf/translations/es.mo",
		"modules/org/openteacher/savers/pdf/translations/cs.mo",
		"modules/org/openteacher/savers/pdf/translations/zh_CN.po",
		"modules/org/openteacher/savers/pdf/translations/es.po",
		"modules/org/openteacher/savers/pdf/translations/pt_BR.po",
		"modules/org/openteacher/savers/pdf/translations/nl.po",
		"modules/org/openteacher/savers/pdf/translations/de.mo",
		"modules/org/openteacher/savers/pdf/translations/pt_BR.mo",
		"modules/org/openteacher/savers/pdf/translations/fy.mo",
		"modules/org/openteacher/savers/pdf/translations/si.mo",
		"modules/org/openteacher/savers/pdf/translations/fr.po",
		"modules/org/openteacher/savers/pdf/translations/fr.mo",
		"modules/org/openteacher/savers/pdf/translations/de.po",
		"modules/org/openteacher/savers/pdf/translations/cs.po",
		"modules/org/openteacher/savers/pdf/translations/org.openteacher.savers.pdf.pot",
		"modules/org/openteacher/savers/pdf/translations/fy.po",
		"modules/org/openteacher/savers/pdf/translations/zh_TW.po",
		"modules/org/openteacher/savers/pdf/translations/zh_TW.mo",
		"modules/org/openteacher/savers/pdf/translations/zh_CN.mo",
		"modules/org/openteacher/savers/pdf/translations/nl.mo",
		"modules/org/openteacher/savers/pdf/translations/si.po",
		"modules/org/openteacher/savers/txt/txt.py",
		"modules/org/openteacher/savers/txt/translations/es.mo",
		"modules/org/openteacher/savers/txt/translations/cs.mo",
		"modules/org/openteacher/savers/txt/translations/zh_CN.po",
		"modules/org/openteacher/savers/txt/translations/org.openteacher.savers.txt.pot",
		"modules/org/openteacher/savers/txt/translations/es.po",
		"modules/org/openteacher/savers/txt/translations/pt_BR.po",
		"modules/org/openteacher/savers/txt/translations/nl.po",
		"modules/org/openteacher/savers/txt/translations/de.mo",
		"modules/org/openteacher/savers/txt/translations/pt_BR.mo",
		"modules/org/openteacher/savers/txt/translations/fy.mo",
		"modules/org/openteacher/savers/txt/translations/si.mo",
		"modules/org/openteacher/savers/txt/translations/fr.po",
		"modules/org/openteacher/savers/txt/translations/fr.mo",
		"modules/org/openteacher/savers/txt/translations/de.po",
		"modules/org/openteacher/savers/txt/translations/cs.po",
		"modules/org/openteacher/savers/txt/translations/fy.po",
		"modules/org/openteacher/savers/txt/translations/zh_TW.po",
		"modules/org/openteacher/savers/txt/translations/zh_TW.mo",
		"modules/org/openteacher/savers/txt/translations/zh_CN.mo",
		"modules/org/openteacher/savers/txt/translations/nl.mo",
		"modules/org/openteacher/savers/txt/translations/si.po",
		"modules/org/openteacher/saver/saver.py",
		"modules/org/openteacher/maps/usa/usa.py",
		"modules/org/openteacher/maps/usa/resources/map.gif",
		"modules/org/openteacher/maps/usa/resources/places.json",
		"modules/org/openteacher/maps/usa/resources/COPYING",
		"modules/org/openteacher/maps/world/world.py",
		"modules/org/openteacher/maps/world/resources/map.gif",
		"modules/org/openteacher/maps/world/resources/places.json",
		"modules/org/openteacher/maps/world/resources/COPYING",
		"modules/org/openteacher/maps/europe/europe.py",
		"modules/org/openteacher/maps/europe/resources/map.gif",
		"modules/org/openteacher/maps/europe/resources/places.json",
		"modules/org/openteacher/maps/europe/resources/COPYING",
		"modules/org/openteacher/maps/latinamerica/latinamerica.py",
		"modules/org/openteacher/maps/latinamerica/resources/map.gif",
		"modules/org/openteacher/maps/latinamerica/resources/places.json",
		"modules/org/openteacher/maps/latinamerica/resources/COPYING",
		"modules/org/openteacher/maps/asia/asia.py",
		"modules/org/openteacher/maps/asia/resources/map.gif",
		"modules/org/openteacher/maps/asia/resources/places.json",
		"modules/org/openteacher/maps/asia/resources/COPYING",
		"modules/org/openteacher/maps/africa/africa.py",
		"modules/org/openteacher/maps/africa/resources/map.gif",
		"modules/org/openteacher/maps/africa/resources/places.json",
		"modules/org/openteacher/maps/africa/resources/COPYING",
		"modules/org/openteacher/printer/printer.py",
		"modules/org/openteacher/loader/loader.py",
		"modules/org/openteacher/eventTest/eventTest.py",
		"modules/org/openteacher/profileDescriptions/packageSource/packageSource.py",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/es.po",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/de.po",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/org.openteacher.profileDescriptions.packageSource.pot",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/packageSource/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/codedocumentation/codedocumentation.py",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/es.po",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/org.openteacher.profileDescriptions.codedocumentation.pot",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/de.po",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/codedocumentation/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/wordsonly/wordsonly.py",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/es.po",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/org.openteacher.profileDescriptions.wordsonly.pot",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/ja.mo",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/ja.po",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/de.po",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/wordsonly/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/testsuite/testsuite.py",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/es.po",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/de.po",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/org.openteacher.profileDescriptions.testsuite.pot",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/testsuite/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/packageArch/packageArch.py",
		"modules/org/openteacher/profileDescriptions/packageArch/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/packageArch/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/packageArch/translations/es.po",
		"modules/org/openteacher/profileDescriptions/packageArch/translations/org.openteacher.profileDescriptions.packageArch.pot",
		"modules/org/openteacher/profileDescriptions/packageArch/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/packageArch/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/packageArch/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/packageArch/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/packageArch/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/packageArch/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/packageArch/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/packageArch/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/packageArch/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/packageRpm/packageRpm.py",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/es.po",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/org.openteacher.profileDescriptions.packageRpm.pot",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/de.po",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/packageRpm/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/packageDebian/packageDebian.py",
		"modules/org/openteacher/profileDescriptions/packageDebian/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/packageDebian/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/packageDebian/translations/es.po",
		"modules/org/openteacher/profileDescriptions/packageDebian/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/packageDebian/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/packageDebian/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/packageDebian/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/packageDebian/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/packageDebian/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/packageDebian/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/packageDebian/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/packageDebian/translations/org.openteacher.profileDescriptions.packageDebian.pot",
		"modules/org/openteacher/profileDescriptions/packageDebian/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/selfstudy.py",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/es.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/ja.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/ja.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/de.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/org.openteacher.profileDescriptions.selfstudy.pot",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/selfstudy/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/packageSourceWithSetup.py",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/org.openteacher.profileDescriptions.packageSourceWithSetup.pot",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/es.po",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/de.po",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/packageSourceWithSetup/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/shell/shell.py",
		"modules/org/openteacher/profileDescriptions/shell/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/shell/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/shell/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/shell/translations/es.po",
		"modules/org/openteacher/profileDescriptions/shell/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/shell/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/shell/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/shell/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/shell/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/shell/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/shell/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/shell/translations/de.po",
		"modules/org/openteacher/profileDescriptions/shell/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/shell/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/shell/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/shell/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/shell/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/shell/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/shell/translations/org.openteacher.profileDescriptions.shell.pot",
		"modules/org/openteacher/profileDescriptions/studentAtHome/studentAtHome.py",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/es.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/org.openteacher.profileDescriptions.studentAtHome.pot",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/ja.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/ja.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/de.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/studentAtHome/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/packageWindowsPortable.py",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/es.po",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/de.po",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/org.openteacher.profileDescriptions.packageWindowsPortable.pot",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/packageWindowsPortable/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/studentAtSchool.py",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/es.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/ja.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/ja.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/de.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/studentAtSchool/translations/org.openteacher.profileDescriptions.studentAtSchool.pot",
		"modules/org/openteacher/profileDescriptions/generateMobile/generateMobile.py",
		"modules/org/openteacher/profileDescriptions/generateMobile/translations/org.openteacher.profileDescriptions.generateMobile.pot",
		"modules/org/openteacher/profileDescriptions/ircbot/ircbot.py",
		"modules/org/openteacher/profileDescriptions/ircbot/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/ircbot/translations/org.openteacher.profileDescriptions.ircbot.pot",
		"modules/org/openteacher/profileDescriptions/ircbot/translations/es.po",
		"modules/org/openteacher/profileDescriptions/ircbot/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/ircbot/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/ircbot/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/ircbot/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/ircbot/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/ircbot/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/ircbot/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/ircbot/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/module-graph/module-graph.py",
		"modules/org/openteacher/profileDescriptions/module-graph/translations/org.openteacher.profileDescriptions.module-graph.pot",
		"modules/org/openteacher/profileDescriptions/module-graph/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/module-graph/translations/es.po",
		"modules/org/openteacher/profileDescriptions/module-graph/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/module-graph/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/module-graph/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/module-graph/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/module-graph/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/module-graph/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/module-graph/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/module-graph/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/getTranslationAuthors/getTranslationAuthors.py",
		"modules/org/openteacher/profileDescriptions/getTranslationAuthors/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/getTranslationAuthors/translations/es.po",
		"modules/org/openteacher/profileDescriptions/getTranslationAuthors/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/getTranslationAuthors/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/getTranslationAuthors/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/getTranslationAuthors/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/getTranslationAuthors/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/getTranslationAuthors/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/getTranslationAuthors/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/getTranslationAuthors/translations/org.openteacher.profileDescriptions.getTranslationAuthors.pot",
		"modules/org/openteacher/profileDescriptions/getTranslationAuthors/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/help/help.py",
		"modules/org/openteacher/profileDescriptions/help/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/help/translations/org.openteacher.profileDescriptions.help.pot",
		"modules/org/openteacher/profileDescriptions/help/translations/es.po",
		"modules/org/openteacher/profileDescriptions/help/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/help/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/help/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/help/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/help/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/help/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/help/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/help/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/testserver/testserver.py",
		"modules/org/openteacher/profileDescriptions/testserver/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/testserver/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/testserver/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/testserver/translations/es.po",
		"modules/org/openteacher/profileDescriptions/testserver/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/testserver/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/testserver/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/testserver/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/testserver/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/testserver/translations/org.openteacher.profileDescriptions.testserver.pot",
		"modules/org/openteacher/profileDescriptions/testserver/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/testserver/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/testserver/translations/de.po",
		"modules/org/openteacher/profileDescriptions/testserver/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/testserver/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/testserver/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/testserver/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/testserver/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/testserver/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/updateTranslations/updateTranslations.py",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/es.po",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/org.openteacher.profileDescriptions.updateTranslations.pot",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/de.po",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/updateTranslations/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/packageWindowsMsi/packageWindowsMsi.py",
		"modules/org/openteacher/profileDescriptions/packageWindowsMsi/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/packageWindowsMsi/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/packageWindowsMsi/translations/es.po",
		"modules/org/openteacher/profileDescriptions/packageWindowsMsi/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/packageWindowsMsi/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/packageWindowsMsi/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/packageWindowsMsi/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/packageWindowsMsi/translations/org.openteacher.profileDescriptions.packageWindowsMsi.pot",
		"modules/org/openteacher/profileDescriptions/packageWindowsMsi/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/packageWindowsMsi/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/packageWindowsMsi/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/packageWindowsMsi/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/packageWindowsMsi/translations/nl.mo",
		"modules/org/openteacher/profileDescriptions/all/all.py",
		"modules/org/openteacher/profileDescriptions/all/translations/es.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/cs.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/zh_CN.po",
		"modules/org/openteacher/profileDescriptions/all/translations/es.po",
		"modules/org/openteacher/profileDescriptions/all/translations/org.openteacher.profileDescriptions.all.pot",
		"modules/org/openteacher/profileDescriptions/all/translations/pt_BR.po",
		"modules/org/openteacher/profileDescriptions/all/translations/nl.po",
		"modules/org/openteacher/profileDescriptions/all/translations/de.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/pt_BR.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/fy.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/fr.po",
		"modules/org/openteacher/profileDescriptions/all/translations/fr.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/de.po",
		"modules/org/openteacher/profileDescriptions/all/translations/cs.po",
		"modules/org/openteacher/profileDescriptions/all/translations/fy.po",
		"modules/org/openteacher/profileDescriptions/all/translations/zh_TW.po",
		"modules/org/openteacher/profileDescriptions/all/translations/zh_TW.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/zh_CN.mo",
		"modules/org/openteacher/profileDescriptions/all/translations/nl.mo",
		"modules/org/openteacher/wordsHtmlGenerator/template.html",
		"modules/org/openteacher/wordsHtmlGenerator/wordsHtmlGenerator.py",
		"modules/org/openteacher/percentNotesViewer/percentNotesViewer.py",
		"modules/org/openteacher/pydistInterface/pydistInterface.py",
		"modules/org/openteacher/inputTyping/inputTyping.py",
		"modules/org/openteacher/inputTyping/translations/ar.po",
		"modules/org/openteacher/inputTyping/translations/es.mo",
		"modules/org/openteacher/inputTyping/translations/cs.mo",
		"modules/org/openteacher/inputTyping/translations/zh_CN.po",
		"modules/org/openteacher/inputTyping/translations/es.po",
		"modules/org/openteacher/inputTyping/translations/hu.mo",
		"modules/org/openteacher/inputTyping/translations/ru.po",
		"modules/org/openteacher/inputTyping/translations/fi.mo",
		"modules/org/openteacher/inputTyping/translations/pt_BR.po",
		"modules/org/openteacher/inputTyping/translations/nl.po",
		"modules/org/openteacher/inputTyping/translations/de.mo",
		"modules/org/openteacher/inputTyping/translations/org.openteacher.inputTyping.pot",
		"modules/org/openteacher/inputTyping/translations/pt_BR.mo",
		"modules/org/openteacher/inputTyping/translations/fy.mo",
		"modules/org/openteacher/inputTyping/translations/sk.po",
		"modules/org/openteacher/inputTyping/translations/el.po",
		"modules/org/openteacher/inputTyping/translations/si.mo",
		"modules/org/openteacher/inputTyping/translations/ja.mo",
		"modules/org/openteacher/inputTyping/translations/fr.po",
		"modules/org/openteacher/inputTyping/translations/fr.mo",
		"modules/org/openteacher/inputTyping/translations/sk.mo",
		"modules/org/openteacher/inputTyping/translations/ja.po",
		"modules/org/openteacher/inputTyping/translations/de.po",
		"modules/org/openteacher/inputTyping/translations/cs.po",
		"modules/org/openteacher/inputTyping/translations/ar.mo",
		"modules/org/openteacher/inputTyping/translations/el.mo",
		"modules/org/openteacher/inputTyping/translations/fi.po",
		"modules/org/openteacher/inputTyping/translations/ru.mo",
		"modules/org/openteacher/inputTyping/translations/fy.po",
		"modules/org/openteacher/inputTyping/translations/zh_TW.po",
		"modules/org/openteacher/inputTyping/translations/zh_TW.mo",
		"modules/org/openteacher/inputTyping/translations/hu.po",
		"modules/org/openteacher/inputTyping/translations/zh_CN.mo",
		"modules/org/openteacher/inputTyping/translations/nl.mo",
		"modules/org/openteacher/inputTyping/translations/si.po",
		"modules/org/openteacher/ttsProviders/topo/topo.py",
		"modules/org/openteacher/ttsProviders/topo/translations/org.openteacher.ttsProviders.topo.pot",
		"modules/org/openteacher/ttsProviders/topo/translations/es.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/cs.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/es.po",
		"modules/org/openteacher/ttsProviders/topo/translations/pt_BR.po",
		"modules/org/openteacher/ttsProviders/topo/translations/nl.po",
		"modules/org/openteacher/ttsProviders/topo/translations/de.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/pt_BR.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/fy.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/ja.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/fr.po",
		"modules/org/openteacher/ttsProviders/topo/translations/fr.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/ja.po",
		"modules/org/openteacher/ttsProviders/topo/translations/de.po",
		"modules/org/openteacher/ttsProviders/topo/translations/cs.po",
		"modules/org/openteacher/ttsProviders/topo/translations/fy.po",
		"modules/org/openteacher/ttsProviders/topo/translations/zh_TW.po",
		"modules/org/openteacher/ttsProviders/topo/translations/zh_TW.mo",
		"modules/org/openteacher/ttsProviders/topo/translations/nl.mo",
		"modules/org/openteacher/ttsProviders/words/words.py",
		"modules/org/openteacher/ttsProviders/words/translations/es.mo",
		"modules/org/openteacher/ttsProviders/words/translations/cs.mo",
		"modules/org/openteacher/ttsProviders/words/translations/org.openteacher.ttsProviders.words.pot",
		"modules/org/openteacher/ttsProviders/words/translations/es.po",
		"modules/org/openteacher/ttsProviders/words/translations/pt_BR.po",
		"modules/org/openteacher/ttsProviders/words/translations/nl.po",
		"modules/org/openteacher/ttsProviders/words/translations/de.mo",
		"modules/org/openteacher/ttsProviders/words/translations/pt_BR.mo",
		"modules/org/openteacher/ttsProviders/words/translations/fy.mo",
		"modules/org/openteacher/ttsProviders/words/translations/ja.mo",
		"modules/org/openteacher/ttsProviders/words/translations/fr.po",
		"modules/org/openteacher/ttsProviders/words/translations/fr.mo",
		"modules/org/openteacher/ttsProviders/words/translations/ja.po",
		"modules/org/openteacher/ttsProviders/words/translations/de.po",
		"modules/org/openteacher/ttsProviders/words/translations/cs.po",
		"modules/org/openteacher/ttsProviders/words/translations/fy.po",
		"modules/org/openteacher/ttsProviders/words/translations/zh_TW.po",
		"modules/org/openteacher/ttsProviders/words/translations/zh_TW.mo",
		"modules/org/openteacher/ttsProviders/words/translations/nl.mo",
		"modules/org/openteacher/teachers/media/media.py",
		"modules/org/openteacher/teachers/media/translations/es.mo",
		"modules/org/openteacher/teachers/media/translations/es.po",
		"modules/org/openteacher/teachers/media/translations/pt_BR.po",
		"modules/org/openteacher/teachers/media/translations/nl.po",
		"modules/org/openteacher/teachers/media/translations/pt_BR.mo",
		"modules/org/openteacher/teachers/media/translations/fy.mo",
		"modules/org/openteacher/teachers/media/translations/fy.po",
		"modules/org/openteacher/teachers/media/translations/zh_TW.po",
		"modules/org/openteacher/teachers/media/translations/org.openteacher.teachers.media.pot",
		"modules/org/openteacher/teachers/media/translations/zh_TW.mo",
		"modules/org/openteacher/teachers/media/translations/nl.mo",
		"modules/org/openteacher/teachers/topo/topo.py",
		"modules/org/openteacher/teachers/topo/translations/es.mo",
		"modules/org/openteacher/teachers/topo/translations/es.po",
		"modules/org/openteacher/teachers/topo/translations/pt_BR.po",
		"modules/org/openteacher/teachers/topo/translations/nl.po",
		"modules/org/openteacher/teachers/topo/translations/pt_BR.mo",
		"modules/org/openteacher/teachers/topo/translations/fy.mo",
		"modules/org/openteacher/teachers/topo/translations/org.openteacher.teachers.topo.pot",
		"modules/org/openteacher/teachers/topo/translations/fy.po",
		"modules/org/openteacher/teachers/topo/translations/zh_TW.po",
		"modules/org/openteacher/teachers/topo/translations/zh_TW.mo",
		"modules/org/openteacher/teachers/topo/translations/nl.mo",
		"modules/org/openteacher/teachers/words/words.py",
		"modules/org/openteacher/teachers/words/translations/ar.po",
		"modules/org/openteacher/teachers/words/translations/es.mo",
		"modules/org/openteacher/teachers/words/translations/cs.mo",
		"modules/org/openteacher/teachers/words/translations/zh_CN.po",
		"modules/org/openteacher/teachers/words/translations/es.po",
		"modules/org/openteacher/teachers/words/translations/hu.mo",
		"modules/org/openteacher/teachers/words/translations/ru.po",
		"modules/org/openteacher/teachers/words/translations/fi.mo",
		"modules/org/openteacher/teachers/words/translations/pt_BR.po",
		"modules/org/openteacher/teachers/words/translations/nl.po",
		"modules/org/openteacher/teachers/words/translations/de.mo",
		"modules/org/openteacher/teachers/words/translations/pt_BR.mo",
		"modules/org/openteacher/teachers/words/translations/fy.mo",
		"modules/org/openteacher/teachers/words/translations/sk.po",
		"modules/org/openteacher/teachers/words/translations/el.po",
		"modules/org/openteacher/teachers/words/translations/si.mo",
		"modules/org/openteacher/teachers/words/translations/ja.mo",
		"modules/org/openteacher/teachers/words/translations/fr.po",
		"modules/org/openteacher/teachers/words/translations/fr.mo",
		"modules/org/openteacher/teachers/words/translations/sk.mo",
		"modules/org/openteacher/teachers/words/translations/ja.po",
		"modules/org/openteacher/teachers/words/translations/de.po",
		"modules/org/openteacher/teachers/words/translations/cs.po",
		"modules/org/openteacher/teachers/words/translations/ar.mo",
		"modules/org/openteacher/teachers/words/translations/org.openteacher.wordsTeacher.pot",
		"modules/org/openteacher/teachers/words/translations/el.mo",
		"modules/org/openteacher/teachers/words/translations/fi.po",
		"modules/org/openteacher/teachers/words/translations/ru.mo",
		"modules/org/openteacher/teachers/words/translations/fy.po",
		"modules/org/openteacher/teachers/words/translations/zh_TW.po",
		"modules/org/openteacher/teachers/words/translations/zh_TW.mo",
		"modules/org/openteacher/teachers/words/translations/hu.po",
		"modules/org/openteacher/teachers/words/translations/zh_CN.mo",
		"modules/org/openteacher/teachers/words/translations/nl.mo",
		"modules/org/openteacher/teachers/words/translations/si.po",
		"modules/org/openteacher/uiController/uiController.py",
		"modules/org/openteacher/uiController/translations/es.mo",
		"modules/org/openteacher/uiController/translations/es.po",
		"modules/org/openteacher/uiController/translations/pt_BR.po",
		"modules/org/openteacher/uiController/translations/nl.po",
		"modules/org/openteacher/uiController/translations/pt_BR.mo",
		"modules/org/openteacher/uiController/translations/fy.mo",
		"modules/org/openteacher/uiController/translations/org.openteacher.uiController.pot",
		"modules/org/openteacher/uiController/translations/fy.po",
		"modules/org/openteacher/uiController/translations/zh_TW.po",
		"modules/org/openteacher/uiController/translations/zh_TW.mo",
		"modules/org/openteacher/uiController/translations/nl.mo",
		"modules/org/openteacher/getTranslationAuthors/getTranslationAuthors.py",
		"modules/org/openteacher/startWidget/startWidget.py",
		"modules/org/openteacher/startWidget/translations/ar.po",
		"modules/org/openteacher/startWidget/translations/es.mo",
		"modules/org/openteacher/startWidget/translations/cs.mo",
		"modules/org/openteacher/startWidget/translations/zh_CN.po",
		"modules/org/openteacher/startWidget/translations/es.po",
		"modules/org/openteacher/startWidget/translations/hu.mo",
		"modules/org/openteacher/startWidget/translations/en_AU.mo",
		"modules/org/openteacher/startWidget/translations/pt_BR.po",
		"modules/org/openteacher/startWidget/translations/nl.po",
		"modules/org/openteacher/startWidget/translations/de.mo",
		"modules/org/openteacher/startWidget/translations/pt_BR.mo",
		"modules/org/openteacher/startWidget/translations/en_AU.po",
		"modules/org/openteacher/startWidget/translations/fy.mo",
		"modules/org/openteacher/startWidget/translations/sk.po",
		"modules/org/openteacher/startWidget/translations/org.openteacher.startWidget.pot",
		"modules/org/openteacher/startWidget/translations/fr.po",
		"modules/org/openteacher/startWidget/translations/fr.mo",
		"modules/org/openteacher/startWidget/translations/sk.mo",
		"modules/org/openteacher/startWidget/translations/de.po",
		"modules/org/openteacher/startWidget/translations/cs.po",
		"modules/org/openteacher/startWidget/translations/ar.mo",
		"modules/org/openteacher/startWidget/translations/fy.po",
		"modules/org/openteacher/startWidget/translations/zh_TW.po",
		"modules/org/openteacher/startWidget/translations/zh_TW.mo",
		"modules/org/openteacher/startWidget/translations/hu.po",
		"modules/org/openteacher/startWidget/translations/zh_CN.mo",
		"modules/org/openteacher/startWidget/translations/nl.mo",
		"modules/org/openteacher/authors/authors.py",
		"modules/org/openteacher/testTypes/media/media.py",
		"modules/org/openteacher/testTypes/media/translations/es.mo",
		"modules/org/openteacher/testTypes/media/translations/cs.mo",
		"modules/org/openteacher/testTypes/media/translations/zh_CN.po",
		"modules/org/openteacher/testTypes/media/translations/es.po",
		"modules/org/openteacher/testTypes/media/translations/pt_BR.po",
		"modules/org/openteacher/testTypes/media/translations/nl.po",
		"modules/org/openteacher/testTypes/media/translations/de.mo",
		"modules/org/openteacher/testTypes/media/translations/pt_BR.mo",
		"modules/org/openteacher/testTypes/media/translations/fy.mo",
		"modules/org/openteacher/testTypes/media/translations/si.mo",
		"modules/org/openteacher/testTypes/media/translations/ja.mo",
		"modules/org/openteacher/testTypes/media/translations/fr.po",
		"modules/org/openteacher/testTypes/media/translations/fr.mo",
		"modules/org/openteacher/testTypes/media/translations/ja.po",
		"modules/org/openteacher/testTypes/media/translations/org.openteacher.testTypes.media.pot",
		"modules/org/openteacher/testTypes/media/translations/de.po",
		"modules/org/openteacher/testTypes/media/translations/cs.po",
		"modules/org/openteacher/testTypes/media/translations/fy.po",
		"modules/org/openteacher/testTypes/media/translations/zh_TW.po",
		"modules/org/openteacher/testTypes/media/translations/zh_TW.mo",
		"modules/org/openteacher/testTypes/media/translations/zh_CN.mo",
		"modules/org/openteacher/testTypes/media/translations/nl.mo",
		"modules/org/openteacher/testTypes/media/translations/si.po",
		"modules/org/openteacher/testTypes/topo/topo.py",
		"modules/org/openteacher/testTypes/topo/translations/es.mo",
		"modules/org/openteacher/testTypes/topo/translations/cs.mo",
		"modules/org/openteacher/testTypes/topo/translations/es.po",
		"modules/org/openteacher/testTypes/topo/translations/org.openteacher.testTypes.topo.pot",
		"modules/org/openteacher/testTypes/topo/translations/pt_BR.po",
		"modules/org/openteacher/testTypes/topo/translations/nl.po",
		"modules/org/openteacher/testTypes/topo/translations/de.mo",
		"modules/org/openteacher/testTypes/topo/translations/pt_BR.mo",
		"modules/org/openteacher/testTypes/topo/translations/fy.mo",
		"modules/org/openteacher/testTypes/topo/translations/ja.mo",
		"modules/org/openteacher/testTypes/topo/translations/fr.po",
		"modules/org/openteacher/testTypes/topo/translations/fr.mo",
		"modules/org/openteacher/testTypes/topo/translations/ja.po",
		"modules/org/openteacher/testTypes/topo/translations/de.po",
		"modules/org/openteacher/testTypes/topo/translations/cs.po",
		"modules/org/openteacher/testTypes/topo/translations/fy.po",
		"modules/org/openteacher/testTypes/topo/translations/zh_TW.po",
		"modules/org/openteacher/testTypes/topo/translations/zh_TW.mo",
		"modules/org/openteacher/testTypes/topo/translations/nl.mo",
		"modules/org/openteacher/testTypes/words/words.py",
		"modules/org/openteacher/testTypes/words/translations/es.mo",
		"modules/org/openteacher/testTypes/words/translations/cs.mo",
		"modules/org/openteacher/testTypes/words/translations/es.po",
		"modules/org/openteacher/testTypes/words/translations/pt_BR.po",
		"modules/org/openteacher/testTypes/words/translations/org.openteacher.testTypes.words.pot",
		"modules/org/openteacher/testTypes/words/translations/nl.po",
		"modules/org/openteacher/testTypes/words/translations/de.mo",
		"modules/org/openteacher/testTypes/words/translations/pt_BR.mo",
		"modules/org/openteacher/testTypes/words/translations/fy.mo",
		"modules/org/openteacher/testTypes/words/translations/ja.mo",
		"modules/org/openteacher/testTypes/words/translations/fr.po",
		"modules/org/openteacher/testTypes/words/translations/fr.mo",
		"modules/org/openteacher/testTypes/words/translations/ja.po",
		"modules/org/openteacher/testTypes/words/translations/de.po",
		"modules/org/openteacher/testTypes/words/translations/cs.po",
		"modules/org/openteacher/testTypes/words/translations/fy.po",
		"modules/org/openteacher/testTypes/words/translations/zh_TW.po",
		"modules/org/openteacher/testTypes/words/translations/zh_TW.mo",
		"modules/org/openteacher/testTypes/words/translations/nl.mo",
		"modules/org/openteacher/testsViewer/testsViewer.py",
		"modules/org/openteacher/testsViewer/translations/ar.po",
		"modules/org/openteacher/testsViewer/translations/es.mo",
		"modules/org/openteacher/testsViewer/translations/cs.mo",
		"modules/org/openteacher/testsViewer/translations/zh_CN.po",
		"modules/org/openteacher/testsViewer/translations/es.po",
		"modules/org/openteacher/testsViewer/translations/hu.mo",
		"modules/org/openteacher/testsViewer/translations/pt_BR.po",
		"modules/org/openteacher/testsViewer/translations/nl.po",
		"modules/org/openteacher/testsViewer/translations/de.mo",
		"modules/org/openteacher/testsViewer/translations/pt_BR.mo",
		"modules/org/openteacher/testsViewer/translations/fy.mo",
		"modules/org/openteacher/testsViewer/translations/el.po",
		"modules/org/openteacher/testsViewer/translations/si.mo",
		"modules/org/openteacher/testsViewer/translations/ja.mo",
		"modules/org/openteacher/testsViewer/translations/fr.po",
		"modules/org/openteacher/testsViewer/translations/org.openteacher.testsViewer.pot",
		"modules/org/openteacher/testsViewer/translations/fr.mo",
		"modules/org/openteacher/testsViewer/translations/ja.po",
		"modules/org/openteacher/testsViewer/translations/de.po",
		"modules/org/openteacher/testsViewer/translations/cs.po",
		"modules/org/openteacher/testsViewer/translations/ar.mo",
		"modules/org/openteacher/testsViewer/translations/el.mo",
		"modules/org/openteacher/testsViewer/translations/fy.po",
		"modules/org/openteacher/testsViewer/translations/zh_TW.po",
		"modules/org/openteacher/testsViewer/translations/zh_TW.mo",
		"modules/org/openteacher/testsViewer/translations/hu.po",
		"modules/org/openteacher/testsViewer/translations/zh_CN.mo",
		"modules/org/openteacher/testsViewer/translations/nl.mo",
		"modules/org/openteacher/testsViewer/translations/si.po",
		"modules/org/openteacher/topoMaps/topoMaps.py",
		"modules/org/openteacher/topoMaps/translations/es.mo",
		"modules/org/openteacher/topoMaps/translations/es.po",
		"modules/org/openteacher/topoMaps/translations/pt_BR.po",
		"modules/org/openteacher/topoMaps/translations/nl.po",
		"modules/org/openteacher/topoMaps/translations/pt_BR.mo",
		"modules/org/openteacher/topoMaps/translations/org.openteacher.topoMaps.pot",
		"modules/org/openteacher/topoMaps/translations/fy.mo",
		"modules/org/openteacher/topoMaps/translations/fy.po",
		"modules/org/openteacher/topoMaps/translations/zh_TW.po",
		"modules/org/openteacher/topoMaps/translations/zh_TW.mo",
		"modules/org/openteacher/topoMaps/translations/nl.mo",
		"modules/org/openteacher/topoMaps/resources/COPYING",
		"modules/org/openteacher/topoMaps/resources/crosshair.png",
		"modules/org/openteacher/settingsFilterer/settingsFilterer.py",
		"modules/org/openteacher/settingsFilterer/translations/es.mo",
		"modules/org/openteacher/settingsFilterer/translations/es.po",
		"modules/org/openteacher/settingsFilterer/translations/pt_BR.po",
		"modules/org/openteacher/settingsFilterer/translations/nl.po",
		"modules/org/openteacher/settingsFilterer/translations/pt_BR.mo",
		"modules/org/openteacher/settingsFilterer/translations/fy.mo",
		"modules/org/openteacher/settingsFilterer/translations/fy.po",
		"modules/org/openteacher/settingsFilterer/translations/zh_TW.po",
		"modules/org/openteacher/settingsFilterer/translations/org.openteacher.settingsFilterer.pot",
		"modules/org/openteacher/settingsFilterer/translations/zh_TW.mo",
		"modules/org/openteacher/settingsFilterer/translations/nl.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/foreignKnown.py",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/ar.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/es.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/cs.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/zh_CN.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/af.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/es.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/hu.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/af.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/fi.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/pt_BR.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/org.openteacher.itemModifiers.foreignKnown.pot",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/nl.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/de.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/pt_BR.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/fy.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/sk.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/el.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/si.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/fr.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/fr.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/sk.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/de.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/cs.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/ar.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/el.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/fi.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/fy.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/zh_TW.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/zh_TW.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/hu.po",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/zh_CN.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/nl.mo",
		"modules/org/openteacher/itemModifiers/foreignKnown/translations/si.po",
		"modules/org/openteacher/testRunner/testRunner.py",
		"modules/org/openteacher/mediaTypes/dailymotion/dailymotion.py",
		"modules/org/openteacher/mediaTypes/vimeo/vimeo.py",
		"modules/org/openteacher/mediaTypes/audio/audio.py",
		"modules/org/openteacher/mediaTypes/megavideo/megavideo.py",
		"modules/org/openteacher/mediaTypes/video/video.py",
		"modules/org/openteacher/mediaTypes/text/text.py",
		"modules/org/openteacher/mediaTypes/liveleak/liveleak.py",
		"modules/org/openteacher/mediaTypes/image/image.py",
		"modules/org/openteacher/mediaTypes/youtube/youtube.py",
		"modules/org/openteacher/mediaTypes/website/website.py",
		"modules/org/openteacher/wrtsApi/ui.py",
		"modules/org/openteacher/wrtsApi/api.py",
		"modules/org/openteacher/wrtsApi/wrtsApi.py",
		"modules/org/openteacher/wrtsApi/translations/ar.po",
		"modules/org/openteacher/wrtsApi/translations/es.mo",
		"modules/org/openteacher/wrtsApi/translations/org.openteacher.wrtsApi.pot",
		"modules/org/openteacher/wrtsApi/translations/cs.mo",
		"modules/org/openteacher/wrtsApi/translations/zh_CN.po",
		"modules/org/openteacher/wrtsApi/translations/es.po",
		"modules/org/openteacher/wrtsApi/translations/hu.mo",
		"modules/org/openteacher/wrtsApi/translations/fi.mo",
		"modules/org/openteacher/wrtsApi/translations/pt_BR.po",
		"modules/org/openteacher/wrtsApi/translations/nl.po",
		"modules/org/openteacher/wrtsApi/translations/de.mo",
		"modules/org/openteacher/wrtsApi/translations/pt_BR.mo",
		"modules/org/openteacher/wrtsApi/translations/fy.mo",
		"modules/org/openteacher/wrtsApi/translations/sk.po",
		"modules/org/openteacher/wrtsApi/translations/el.po",
		"modules/org/openteacher/wrtsApi/translations/si.mo",
		"modules/org/openteacher/wrtsApi/translations/ja.mo",
		"modules/org/openteacher/wrtsApi/translations/fr.po",
		"modules/org/openteacher/wrtsApi/translations/fr.mo",
		"modules/org/openteacher/wrtsApi/translations/sk.mo",
		"modules/org/openteacher/wrtsApi/translations/ja.po",
		"modules/org/openteacher/wrtsApi/translations/de.po",
		"modules/org/openteacher/wrtsApi/translations/cs.po",
		"modules/org/openteacher/wrtsApi/translations/ar.mo",
		"modules/org/openteacher/wrtsApi/translations/el.mo",
		"modules/org/openteacher/wrtsApi/translations/fi.po",
		"modules/org/openteacher/wrtsApi/translations/fy.po",
		"modules/org/openteacher/wrtsApi/translations/zh_TW.po",
		"modules/org/openteacher/wrtsApi/translations/zh_TW.mo",
		"modules/org/openteacher/wrtsApi/translations/hu.po",
		"modules/org/openteacher/wrtsApi/translations/zh_CN.mo",
		"modules/org/openteacher/wrtsApi/translations/nl.mo",
		"modules/org/openteacher/wrtsApi/translations/si.po",
		"modules/org/openteacher/theme/theme.py",
		"modules/org/openteacher/print/topo/topo.py",
		"modules/org/openteacher/print/words/words.py",
		"modules/org/openteacher/print/words/translations/org.openteacher.print.words.pot",
		"modules/org/openteacher/print/words/translations/ar.po",
		"modules/org/openteacher/print/words/translations/es.mo",
		"modules/org/openteacher/print/words/translations/cs.mo",
		"modules/org/openteacher/print/words/translations/zh_CN.po",
		"modules/org/openteacher/print/words/translations/es.po",
		"modules/org/openteacher/print/words/translations/hu.mo",
		"modules/org/openteacher/print/words/translations/fi.mo",
		"modules/org/openteacher/print/words/translations/pt_BR.po",
		"modules/org/openteacher/print/words/translations/nl.po",
		"modules/org/openteacher/print/words/translations/de.mo",
		"modules/org/openteacher/print/words/translations/pt_BR.mo",
		"modules/org/openteacher/print/words/translations/fy.mo",
		"modules/org/openteacher/print/words/translations/sk.po",
		"modules/org/openteacher/print/words/translations/el.po",
		"modules/org/openteacher/print/words/translations/ja.mo",
		"modules/org/openteacher/print/words/translations/fr.po",
		"modules/org/openteacher/print/words/translations/fr.mo",
		"modules/org/openteacher/print/words/translations/sk.mo",
		"modules/org/openteacher/print/words/translations/ja.po",
		"modules/org/openteacher/print/words/translations/de.po",
		"modules/org/openteacher/print/words/translations/cs.po",
		"modules/org/openteacher/print/words/translations/ar.mo",
		"modules/org/openteacher/print/words/translations/el.mo",
		"modules/org/openteacher/print/words/translations/fi.po",
		"modules/org/openteacher/print/words/translations/fy.po",
		"modules/org/openteacher/print/words/translations/zh_TW.po",
		"modules/org/openteacher/print/words/translations/zh_TW.mo",
		"modules/org/openteacher/print/words/translations/hu.po",
		"modules/org/openteacher/print/words/translations/zh_CN.mo",
		"modules/org/openteacher/print/words/translations/nl.mo",
		"modules/org/openteacher/settingsWidgets/settingsWidgets.py",
		"modules/org/openteacher/testViewer/testViewer.py",
		"modules/org/openteacher/testViewer/translations/ar.po",
		"modules/org/openteacher/testViewer/translations/es.mo",
		"modules/org/openteacher/testViewer/translations/cs.mo",
		"modules/org/openteacher/testViewer/translations/org.openteacher.testViewer.pot",
		"modules/org/openteacher/testViewer/translations/es.po",
		"modules/org/openteacher/testViewer/translations/hu.mo",
		"modules/org/openteacher/testViewer/translations/pt_BR.po",
		"modules/org/openteacher/testViewer/translations/nl.po",
		"modules/org/openteacher/testViewer/translations/de.mo",
		"modules/org/openteacher/testViewer/translations/pt_BR.mo",
		"modules/org/openteacher/testViewer/translations/fy.mo",
		"modules/org/openteacher/testViewer/translations/el.po",
		"modules/org/openteacher/testViewer/translations/ja.mo",
		"modules/org/openteacher/testViewer/translations/fr.po",
		"modules/org/openteacher/testViewer/translations/fr.mo",
		"modules/org/openteacher/testViewer/translations/ja.po",
		"modules/org/openteacher/testViewer/translations/de.po",
		"modules/org/openteacher/testViewer/translations/cs.po",
		"modules/org/openteacher/testViewer/translations/ar.mo",
		"modules/org/openteacher/testViewer/translations/el.mo",
		"modules/org/openteacher/testViewer/translations/fy.po",
		"modules/org/openteacher/testViewer/translations/zh_TW.po",
		"modules/org/openteacher/testViewer/translations/zh_TW.mo",
		"modules/org/openteacher/testViewer/translations/hu.po",
		"modules/org/openteacher/testViewer/translations/nl.mo",
		"modules/org/openteacher/progressViewer/progressViewer.py",
		"modules/org/openteacher/progressViewer/translations/es.mo",
		"modules/org/openteacher/progressViewer/translations/cs.mo",
		"modules/org/openteacher/progressViewer/translations/zh_CN.po",
		"modules/org/openteacher/progressViewer/translations/es.po",
		"modules/org/openteacher/progressViewer/translations/pt_BR.po",
		"modules/org/openteacher/progressViewer/translations/nl.po",
		"modules/org/openteacher/progressViewer/translations/de.mo",
		"modules/org/openteacher/progressViewer/translations/pt_BR.mo",
		"modules/org/openteacher/progressViewer/translations/fy.mo",
		"modules/org/openteacher/progressViewer/translations/si.mo",
		"modules/org/openteacher/progressViewer/translations/ja.mo",
		"modules/org/openteacher/progressViewer/translations/fr.po",
		"modules/org/openteacher/progressViewer/translations/fr.mo",
		"modules/org/openteacher/progressViewer/translations/ja.po",
		"modules/org/openteacher/progressViewer/translations/de.po",
		"modules/org/openteacher/progressViewer/translations/cs.po",
		"modules/org/openteacher/progressViewer/translations/org.openteacher.progressViewer.pot",
		"modules/org/openteacher/progressViewer/translations/fy.po",
		"modules/org/openteacher/progressViewer/translations/zh_TW.po",
		"modules/org/openteacher/progressViewer/translations/zh_TW.mo",
		"modules/org/openteacher/progressViewer/translations/zh_CN.mo",
		"modules/org/openteacher/progressViewer/translations/nl.mo",
		"modules/org/openteacher/progressViewer/translations/si.po",
		"modules/org/openteacher/ircBot/bot.py",
		"modules/org/openteacher/ircBot/ircBot.py",
		"modules/org/openteacher/modules/modules.py",
		"modules/org/openteacher/dataStore/dataStore.py",
		"modules/org/openteacher/execute/execute.py",
		"modules/org/openteacher/execute/translations/es.mo",
		"modules/org/openteacher/execute/translations/cs.mo",
		"modules/org/openteacher/execute/translations/es.po",
		"modules/org/openteacher/execute/translations/fi.mo",
		"modules/org/openteacher/execute/translations/pt_BR.po",
		"modules/org/openteacher/execute/translations/nl.po",
		"modules/org/openteacher/execute/translations/pt_BR.mo",
		"modules/org/openteacher/execute/translations/fy.mo",
		"modules/org/openteacher/execute/translations/fr.po",
		"modules/org/openteacher/execute/translations/fr.mo",
		"modules/org/openteacher/execute/translations/cs.po",
		"modules/org/openteacher/execute/translations/fi.po",
		"modules/org/openteacher/execute/translations/fy.po",
		"modules/org/openteacher/execute/translations/zh_TW.po",
		"modules/org/openteacher/execute/translations/zh_TW.mo",
		"modules/org/openteacher/execute/translations/org.openteacher.execute.pot",
		"modules/org/openteacher/execute/translations/nl.mo",
		"modules/org/openteacher/translator/translator.py",
		"modules/org/openteacher/translator/translations/es.mo",
		"modules/org/openteacher/translator/translations/cs.mo",
		"modules/org/openteacher/translator/translations/es.po",
		"modules/org/openteacher/translator/translations/pt_BR.po",
		"modules/org/openteacher/translator/translations/nl.po",
		"modules/org/openteacher/translator/translations/de.mo",
		"modules/org/openteacher/translator/translations/pt_BR.mo",
		"modules/org/openteacher/translator/translations/fy.mo",
		"modules/org/openteacher/translator/translations/ja.mo",
		"modules/org/openteacher/translator/translations/fr.po",
		"modules/org/openteacher/translator/translations/org.openteacher.translator.pot",
		"modules/org/openteacher/translator/translations/fr.mo",
		"modules/org/openteacher/translator/translations/ja.po",
		"modules/org/openteacher/translator/translations/de.po",
		"modules/org/openteacher/translator/translations/cs.po",
		"modules/org/openteacher/translator/translations/fy.po",
		"modules/org/openteacher/translator/translations/zh_TW.po",
		"modules/org/openteacher/translator/translations/zh_TW.mo",
		"modules/org/openteacher/translator/translations/nl.mo",
		"modules/org/openteacher/otxxloader/otxxloader.py",
	]},
	data_files = [
		("share/applications", [
			"linux/openteacher.desktop"
		]),
		("share/icons/hicolor/128x128/mimetypes", ['linux/application-x-openteacher.png', 'linux/application-x-teach2000.png', 'linux/application-x-wrts.png', 'linux/application-x-openteachingwords.png', 'linux/application-x-openteachingtopography.png', 'linux/application-x-openteachingmedia.png']),
		("share/icons/hicolor/128x128/apps", [
			"linux/openteacher.png"
		]),
		("share/mime/packages", [
			"linux/openteacher.xml"
		])
	],
	scripts = ["bin/openteacher"],
	#a list of classifiers can be found at http://pypi.python.org/pypi?:action=list_classifiers
	classifiers = [
		"Development Status :: 5 - Production/Stable", 
		"Intended Audience :: End Users/Desktop",
		"Intended Audience :: Education",
		"License :: OSI Approved :: GNU General Public License (GPL)",
		"Operating System :: POSIX :: Linux",
		"Operating System :: Microsoft :: Windows",
		"Operating System :: MacOS :: MacOS X",
		"Environment :: X11 Applications :: Qt",
		"Programming Language :: Python",
		"Topic :: Education :: Testing",
	],
	long_description = """OpenTeacher is an opensource application that helps you learning a variety
of subjects. You just enter the questions and the answers, or download them from
the internet, and OpenTeacher tests you.

OpenTeacher 3.0 has the following features:
 * Viewing both recent and past results of tests with graphs
 * Smart question asking and interval training
 * Reverse rehearsal (the answer is asked, and you need to give the question)
 * Read and write Teach2000, WRDS and OpenTeacher 2.x files and read ABBYY
   Lingvo Tutor files
 * Save and open your online WRDS vocabulary lists
 * Print your word lists or topography maps
 * (Partly) available in Arabic, Brazilian Portuguese, Simplified Chinese,
   Traditional Chinese, Czech, Dutch, Finnish, French, Frisian, German, Greek,
   Japanese and Spanish

OpenTeacher is available for Linux, Windows and Mac OS X."""
)
