'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: CJKCTLDependency1.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: hde $ $Date: 2005/09/08 08:46:46 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Test CJK and CTL support dependency
'*
'************************************************************************
'*
' #1 tCJKDependency_1        'Test Tabpage 'Text Grid'
' #1 tCJKDependency_2        'Test Tabpage 'Asian Typography'
' #1 tCJKDependency_3        'Test CheckBox 'Snap to text grid (if active)'
' #1 tCJKDependency_4        'Test listbox 'Text direction' in page
' #1 tCJKDependency_5        'Test listbox 'Text direction' in Frame
' #1 tCTLDependency_1        'Test listbox 'Text direction' -- insert/section
' #1 tCTLDependency_2        'Test listbox 'Text direction' -- format/section
' #1 tCTLDependency_3        'Test listbox 'Text direction' -- table
' #1 tCTLDependency_4        'Test 'left to right' and 'right to left' button(Writer)
' #1 tCTLDependency_5        'Test 'left to right' and 'right to left' button - HTML(HTML 3.2)
' #1 tCTLDependency_6        'Test 'left to right' and 'right to left' button - HTML(Microsoft Internet Bxplorer)
' #1 tCTLDependency_7        'Test 'left to right' and 'right to left' button - HTML(Netscape Navigator)
' #1 tCTLDependency_8        'Test 'left to right' and 'right to left' button - HTML(StarOffice Writer)
'*
'\***********************************************************************

testcase tCJKDependency_1

  Dim bAsianLanguage   as Boolean

  '/// Test Tabpage 'Text Grid
  PrintLog "- Tabpage 'Text Grid"

  '/// Open a new document
  Call hNewDocument

  '/// Set 'Asian Language support' ON
   bAsianLanguage = ActiveDeactivateAsianSupport(TRUE)

  '/// Format/Page , the tabpage "Text Grid" should exist
   FormatPageWriter
   try
       Kontext
       Active.SetPage TabGrid
       Kontext "TabGrid"
       TabGrid.Cancel
   catch
       Kontext
       Active.SetPage TabSeite
       Kontext "TabSeite"
       TabSeite.Cancel
       warnlog "Should get Tabpage: Grid Text"
   endcatch

   'if system language is Asian language, the checkbox
   ''Asian Language support' is checked by default and
   'can't do any operation for it
   if iSystemSprache = 81 Or iSystemSprache = 82 Or iSystemSprache = 86 or iSystemSprache = 88 then
       Goto NoTest
   end if

  '/// Set 'Asian Language support' Off
   ActiveDeactivateAsianSupport(FALSE)

  '/// Format/Page , the tabpage "Text Grid" shouldn't exist
   FormatPageWriter
   try
       Kontext
       Active.SetPage TabGrid
       Kontext "TabGrid"
       TabGrid.Cancel
       warnlog "Shouldn't get Tabpage: Grid Text"
   catch
       Kontext
       Active.SetPage TabSeite
       Kontext "TabSeite"
       TabSeite.Cancel
   endcatch

  '/// Set the 'Asian Language support' to default
   if bAsianLanguage = FALSE then
       Call ActiveDeactivateAsianSupport(FALSE)
   end if

NoTest:
  '/// Close active document
   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tCJKDependency_2

  Dim bAsianLanguage   as Boolean

  '/// Test Tabpage 'Asian Typography'
  PrintLog "- Tabpage'Asian Typography'"

  '/// Open a new document
  Call hNewDocument

  '/// Set 'Asian Language support' ON
   bAsianLanguage = ActiveDeactivateAsianSupport(TRUE)

  '/// Format/Paragraph , the tabpage "Asian Typography" should exist
   FormatParagraph
   try
       Kontext
       Active.SetPage TabAsianTypography
       Kontext "TabAsianTypography"
       TabAsianTypography.Cancel
   catch
       Kontext
       Active.SetPage TabTextfluss
       Kontext "TabTextfluss"
       TabTextfluss.Cancel
       warnlog "Should get Tabpage: Asian Typography"
   endcatch

   'if system language is Asian language, the checkbox
   ''Asian Language support' is checked by default and
   'can't do any operation for it
   if iSystemSprache = 81 Or iSystemSprache = 82 Or iSystemSprache = 86 or iSystemSprache = 88 then
       Goto NoTest
   end if

  '/// Set 'Asian Language support' Off
   ActiveDeactivateAsianSupport(FALSE)

  '/// Format/Page , the tabpage "Asian Typography" shouldn't exist
   FormatParagraph
   try
       Kontext
       Active.SetPage TabAsianTypography
       Kontext "TabAsianTypography"
       TabAsianTypography.Cancel
       warnlog "Shouldn't get Tabpage: Asian Typography"
   catch
       Kontext
       Active.SetPage TabTextfluss
       Kontext "TabTextfluss"
       TabTextfluss.Cancel
   endcatch

  '/// Set the 'Asian Language support' to default
   if bAsianLanguage = FALSE then
       Call ActiveDeactivateAsianSupport(FALSE)
   end if

NoTest:
  '/// Close active document
   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tCJKDependency_3

  Dim bAsianLanguage   as Boolean

  '/// Test CheckBox 'Snap to text grid (if active)'
  PrintLog "- CheckBox 'Snap to text grid (if active)'"

  '/// Open a new document
  Call hNewDocument

  '/// Set 'Asian Language support' ON
   bAsianLanguage = ActiveDeactivateAsianSupport(TRUE)

  '/// Format/Paragraph / Alignment ,
  '/// the CheckBox 'Snap to text grid (if active)' should exist
   Call fFormatParagraph("TabAusrichtungAbsatz")
       try
           TextrasterFangen.UnCheck
       catch
           warnlog "Should get checkbox 'Snap to text grid (if active)'"
       endcatch
   TabAusrichtungAbsatz.Cancel

   'if system language is Asian language, the checkbox
   ''Asian Language support' is checked by default and
   'can't do any operation for it
   if iSystemSprache = 81 Or iSystemSprache = 82 Or iSystemSprache = 86 or iSystemSprache = 88 then
       Goto NoTest
   end if

  '/// Set 'Asian Language support' Off
   ActiveDeactivateAsianSupport(FALSE)

  '/// Format/Paragraph / Alignment ,
  '/// the CheckBox 'Snap to text grid (if active)' shouldn't exist
   Call fFormatParagraph("TabAusrichtungAbsatz")
       try
           TextrasterFangen.UnCheck
           warnlog "Shouldn't get checkbox 'Snap to text grid (if active)'"
       catch
       endcatch
   TabAusrichtungAbsatz.Cancel

  '/// Set the 'Asian Language support' to default
   if bAsianLanguage = FALSE then
       Call ActiveDeactivateAsianSupport(FALSE)
   end if

NoTest:
  '/// Close active document
   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tCJKDependency_4

    Dim bAsianLanguage , bCTLLanguage as Boolean
    'if system language is Asian language, the checkbox
    ''Asian Language support' is checked by default and
    'can't do any operation for it
    Select Case iSystemSprache
        Case 81, 82, 86, 88 then
            goto endsub
    end select
    
    '/// Test listbox 'Text direction' - Page
    PrintLog "- listbox 'Text direction' - Page"
    
    '/// Open a new document
    Call hNewDocument
    
    '/// Set 'CTL language support' OFF
    bCTLLanguage = ActiveDeactivateCTLSupport(FALSE)
    
    '/// Set 'Asian Language support' ON
    bAsianLanguage = ActiveDeactivateAsianSupport(TRUE)
    
    '/// Format/Page / Page, the listbox 'Text direction' should exist
    Call fFormatPageWriter("TabSeite")
    if Textfluss.IsVisible = TRUE then
        Textfluss.Select 2
    else
        warnlog "Should get listbox 'Text direction'"
    end if
    TabSeite.Cancel    
    
    '/// Set 'Asian Language support' Off
    ActiveDeactivateAsianSupport(FALSE)    
    '/// Format/Page / Page, the listbox 'Text direction' shouldn't exist
    Call fFormatPageWriter("TabSeite")
    if Textfluss.IsVisible = TRUE then
        warnlog "Shouldn't get listbox 'Text direction'"
    end if
    TabSeite.Cancel
    
    '/// Set the 'Asian Language support' to default
    if bAsianLanguage = FALSE then
       Call ActiveDeactivateAsianSupport(FALSE)
    end if
    
    Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tCJKDependency_5

    Dim bAsianLanguage , bCTLLanguage as Boolean
    
    '/// Test listbox 'Text direction' - Frame
    PrintLog "- listbox 'Text direction' - Frame"
    
    '/// Open a new document
    Call hNewDocument
    
    '/// Set 'CTL language support' OFF
    bCTLLanguage = ActiveDeactivateCTLSupport(FALSE)
    
    '/// Set 'Asian Language support' ON
    bAsianLanguage = ActiveDeactivateAsianSupport(TRUE)
    
    '/// Insert a frame
    Call wInsertFrame
    
    '/// Format/Frame / Options, the listbox 'Text direction' should exist
    Call fFormatFrame("TabZusaetze")
    if Not TextDirection.IsVisible then
        warnlog "Should get listbox 'Text direction'"
    end if
    TabZusaetze.Cancel
    
    'if system language is Asian language, the checkbox
    ''Asian Language support' is checked by default and
    'can't do any operation for it
    if iSystemSprache = 81 Or iSystemSprache = 82 Or iSystemSprache = 86 or iSystemSprache = 88 then
        Goto NoTest
    end if
    
    '/// Set 'Asian Language support' Off
    ActiveDeactivateAsianSupport(FALSE)
    
    '/// Format/Frame / Options, the listbox 'Text direction' shouldn't exist
    Call fFormatFrame("TabZusaetze")
    if TextDirection.IsVisible = TRUE then
        QAErrorLog "#135837# Shouldn't get listbox 'Text direction'."
    end if
    TabZusaetze.Cancel
    
    '/// Set the 'Asian Language support' to default
    if bAsianLanguage = FALSE then
        Call ActiveDeactivateAsianSupport(FALSE)
    end if
    
NoTest:
    '/// Set the 'CTL language support' to default
    if bCTLLanguage = TRUE then
        Call ActiveDeactivateAsianSupport(TRUE)
    end if
    
    '/// Close active document
    Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tCTLDependency_1

    Dim bCTLLanguage    as Boolean
  
    '/// Test listbox 'Text direction' -- insert/section
    PrintLog "- listbox 'Text direction' -- insert/section"
    
    '/// Open a new document
    Call hNewDocument
    
    '/// Set 'CTL Language support' ON
    bCTLLanguage = ActiveDeactivateCTLSupport(TRUE)
    
    '/// Insert/Section/Columns,
    '/// the listbox 'Text direction' should exist
    Call fInsertSection("TabSpalten")
    if Not TextDirection.IsVisible then
        Warnlog "Should get listbox 'Text direction'"
    end if
    TabSpalten.Cancel    
    
    '/// Set 'CTL Language support' Off
    Call ActiveDeactivateCTLSupport(FALSE)
    
    '/// Insert/Section/Columns,
    '/// the listbox 'Text direction' shouldn't exist
    Call fInsertSection("TabSpalten")
    if TextDirection.IsVisible then
        Warnlog "Shouldn't get listbox 'Text direction'"
    end if
    TabSpalten.Cancel
    
    '/// Set the 'CTL Language support' to default
    if bCTLLanguage = TRUE then
        Call ActiveDeactivateCTLSupport(TRUE)
    end if
    
    '/// Close active document
    Call hCloseDocument
    
endcase

'-------------------------------------------------------------------------------------------

testcase tCTLDependency_2

    Dim bCTLLanguage    as Boolean
    
    '/// Test listbox 'Text direction' -- format/section
    PrintLog "- listbox 'Text direction' -- format/section"
    
    '/// Open a new document
    Call hNewDocument
    
    '/// Insert a section
    Call fInsertSection("TabBereiche")
    TabBereiche.OK
    
    '/// Set 'CTL Language support' ON
    bCTLLanguage = ActiveDeactivateCTLSupport(TRUE)
    
    '/// Format/Section , then click option button,
    '/// the listbox 'Text direction' should exist
    FormatSections
    Kontext "BereicheBearbeiten"
    Optionen.Click
    Sleep 1
    Kontext
    Active.Setpage TabSpalten
    Kontext "TabSpalten"
    if Not TextDirection.IsVisible then
        Warnlog "Should get listbox 'Text direction'"
    end if
    TabSpalten.Cancel
    Sleep 1
    Kontext "BereicheBearbeiten"
    BereicheBearbeiten.Cancel
    
    '/// Set 'CTL Language support' Off
    Call ActiveDeactivateCTLSupport(FALSE)
    
    '/// Format/Section , then click option button,
    '/// the listbox 'Text direction' shouldn't exist
    FormatSections
    Kontext "BereicheBearbeiten"
    Optionen.Click
    Kontext
    Active.Setpage TabSpalten
    Kontext "TabSpalten"
    if TextDirection.IsVisible then
        Warnlog "Shouldn't get listbox 'Text direction'"
    end if
    TabSpalten.Cancel
    Sleep 1
    Kontext "BereicheBearbeiten"
    BereicheBearbeiten.Cancel
    
    '/// Set the 'CTL Language support' to default
    if bCTLLanguage = TRUE then
        Call ActiveDeactivateCTLSupport(TRUE)
    end if
    
    '/// Close active document
    Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tCTLDependency_3

    Dim bCTLLanguage    as Boolean
    '/// Test listbox 'Text direction' -- Table
    PrintLog "- listbox 'Text direction' -- Table"
    
    '/// Open a new document
    Call hNewDocument
    
    '/// Insert a table
    Call hTabelleEinfuegen
    
    '/// Set 'CTL Language support' ON
    bCTLLanguage = ActiveDeactivateCTLSupport(TRUE)
    
    '/// Format/Table / Table ,
    '/// the listbox 'Text direction' should exist
    Call fFormatTable("TabTabelle")
    if Not TextDirection.IsVisible then
        Warnlog "Should get listbox 'Text direction'"
    end if
    TabTabelle.Cancel
    
    '/// Set 'CTL Language support' Off
    Call ActiveDeactivateCTLSupport(FALSE)
    
    '/// Format/Table / Table ,
    '/// the listbox 'Text direction' shouldn't exist
    Call fFormatTable("TabTabelle")
    if TextDirection.IsVisible then
        Warnlog "Shouldn't get listbox 'Text direction'"
    end if
    TabTabelle.Cancel
    
    '/// Set the 'CTL Language support' to default
    if bCTLLanguage = TRUE then
        Call ActiveDeactivateCTLSupport(TRUE)
    end if
    
    '/// Close active document
    Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tCTLDependency_4

  Dim bCTLLanguage        as Boolean
  Dim bLToR   ,   bRToL   as Boolean

  '/// Test 'left to right' and 'right to left' button
  PrintLog "- 'left to right' and 'right to left' button "

  '/// Open a new document
  Call hNewDocument

   bLToR = fActiveObjectInToolbar("Text Object" , "Left-To-Right" , TRUE)
   bRToL = fActiveObjectInToolbar("Text Object" , "Right-To-Left" , TRUE)

  '/// Set 'CTL Language support' Off
   bCTLLanguage = ActiveDeactivateCTLSupport(FALSE)
   Sleep 2

  '/// Check if 'left to right' button and 'right to left' button
  '/// can be clicked in text tool bar -- Shouldn't be
   Kontext "TextObjectbar"
   try
       LeftToRight.Click
       warnlog "Left To Right button shouldn't be clicked!"
   catch
   endcatch
   try
       RightToLeft.Click
       warnlog "Right To Left button shouldn't be clicked!"
   catch
   endcatch

  '/// Set 'CTL Language support' ON
   ActiveDeactivateCTLSupport(TRUE)

  '/// Check if 'left to right' button and 'right to left' button
  '/// can be clicked in text tool bar -- Should be
   Kontext "TextObjectbar"
   Sleep 2
   try
       LeftToRight.Click
       Sleep 2
   catch
       warnlog "#i38788# Left To Right button can't be clicked!"
   endcatch
   try
       RightToLeft.Click
       Sleep 2
   catch
       warnlog "#i38788# Right To Left button can't be clicked!"
   endcatch

  'Set R to L and L to R button disappear
   if bLToR = FALSE then
       Call fActiveObjectInToolbar("Text Object" , "Left-To-Right" , FALSE)
   end if
   if bRToL = FALSE then
       Call fActiveObjectInToolbar("Text Object" , "Right-To-Left" , FALSE)
   end if

  '/// Set the 'CTL Language support' to default
   if bCTLLanguage = FALSE then
       Call ActiveDeactivateCTLSupport(FALSE)
   end if

  '/// Close active document
   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tCTLDependency_5

    Dim bCTLLanguage           as Boolean
    Dim bLToR   ,   bRToL      as Boolean
    Dim iHtmlExportMode        as Integer
    Dim iCurrentHtmlExportMode as Integer
    
    iHtmlExportMode = 1
    
    '/// Test 'left to right' and 'right to left' button - HTML(HTML 3.2)
    PrintLog "- 'left to right' and 'right to left' button - HTML (HTML 3.2)"
    
    '/// Open a new document
    Call hNewDocument
    
    bLToR = fActiveObjectInToolbar("Text Object" , "Left-To-Right" , TRUE)
    bRToL = fActiveObjectInToolbar("Text Object" , "Right-To-Left" , TRUE)
    
    '/// Set Export mode to HTML 3.2
    '/// Tools/load&save/HTML compatibility/Exprt
    ToolsOptions
    Call hToolsOptions ( "LoadSave", "HTMLCompatibility" )
    iCurrentHtmlExportMode = Export.GetSelIndex
    Sleep 1
    Export.Select iHtmlExportMode
    Sleep 1
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    
    PrintLog "Set 'CTL Language support' Off"
    '/// Set 'CTL Language support' Off
    bCTLLanguage = ActiveDeactivateCTLSupport(FALSE)
    Sleep 2
    
    '/// Check if 'left to right' button and 'right to left' button
    '/// can be clicked in text tool bar -- Shouldn't be
    Kontext "TextObjectbar"
    try
        LeftToRight.Click
        warnlog "Left To Right button shouldn't be clicked!"
    catch
    endcatch
    try
        RightToLeft.Click
        warnlog "Right To Left button shouldn't be clicked!"
    catch
    endcatch
    
    PrintLog "Set 'CTL Language support' ON"
    '/// Set 'CTL Language support' ON
    ActiveDeactivateCTLSupport(TRUE)
    
    '/// Check if 'left to right' button and 'right to left' button
    '/// can be clicked in text tool bar -- Should NOT be
    Kontext "TextObjectbar"
    Sleep 2
    try
       LeftToRight.Click
       QAErrorLog "#115836# Left To Right button shouldn't be clicked!"
       Sleep 2
    catch
    endcatch
    try
       RightToLeft.Click
       QAErrorLog "#115836# Right To Left button shouldn't be clicked!"
       Sleep 2
    catch
    endcatch
    
    'Set R to L and L to R button disappear
    if bLToR = FALSE then
       Call fActiveObjectInToolbar("Text Object" , "Left-To-Right" , FALSE)
    end if
    if bRToL = FALSE then
       Call fActiveObjectInToolbar("Text Object" , "Right-To-Left" , FALSE)
    end if
    
    '/// Set the 'CTL Language support' to default
    if bCTLLanguage = FALSE then
       Call ActiveDeactivateCTLSupport(FALSE)
    end if
    
    '/// Set Export mode to default
    ToolsOptions
    Call hToolsOptions ( "LoadSave", "HTMLCompatibility" )
     Export.Select iCurrentHtmlExportMode
     Sleep 1
     Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    
    '/// Close active document
    Call hCloseDocument
    
endcase

'-------------------------------------------------------------------------------------------

testcase tCTLDependency_6

  Dim bCTLLanguage           as Boolean
  Dim bLToR   ,   bRToL      as Boolean
  Dim iHtmlExportMode        as Integer
  Dim iCurrentHtmlExportMode as Integer

  iHtmlExportMode = 2

  '/// Test 'left to right' and 'right to left' button - HTML(Microsoft Internet Bxplorer)
  PrintLog "- 'left to right' and 'right to left' button - HTML(Microsoft Internet Bxplorer)"

  '/// Open a new document
  Call hNewDocument

   bLToR = fActiveObjectInToolbar("Text Object" , "Left-To-Right" , TRUE)
   bRToL = fActiveObjectInToolbar("Text Object" , "Right-To-Left" , TRUE)

  '/// Set Export mode to Microsoft Internet Bxplorer
  '/// Tools/load&save/HTML compatibility/Exprt
   ToolsOptions
   Call hToolsOptions ( "LoadSave", "HTMLCompatibility" )
     iCurrentHtmlExportMode = Export.GetSelIndex
     Export.Select iHtmlExportMode
     Sleep 1
     Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK

  '/// Set 'CTL Language support' Off
   bCTLLanguage = ActiveDeactivateCTLSupport(FALSE)
   Sleep 2

  '/// Check if 'left to right' button and 'right to left' button
  '/// can be clicked in text tool bar -- Shouldn't be
   Kontext "TextObjectbar"
   try
       LeftToRight.Click
       warnlog "Left To Right button shouldn't be clicked!"
   catch
   endcatch
   try
       RightToLeft.Click
       warnlog "Right To Left button shouldn't be clicked!"
   catch
   endcatch

  '/// Set 'CTL Language support' ON
   ActiveDeactivateCTLSupport(TRUE)

  '/// Check if 'left to right' button and 'right to left' button
  '/// can be clicked in text tool bar -- Should be
   Kontext "TextObjectbar"
   Sleep 2
   try
       LeftToRight.Click
       Sleep 2
   catch
       warnlog "#i38788# Left To Right button can't be clicked!"
   endcatch
   try
       RightToLeft.Click
       Sleep 2
   catch
       warnlog "#i38788# Right To Left button can't be clicked!"
   endcatch

  'Set R to L and L to R button disappear
   if bLToR = FALSE then
       Call fActiveObjectInToolbar("Text Object" , "Left-To-Right" , FALSE)
   end if
   if bRToL = FALSE then
       Call fActiveObjectInToolbar("Text Object" , "Right-To-Left" , FALSE)
   end if

  '/// Set the 'CTL Language support' to default
   if bCTLLanguage = FALSE then
       Call ActiveDeactivateCTLSupport(FALSE)
   end if

  '/// Set Export mode to default
   ToolsOptions
   Call hToolsOptions ( "LoadSave", "HTMLCompatibility" )
     Export.Select iCurrentHtmlExportMode
     Sleep 1
     Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK

  '/// Close active document
   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tCTLDependency_7

  Dim bCTLLanguage           as Boolean
  Dim bLToR   ,   bRToL      as Boolean
  Dim iHtmlExportMode        as Integer
  Dim iCurrentHtmlExportMode as Integer

  iHtmlExportMode = 3

  '/// Test 'left to right' and 'right to left' button - HTML(Netscape Navigator)
  PrintLog "- 'left to right' and 'right to left' button - HTML(Netscape Navigator)"

  '/// Open a new document
  Call hNewDocument

   bLToR = fActiveObjectInToolbar("Text Object" , "Left-To-Right" , TRUE)
   bRToL = fActiveObjectInToolbar("Text Object" , "Right-To-Left" , TRUE)

  '/// Set Export mode to Netscape Navigator
  '/// Tools/load&save/HTML compatibility/Exprt
   ToolsOptions
   Call hToolsOptions ( "LoadSave", "HTMLCompatibility" )
     iCurrentHtmlExportMode = Export.GetSelIndex
     Export.Select iHtmlExportMode
     Sleep 1
     Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK

  '/// Set 'CTL Language support' Off
   bCTLLanguage = ActiveDeactivateCTLSupport(FALSE)
   Sleep 2

  '/// Check if 'left to right' button and 'right to left' button
  '/// can be clicked in text tool bar -- Shouldn't be
   Kontext "TextObjectbar"
   try
       LeftToRight.Click
       warnlog "Left To Right button shouldn't be clicked!"
   catch
   endcatch
   try
       RightToLeft.Click
       warnlog "Right To Left button shouldn't be clicked!"
   catch
   endcatch

  '/// Set 'CTL Language support' ON
   ActiveDeactivateCTLSupport(TRUE)

  '/// Check if 'left to right' button and 'right to left' button
  '/// can be clicked in text tool bar -- Should be
   Kontext "TextObjectbar"
   Sleep 2
   try
       LeftToRight.Click
       Sleep 2
   catch
       warnlog "#i38788# Left To Right button can't be clicked!"
   endcatch
   try
       RightToLeft.Click
       Sleep 2
   catch
       warnlog "#i38788# Right To Left button can't be clicked!"
   endcatch

  'Set R to L and L to R button disappear
   if bLToR = FALSE then
       Call fActiveObjectInToolbar("Text Object" , "Left-To-Right" , FALSE)
   end if
   if bRToL = FALSE then
       Call fActiveObjectInToolbar("Text Object" , "Right-To-Left" , FALSE)
   end if

  '/// Set the 'CTL Language support' to default
   if bCTLLanguage = FALSE then
       Call ActiveDeactivateCTLSupport(FALSE)
   end if

  '/// Set Export mode to default
   ToolsOptions
   Call hToolsOptions ( "LoadSave", "HTMLCompatibility" )
     Export.Select iCurrentHtmlExportMode
     Sleep 1
     Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK

  '/// Close active document
   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tCTLDependency_8

  Dim bCTLLanguage           as Boolean
  Dim bLToR   ,   bRToL      as Boolean
  Dim iHtmlExportMode        as Integer
  Dim iCurrentHtmlExportMode as Integer

  iHtmlExportMode = 4

  '/// Test 'left to right' and 'right to left' button - HTML(StarOffice Writer)
  PrintLog "- 'left to right' and 'right to left' button - HTML(StarOffice Writer)"

  '/// Open a new document
  Call hNewDocument

   bLToR = fActiveObjectInToolbar("Text Object" , "Left-To-Right" , TRUE)
   bRToL = fActiveObjectInToolbar("Text Object" , "Right-To-Left" , TRUE)

  '/// Set Export mode to StarOffice Writer
  '/// Tools/load&save/HTML compatibility/Exprt
   ToolsOptions
   Call hToolsOptions ( "LoadSave", "HTMLCompatibility" )
     iCurrentHtmlExportMode = Export.GetSelIndex
     Export.Select iHtmlExportMode
     Sleep 1
     Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK

  '/// Set 'CTL Language support' Off
   bCTLLanguage = ActiveDeactivateCTLSupport(FALSE)
   Sleep 2

  '/// Check if 'left to right' button and 'right to left' button
  '/// can be clicked in text tool bar -- Shouldn't be
   Kontext "TextObjectbar"
   try
       LeftToRight.Click
       warnlog "Left To Right button shouldn't be clicked!"
   catch
   endcatch
   try
       RightToLeft.Click
       warnlog "Right To Left button shouldn't be clicked!"
   catch
   endcatch

  '/// Set 'CTL Language support' ON
   ActiveDeactivateCTLSupport(TRUE)

  '/// Check if 'left to right' button and 'right to left' button
  '/// can be clicked in text tool bar -- Should be
   Kontext "TextObjectbar"
   Sleep 2
   try
       LeftToRight.Click
       Sleep 2
   catch
       warnlog "#i38788# Left To Right button can't be clicked!"
   endcatch
   try
       RightToLeft.Click
       Sleep 2
   catch
       warnlog "#i38788# Right To Left button can't be clicked!"
   endcatch

  'Set R to L and L to R button disappear
   if bLToR = FALSE then
       Call fActiveObjectInToolbar("Text Object" , "Left-To-Right" , FALSE)
   end if
   if bRToL = FALSE then
       Call fActiveObjectInToolbar("Text Object" , "Right-To-Left" , FALSE)
   end if

  '/// Set the 'CTL Language support' to default
   if bCTLLanguage = FALSE then
       Call ActiveDeactivateCTLSupport(FALSE)
   end if

  '/// Set Export mode to default
   ToolsOptions
   Call hToolsOptions ( "LoadSave", "HTMLCompatibility" )
     Export.Select iCurrentHtmlExportMode
     Sleep 1
     Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK

  '/// Close active document
   Call hCloseDocument

endcase


