'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: install_i18n_tools.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:08:26 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : read and preprocess i18n-data
'*
'*******************************************************************************
' **
' #0 hGetInstalledLanguages         ' get a list of installed languages
' #0 hGetI18NData                   ' retrieve language dependent data from configfile
' #0 hGetSupportedLanguagesAsInt    ' reads the file 'languages.dat'
' **
'\******************************************************************************


function hGetInstalledLanguages( cInstLang() as string ) as integer


    ' this function returns a list of installed languages. Format of the list:
    ' - ready for listfunctions (listappend, listdelete etc.)
    ' - the list is formatted as two digit numbers "01", "33" etc.
    ' the installed languages-list is retrieved from the configuration by getting
    ' the directory names below share/registry/res
    ' The supported lanuages are listed in the file "languages.dat", if a
    ' language is missing, you will get "No matching value found for KEY" errors

    const CFN = "hGetInstalledLanguages::"

    dim cI18NDirPath as string
    cI18NDirPath = convertpath( gNetzOfficePath & "share\registry\res" )

    dim iLanguageCount as integer
    dim iCurrentItem as integer

    printlog( "" )
    printlog( " * Trying to determine installed languages: " & cI18NDirPath )
    printlog( "" )

    ' read the directories from cI18NDirPath -> installed languages
    iLanguageCount = GetDirList( cI18NDirPath , "*" , cInstLang() )

    listprint( cInstLang() , "" )

    ' isolate the language-string from the absolute path
    hIsolateI18NString( cI18NDirPath , cInstLang() )

    listprint( cInstLang() , "" )

    ' convert the language-string to numeric string (e.g. "en-US" -> "01" )
    hTransformI18NString( cInstLang() )

    'listprint( cInstLang() , "" )

    ' return the number of installed languages.
    hGetInstalledLanguages() = iLanguageCount


end function

'*******************************************************************************

function hGetI18NData( sLang as string , sKey as string ) as string


    ' this function reads the i18n-files from the input directory.
    ' it provides the required data-list for hGetValueForKeyAsString
    ' from one i18n_-file.

    dim sFile as string             ' i18n-file
    dim lsLangData( 100 ) as string ' the content of the i18n-file as list
    dim sTempString as string       ' the returnvalue (raw)

    ' Create the path to the i18n-file
    sFile = TESTHOME & "\i18n_" & sLang & ".dat"
    sFile = convertpath( sFile )

    ' Check if the file exist and read it.

    if( dir( sFile ) <> "" ) then
        hGetDataFileSection( sFile , lsLangData() , "system" , "" , "" )
        hGetI18NData() = hGetValueForKeyAsString( lsLangData() , sKey )
    else
        warnlog( "hGetI18NData: File is missing: " & sFile )
        hGetI18NData() = ""
    endif


end function

'*******************************************************************************

function hGetSupportedLanguagesAsInt( cLanguageList() as string ) as integer


    ' This function returns the count of supported languages and fills the list
    ' with language-data "01=en", "33=fr" ... The data is retrieved from
    ' languages.dat

    dim cFile as string
    cFile = convertpath( TESTHOME & "\languages.dat" )

    hGetDataFileSection( cFile , cLanguageList() , "system" , "" , "" )

    hGetSupportedLanguagesAsInt() = listcount( cLanguageList() )


end function

'*******************************************************************************

function hIsolateI18NString( cBasePath as string, cList() as string ) as integer


    ' this function isolates the tiny substring that identifies a localized
    ' directory. The string has the format "en-US" or "de". The substrings are
    ' written to the array replacing the original entries. Trailing slashes
    ' and backslashes are truncated.
    dim iItem as integer
    dim iTokenBefore as integer
    dim iTokenLength as integer

    ' the first character after the pathseparator of basepath
    iTokenBefore = len( cBasePath ) + 1

    ' run through the list and convert all paths to language-strings

    for iItem = 1 to listcount( cList() )

        iTokenLength = len( cList( iItem ) ) - iTokenBefore
        cList( iItem ) =  mid( cList( iItem ) , iTokenBefore , iTokenLength )

    next iItem


end function

'*******************************************************************************

function hTransformI18NString( cList() as string )


    ' this function transforms the strings (=directory names) to their numeric
    ' equivalents, e.g. pt-BR -> 55. This is done for the entire cList() which
    ' is overwritten in the process.

    dim cLangList( 300 ) as string
    dim cFile as string
    dim iItem as integer

    cFile = gTesttoolpath & "framework\install\input\languages.dat"
    cFile = convertpath( cFile )

    hGetDatafileSection( cFile , cLangList() , "system" , "Test" , "print" )


    for iItem = 1 to listcount( cList() )

        cList( iItem ) = hGetKeyForValueAsString( cLangList() , cList( iItem ) )

    next iItem


end function

'*******************************************************************************


