'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_passwords.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:04:23 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : save and load passworded files
'*
'*******************************************************************************
'**
' #1 tFiledlgPasswords ' save and load passworded files
'**
'\******************************************************************************

testcase tFiledlgPasswords( filetypeID as string )

    '///<h1>Test saving/loading passworded files in three different formats</h1>

    dim workfile as string
        workfile = "password" & hGetSuffix( filetypeID )
        printlog( " * Name of workfile: " & workfile )

    dim workpath as string
        workpath = convertpath( gOfficePath & "user\work\" )
        printlog( " * Save file to....: " & workpath )

    dim filetype as string
        filetype = hGetFilter( filetypeID )
        printlog( " * Using fileformat: " & filetype )

    '///<ul>
    '///<li>open a new document</li>
    printlog( " - open a new document" )
    call hNewDocument()

    '///<li>enter some random text</li>
    printlog( " - enter some text" )
    call hChangeDoc()

    '///<li>open file-save dialog</li>
    printlog( " - open file-save dialog" )
    if ( gApplication = "IMPRESS" ) then
        printlog( "   IMPRESS is slower than other apps, delaying for 2 sec." )
        sleep( 2 )
    endif
    FileSave
    sleep( 2 )

    Kontext "SpeichernDlg"
    '///<li>uncheck automatic extension</li>
    printlog( " - uncheck automatic extension" )
    AutomatischeDateinamensErweiterung.uncheck()

    '///<li>name the file and select filter</li>
    printlog( " - name the file and select filter" )
    Dateiname.settext( workpath & workfile )
    try
        Dateityp.select( filetype )
    catch
        warnlog( "#i48165# - incorrect filternames in localized versions" )
        printlog( "Defaulting filetype" )
    endcatch

    '///<li>check password</li>
    printlog( " - check password" )
    if ( passwort.isenabled() ) then
        Passwort.check()
    else
        warnlog( "#i36663# Password checkbox is disabled" )
    endif

    '///<li>save the file</li>
    printlog( " - save the file" )
    Speichern.click()
    sleep( 2 )

    kontext "active"
    if ( active.exists() ) then
       printlog( " - handle overwrite warning (if any)" )
       active.yes()
       sleep( 1 )
    endif
    

    Kontext "PasswordDlg"
    '///<li>enter the filename as password and confirm</li>
    printlog( " - enter the name of the file as password and confirm" )
    if ( passwordDlg.exists() ) then
        Password.settext( workfile )
        PasswordConfirm.settext( workfile )
        sleep( 1 )
        PasswordDlg.ok()
    else
        warnlog( "No password dialog is displayed" )
    endif
    sleep( 2 )
    
    kontext "AlienWarning"
    if ( AlienWarning.exists() ) then
        if ( FileTypeID <> "current" ) then
            printlog( " - handle alienwarning (expected)" )
            AlienWarning.ok()
            sleep( 2 )
         else
            warnlog( " - handle alienwarning (unexpected)" )
            AlienWarning.ok()
            sleep( 2 )
         endif         
    endif    

    '///<li>close the document</li>
    printlog( " - close the document" )
    call hCloseDocument()

    '///<li>open the file via file-open</li>
    printlog( " - open the file via file-open" )
    FileOpen
    sleep( 2 )

    Kontext "OeffnenDlg"
    Dateiname.settext( workfile )

    Oeffnen.click()
    sleep( 4 )

    Kontext "PasswordFileOpen"
    '///<li>enter the filename as password</li>
    printlog( " - enter the filename as password" )
    if ( PasswordFileOpen.exists() ) then
        PasswortName.settext( workfile )
        sleep( 1 )
        PasswordFileOpen.ok()
        sleep( 1 )
    else
        warnlog( "No password dialog is displayed" )
    endif

    '///<li>verify that the document is loaded</li>
    printlog( " - verify that the document is loaded" )
    call IsItLoaded()

    '///<li>close the document</li>
    printlog( " - close the document" )
    call hCloseDocument()

    '///</ul>
    
    printlog( " - delete the file" )
    if ( kill ( workpath & workfile ) = 0 ) then
       printlog( " - file successfully deleted" )
    else
       qaerrorlog( "The file could not be deleted. Please do so manually." )
    endif

endcase
