'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: tools.inc,v $
'*
'*  $Revision: 1.13 $
'*
'*  last change: $Author: jsi $ $Date: 2006/01/19 08:56:01 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : Tools for Keyboard Accessibility
'*
'************************************************************************
'*
' #1 fDrawObjects
' #1 fChooseDrawObjects
' #1 fPositionAndSize
' #1 fMenuSelectNr
' #1 fTestPosition
' #1 fCalculateTolerance
' #1 fDataPilotRowSelection
' #1 fDataPilotColumnSelection
' #1 fDataPilotDataSelection
' #1 fDataPilotPageSelection
'*
'\***********************************************************************

function fDrawObjects ( Object, xStart%, yStart%, xEnd%, yEnd% )
'///This function will draw some objects in Calc
 '///+ After drawing , you need to re-set the focus

   Call hToolbarSelect("DRAWING", true)

   Object = UCase( Object )
   select case Object
      case "RECHTECK" : Rechteck.Click
      case "LINIE"    : Linie.Click
      case "ELLIPSE"  : Ellipse.Click
      case "TEXT"     : Textobjekt.Click
      case "VTEXT"    :
        try
          VerticalText.Click
        catch
          Warnlog "Unable to insert Vertical Text! Asian Support in Options activated ?"
        endcatch
      case "LAUFTEXT" : Lauftext.Click
      case "LEGENDE"  : Legende.Click
      case "VLEGENDE" :
        try
          VerticalCallout.Click
        catch
          Warnlog "Unable to insert Vertical Callout! Asian Support in Options activated ?"
        endcatch
   end select

   Kontext "DocumentCalc"
   call gMouseMove (xStart%, yStart%, xEnd%, yEnd%)
   Sleep 2

   Kontext "Drawbar"
   Drawbar.Close
   if Object <> "TEXT" then
       Kontext "DocumentCalc"
          DocumentCalc.MouseDown 40, 10
          sleep 3
          DocumentCalc.MouseUp   40, 10
          sleep 3
   end if

end function

'-------------------------------------------------------------------------

function fChooseDrawObjects ( Object as String)
'/// This function will choose a draw object, after its execution,
'///+ Zeichnen will display the relative object map in the left bar

   Call hToolbarSelect("DRAWING", true)

   Object = UCase( Object )
   select case Object
      case "LINIE"          : Linie.Click              'line
      case "RECHTECK"       : Rechteck.Click           'rectangle
      case "ELLIPSE"        : Ellipse.Click            'ellipse
      case "TEXT"           : Textobjekt.Click         'textobject
      case "LEGENDE"        : Legende.Click            'callouts
      case "LAUFTEXT"       : Lauftext.Click           'text animation
      case "KREISBOGEN"     : Kreisbogen.Click         'arc
      case "KREISSEGMENT"   : Kreissegment.Click       'circle segment
      case "KREISSEKTOR"    : Kreissektor.Click        'ellipse pie
      case "POLYGON"        : Polygon.Click            'polygon
      case "BEZIER"         : Bezier.Click             'curve
      case "FREIHAND"       : Freihand.Click           'freeform line
      case "AUSWAHL"        : Auswahl.Click            'Arrow
   end select

   Drawbar.Close

end function

'-------------------------------------------------------------------------

function fPositionAndSize(Options as string)
'/// Open Format/Position and Size diglog with Options
  sleep(2)
  Kontext
  FormatPositionAndSize
  sleep(2)

  Select case Options
    case "TabPositionAndSize"     : active.SetPage TabPositionAndSize
    case "TabDrehung"             : active.SetPage TabDrehung
    case "TabSchraegstellen"      : active.SetPage TabSchraegstellen
  end Select

  Kontext Options

end function

'-------------------------------------------------------------------------

function fMenuSelectNr ( EintragsNr as Integer ) as String
'/// Open context sub-menu
 Dim i, j, RealEnd, Ende, nID as Integer
   Sleep 2

   Ende = EintragsNr
   RealEnd = MenuGetItemCount
   if Ende > RealEnd then
      Warnlog "hMenuSelectNr canceled: Entry number "+ Ende +" does not exists, because there are only " + RealEnd + "  entries! "
      hMenuClose
      exit function
   end if
   j=0
   for i=1 to Ende
      if MenuIsSeperator ( i+j ) then j = j+1
   next i
   nID = MenuGetItemID ( EintragsNr+j )
   fMenuSelectNr = MenuGetItemText ( nID )
   MenuSelect ( nID )
end function

'-------------------------------------------------------------------------

function fTestPosition( sPositionX , sPositionY , sWidth , sHeight )
'/// Check the A point's position and recover to default
    Call fPositionAndSize("TabPositionAndSize")
     if fCalculateTolerance(PositionX.Gettext , sPositionX) > 0.03 then Warnlog "Position X is wrong, should be " + sPositionX + " but get " + PositionX.Gettext
     if fCalculateTolerance(PositionY.Gettext , sPositionY) > 0.03 then Warnlog "Position Y is wrong, should be " + sPositionY + " but get " + PositionY.Gettext
     if fCalculateTolerance(Width.Gettext     , sWidth)     > 0.03 then Warnlog "Width is wrong, should be " + sWidth + " but get " + Width.Gettext
     if fCalculateTolerance(Width.Gettext     , sWidth)     > 0.03 then Warnlog "Height is wrong, should be " + sHeight + " but get " + Height.Gettext

     sPositionX  = "4" + gSeperator + "00" + gMeasurementUnit
     sPositionY  = "2" + gSeperator + "00" + gMeasurementUnit
     sWidth      = "10"+ gSeperator + "00" + gMeasurementUnit
     sHeight     = "8" + gSeperator + "00" + gMeasurementUnit

     PositionX.Settext sPositionX
     PositionY.Settext sPositionY
     Width.Settext     sWidth
     Height.Settext    sHeight

    TabPositionAndSize.OK
end function

'-------------------------------------------------------------------------

function fCalculateTolerance( sNumber1 , sNumber2 )
'/// change 2 parameters to number , then Compare them and return the result.

   Dim dNumber1        , dNumber2         as Single
   Dim iCommaLocation1 , iCommaLocation2  as Integer

  'the code below 4 lines is set "2,00cm" to "2.00"cm if needed
   iCommaLocation1 = InStr(sNumber1 , ",")
   if iCommaLocation1 > 0 then
      sNumber1 = Left(sNumber1 , iCommaLocation1-1) + "." + Right(sNumber1,Len(sNumber1) - iCommaLocation1)
   end if

   iCommaLocation2 = InStr(sNumber2 , ",")
   if iCommaLocation2 > 0 then
      sNumber2 = Left(sNumber2 , iCommaLocation2-1) + "." + Right(sNumber2,Len(sNumber2) - iCommaLocation2)
   end if

   dNumber1 = Val( Left(sNumber1, Len(sNumber1)-Len(gMeasurementUnit) ))
   dNumber2 = Val( Left(sNumber2, Len(sNumber2)-Len(gMeasurementUnit) ))
  fCalculateTolerance = Abs( dNumber1 - dNumber2 )

end function

'--------------------------------------------------------------------------

function fDataPilotRowSelection()

   select case iSprache
      case 01   :        ' English (USA)
         DataPilotSelection.typekeys "<MOD2 R>"
      case 33   :        ' French
         DataPilotSelection.typekeys "<MOD2 g>"
      case 34   :        ' Spanish
         DataPilotSelection.typekeys "<MOD2 p>"
      case 39   :        ' Italian
         DataPilotSelection.typekeys "<MOD2 R>"
      case 46   :        ' Swedish
         DataPilotSelection.typekeys "<MOD2 l>"
      case 49   :        ' German
         DataPilotSelection.typekeys "<MOD2 l>"
      case 55   :        ' Portuguese
         DataPilotSelection.typekeys "<MOD2 h>"
      case 81   :        ' Japanese
         DataPilotSelection.typekeys "<MOD2 B>"
      case 82   :        ' Korean
         DataPilotSelection.typekeys "<MOD2 B>"
      case 86   :        ' Chinese (simplified)
         DataPilotSelection.typekeys "<MOD2 B>"
      case 88   :        ' Chinese (traditional)
         DataPilotSelection.typekeys "<MOD2 B>"
      case else :        ' Fallback
         QAErrorLog "Now, the test does not support for the language " +iSprache
   end select

end function

'----------------------------------------------------

function fDataPilotColumnSelection()

   select case iSprache
      case 01   :        ' English (USA)
         DataPilotSelection.typekeys "<MOD2 C>"
      case 33   :        ' French
         DataPilotSelection.typekeys "<MOD2 d>"
      case 34   :        ' Spanish
         DataPilotSelection.typekeys "<MOD2 m>"
      case 39   :        ' Italian
         DataPilotSelection.typekeys "<MOD2 m>"
      case 46   :        ' Swedish
         DataPilotSelection.typekeys "<MOD2 m>"
      case 49   :        ' German
         DataPilotSelection.typekeys "<MOD2 S>"
      case 55   :        ' Portuguese
         DataPilotSelection.typekeys "<MOD2 d>"
      case 81   :        ' Japanese
         DataPilotSelection.typekeys "<MOD2 A>"
      case 82   :        ' Korean
         DataPilotSelection.typekeys "<MOD2 A>"
      case 86   :        ' Chinese (simplified)
         DataPilotSelection.typekeys "<MOD2 A>"
      case 88   :        ' Chinese (traditional)
         DataPilotSelection.typekeys "<MOD2 A>"
      case else :        ' Fallback
         QAErrorLog "Now, the test does not support for the language " +iSprache
   end select
   Sleep 2

end function

'----------------------------------------------------

function fDataPilotDataSelection()

   select case iSprache
      case 01   :        ' English (USA)
         DataPilotSelection.typekeys "<MOD2 D>"
      case 33   :        ' French
         DataPilotSelection.typekeys "<MOD2 h>"
      case 34   :        ' Spanish
         DataPilotSelection.typekeys "<MOD2 t>"
      case 39   :        ' Italian
         DataPilotSelection.typekeys "<MOD2 d>"
      case 46   :        ' Swedish
         DataPilotSelection.typekeys "<MOD2 t>"
      case 49   :        ' German
         DataPilotSelection.typekeys "<MOD2 D>"
      case 55   :        ' Portuguese
         DataPilotSelection.typekeys "<MOD2 p>"
      case 81   :        ' Japanese
         DataPilotSelection.typekeys "<MOD2 C>"
      case 82   :        ' Korean
         DataPilotSelection.typekeys "<MOD2 C>"
      case 86   :        ' Chinese (simplified)
         DataPilotSelection.typekeys "<MOD2 C>"
      case 88   :        ' Chinese (traditional)
         DataPilotSelection.typekeys "<MOD2 C>"
      case else :        ' Fallback
         QAErrorLog "Now, the test does not support for the language " +iSprache
   end select
   Sleep 2

end function

'----------------------------------------------------

function fDataPilotPageSelection()

   select case iSprache
      case 01   :        ' English (USA)
         DataPilotSelection.typekeys "<MOD2 P>"
      case 33   :        ' French
         DataPilotSelection.typekeys "<MOD2 C>"
      case 34   :        ' Spanish
         DataPilotSelection.typekeys "<MOD2 C>"
      case 39   :        ' Italian
         DataPilotSelection.typekeys "<MOD2 C>"
      case 46   :        ' Swedish
         DataPilotSelection.typekeys "<MOD2 S>"
      case 49   :        ' German
         DataPilotSelection.typekeys "<MOD2 S>"
      case 55   :        ' Portuguese
         DataPilotSelection.typekeys "<MOD2 C>"
      case 81   :        ' Japanese
         DataPilotSelection.typekeys "<MOD2 P>"
      case 82   :        ' Korean
         DataPilotSelection.typekeys "<MOD2 P>"
      case 86   :        ' Chinese (simplified)
         DataPilotSelection.typekeys "<MOD2 P>"
      case 88   :        ' Chinese (traditional)
         DataPilotSelection.typekeys "<MOD2 P>"
      case else :        ' Fallback
         QAErrorLog "Now, the test does not support for the language " +iSprache
   end select
   Sleep 2

end function


