'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: coption2.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:15 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description : Check Tools->Options->Spreadsheet->View
'*
'************************************************************************
'*
' #1 cOption2                        ' Initial Routine
' #1 tOptionsContent_save            ' Check all View Options and change them
' #1 tOptionsContent_reload          ' Check if changes persist after exit and restart the office
' #1 tOptionsContentRestore_settings ' Restore default settings
'*
'\***********************************************************************

Global flag_Grids as integer, curr_Grids as integer, flag_Page as integer, curr_Page as integer, flag_Guides, curr_Guides as integer
Global flag_Simple as integer, curr_Simple as integer, flag_Large as integer, curr_Large as integer, flag_ColRow as integer, curr_ColRow as integer
Global flag_HScroll as integer, curr_HScroll as integer, flag_VScroll as integer, curr_VScroll as integer, flag_Sheet as integer, curr_Sheet as integer, flag_Out as integer, curr_Out as integer
Global stat_Color as integer, curr_Color as integer, stat_Unit, curr_Unit, more_Tab as integer
Global curr_Tab as string, stat_Tab as string, solve_Tab as string
Global flag_Form as integer, curr_Form as integer, flag_Val as integer, curr_Val as integer
Global flag_Note as integer, curr_Note as integer, flag_ValHigh as integer, curr_ValHigh as integer
Global flag_Anch as integer, curr_Anch as integer, flag_Text as integer, curr_Text as integer
Global flag_ShowRef as integer, curr_ShowRef as integer
Global stat_Obj as integer, curr_Obj as integer
Global stat_Chart as integer, curr_Chart as integer
Global stat_Draw as integer, curr_Draw as integer



sub cOption2

        printLog Chr(13) + "--------- cOption2 ---------"
        printlog "Tools|Options|Spreadsheet|View"

        call tOptionsContent_save
        call tOptionsContent_reload
        call tOptionsContentRestore_settings


end sub

'*********************************************************************************************************

testcase tOptionsContent_save
'/// This test invokes the "Tools|Options|Spreadsheet|View" dialog and checks the default settings ///'
'/// If the default settings are not as expected the tester will be warned about each incorrect item///'
'/// Then each item is modified and then the dialog is closed with OK ///'
'/// After restarting the office it will be checked if new settings are persistent ///'
'/// Finally the default settings are restored. ///'
'/// Due to all changed options have only visible impact, there's no automatic test of functionality///'.

        ' Initialize the variables
        flag_Grids = 0 : curr_Grids = 0
        flag_Page = 0 : curr_Page = 0
        flag_Guides = 0 : curr_Guides = 0
        flag_Simple = 0 : curr_Simple = 0
        flag_Large = 0 : curr_Large = 0
        flag_ColRow = 0 : curr_ColRow = 0
        flag_HScroll = 0 : curr_HScroll = 0
        flag_VScroll = 0 : curr_VScroll = 0
        flag_Sheet = 0 : curr_Sheet = 0
        flag_Out = 0 : curr_Out = 0
        stat_Color = 5
        flag_Form = 0 : curr_Form = 0
        flag_Val = 0 : curr_Val = 0
        flag_Note = 0 : curr_Note = 0
        flag_ValHigh = 0 : curr_ValHigh = 0
        flag_Anch = 0 : curr_Anch = 0
        flag_ShowRef = 0 : curr_ShowRef = 0
        stat_Obj = 0 : curr_Obj = 0
        stat_Chart = 0 : curr_Chart = 0
        stat_Draw = 0 : curr_Draw = 0

        Call hNewDocument

        ' Modify all parameters in this tabpage
        ToolsOptions
        hToolsOptions("SPREADSHEET", "VIEW")

    ' Grids and Color
    if Gitterlinien.ischecked then
        curr_Grids = 1
        if NOT Farbe.isenabled then
                warnlog "Color is disabled although Grids are checked"
        else
                curr_Color = Farbe.GetSelIndex
                ' printlog "Color Index is " & curr_Color
                Farbe.Select stat_Color
        end if
        Gitterlinien.uncheck
        else
                curr_Grids = 0
                warnlog "<display grids> is not checked by default"
                if Farbe.isenabled then
                warnlog "... and <color> is enabled although <display grids> is disabled"
        end if
                Gitterlinien.check
                if NOT Farbe.isenabled then
                warnlog "<color> is not enabled although <display grids> is enabled"
        else
                curr_Color = Farbe.GetSelIndex
                printlog "Color Index is " & curr_Color
                Farbe.Select stat_Color
        end if
        end if
        flag_Grids = Gitterlinien.GetState

        ' Page breaks
    if Seitenumbruch.ischecked then
        curr_Page = 1
        Seitenumbruch.uncheck
        else
                curr_Page = 0
                warnlog "<display pagebreak> is not enabled by default"
                Seitenumbruch.check
        end if
        flag_Page = Seitenumbruch.GetState

        ' Guides
        if Hilfslinien.ischecked then
        curr_Guides = 1
        Hilfslinien.uncheck
        warnlog "<display guides> are enabled by default"
        else
                curr_Guides = 0
                Hilfslinien.check
        end if
        flag_Guides = Hilfslinien.GetState

        ' Simple Handles
        if EinfacheGriffe.ischecked then
        curr_Simple = 1
        warnlog "<display simple handles> is checked by default"
        EinfacheGriffe.uncheck
        else
                curr_Simple = 0
                EinfacheGriffe.check
        end if
        flag_Simple = EinfacheGriffe.GetState

        ' Large Handles
        if GrosseGriffe.ischecked then
        curr_Large = 1
        warnlog "<display large handles> is checked by default"
        GrosseGriffe.uncheck
        else
                curr_Large = 0
                GrosseGriffe.check
        end if
        flag_Large = GrosseGriffe.GetState

        ' Column/Row headers
        if ZeilenUndSpaltenkoepfe.ischecked then
        curr_ColRow = 1
        ZeilenUndSpaltenkoepfe.uncheck
        else
                curr_ColRow = 0
                warnlog "<display column/row headers> is not checked by default"
                ZeilenUndSpaltenkoepfe.check
        end if
    flag_ColRow = ZeilenUndSpaltenkoepfe.GetState

        ' Horizontal Scroll
        if HorizontalerBildaufbau.ischecked then
                curr_HScroll = 1
                HorizontalerBildaufbau.uncheck
        else
                curr_HScroll = 0
                HorizontalerBildaufbau.check
                warnlog "<display horizontal scroll> is not checked by default"
        end if
        flag_HScroll = HorizontalerBildaufbau.GetState

        ' Vertical Scroll
        if VertikalerBildaufbau.ischecked then
                curr_VScroll = 1
                VertikalerBildaufbau.uncheck
        else
                curr_VScroll = 0
                VertikalerBildaufbau.check
                warnlog "<display vertical scroll> is not checked by default"
        end if
        flag_VScroll = VertikalerBildaufbau.GetState

        ' Sheet tabs
        if Tabellenregister.ischecked then
                curr_Sheet = 1
                Tabellenregister.uncheck
        else
                curr_Sheet = 0
                Tabellenregister.check
                warnlog "<display sheet tabs> is not checked by default"
        end if
        flag_Sheet = Tabellenregister.GetState

        ' Outline symbols
        if Gliederungssymbole.ischecked then
                curr_Out = 1
                Gliederungssymbole.uncheck
        else
                curr_Out = 0
                Gliederungssymbole.check
                warnlog "<display outline symbols> is not checked by default"
        end if
        flag_Out = Gliederungssymbole.GetState

        ' Formulas
        if Formeln.ischecked then
                curr_Form = 1
                warnlog "<display formulas> is checked by default"
                Formeln.uncheck
        else
                curr_Form = 0
                Formeln.check
        end if
        flag_Form = Formeln.GetState

        ' Zero Values
        if Nullwerte.ischecked then
                curr_Val = 1
                Nullwerte.uncheck
        else
                curr_Val = 0
                Nullwerte.check
                warnlog "<display zero values> is not checked by default"
        end if
        flag_Val = Nullwerte.GetState

        ' Note Indicator
        if Notizanzeiger.ischecked then
                curr_Note = 1
                Notizanzeiger.uncheck
        else
                curr_Note = 0
                Notizanzeiger.check
                warnlog "<display note indicator> is not checked by default"
        end if
        flag_Note = Notizanzeiger.GetState

        ' Value Highlighting
        if WerteHervorheben.ischecked then
                curr_ValHigh = 1
                warnlog "<display value highlighting> is checked by default"
                WerteHervorheben.uncheck
        else
                curr_ValHigh = 0
                WerteHervorheben.check
        end if
        flag_ValHigh = WerteHervorheben.GetState

        ' Anchor
        if Anker.ischecked then
                curr_Anch = 1
                Anker.uncheck
        else
                curr_Anch = 0
                Anker.check
                warnlog "<display anchor> is not checked by default"
        end if
        flag_Anch = Anker.GetState

        ' Text Overflow
        if Textueberlauf.ischecked then
                curr_Text = 1
                Textueberlauf.uncheck
        else
                curr_Text = 0
                Textueberlauf.check
                warnlog "<display text overflow> is not checked by default"
        end if
        flag_Text = Textueberlauf.GetState

        ' Show reference in color
        if Referenzenfarbig.ischecked then
                curr_ShowRef = 1
                Referenzenfarbig.uncheck
        else
                curr_ShowRef = 0
                Referenzenfarbig.check
                warnlog "<display show reference> in color is not checked by default"
        end if
        flag_ShowRef = Referenzenfarbig.GetState

        ' Close the Options dialog with the made settings
        Kontext "OptionenDlg"
        OptionenDlg.OK
    sleep 5
        Call hCloseDocument

endcase

'*********************************************************************************************************

testcase tOptionsContent_reload
'/// Documentation is summarized in tOptionsContent_save

    sleep 5
        'Restart the office
        ExitRestartTheOffice
        Call hNewDocument

        ' Check if settings are persistent
        ToolsOptions
        hToolsOptions("SPREADSHEET", "VIEW")

    ' grids
    if Gitterlinien.GetState = flag_Grids then
        printlog "OK, new settings for <display grids> are stored"
        else
                warnlog "Changing <display grids> failed"
        end if
        ' Page breaks
    if Seitenumbruch.GetState = flag_Page then
        printlog "OK, new settigs for <display pages> are stored"
        else
                warnlog "Changing <display pages> failed"
        end if

        ' Guides
        if Hilfslinien.GetState = flag_Guides then
                printlog "OK, new settigs for <display guides> are stored"
        else
                warnlog "Changing <display guides> failed"
        end if

        ' Simple Handles
        if EinfacheGriffe.GetState = flag_Simple then
                printlog "OK, new settigs for <display values> are stored"
        else
                warnlog "Changing <display values> failed"
        end if

        ' Large Handles
        if GrosseGriffe.GetState = flag_Large then
                printlog "OK, new settigs for <display large handles> are stored"
        else
                warnlog "Changing <display large handles> failed"
        end if

        ' Column/Row headers
        if ZeilenUndSpaltenkoepfe.GetState = flag_ColRow then
                printlog "OK, new settigs for <display text overflow> are stored"
        else
                warnlog "Changing <display text overflow> failed"
        end if

        ' Horizontal scroll
        if HorizontalerBildaufbau.GetState = flag_HScroll then
                printlog "OK, new settigs for <display horizontal scroll> are stored"
        else
                warnlog "Changing <display horizontal scroll> failed"
        end if

        ' Vertical Scroll
        if VertikalerBildaufbau.GetState = flag_VScroll then
                printlog "OK, new settigs for <display vertical scroll> are stored"
        else
                warnlog "Changing <display vertical scroll> failed"
        end if

        ' Sheet tabs
        if Tabellenregister.GetState = flag_Sheet then
                printlog "OK, new settigs for <display sheet tabs> are stored"
        else
                warnlog "Changing <display sheet tabs> failed"
        end if

        ' Outline symbols
        if Gliederungssymbole.GetState = flag_Out then
                printlog "OK, new settigs for <display outline symbols> are stored"
        else
                warnlog "Changing <display outline symbols> failed"
        end if

        ' Grid color
        if Farbe.GetSelIndex = stat_Color then
                printlog "OK, new settigs for <grid color> are stored"
        else
                warnlog "Changing <grid color> failed"
        end if

        ' Formulas
        if Formeln.GetState = flag_Form then
                printlog "OK, new settigs for <display formulas> are stored"
        else
                warnlog "Changing <display formulas> failed"
        end if

        ' Zero Values
        if Nullwerte.GetState = flag_Val then
                printlog "OK, new settigs for <display zero values> are stored"
        else
                warnlog "Changing <display zero values> failed"
        end if

        ' Note Indicator
        if Notizanzeiger.GetState = flag_Note then
                printlog "OK, new settigs for <display note indicator> are stored"
        else
                warnlog "Changing <display note indicator> failed"
        end if

        ' Value Highlighting
        if WerteHervorheben.GetState = flag_ValHigh then
                printlog "OK, new settigs for <value highlighting> are stored"
        else
                warnlog "Changing <value highlighting> failed"
        end if

        ' Anchor
        if Anker.GetState = flag_Anch then
                printlog "OK, new settigs for <display anchor> are stored"
        else
                warnlog "Changing <display anchor> failed"
        end if

        ' Text Overflow
        if Textueberlauf.GetState = flag_Text then
                printlog "OK, new settigs for <show text overflow> are stored"
        else
                warnlog "Changing <show text overflow> failed"
        end if

        ' Show reference in color
    if Referenzenfarbig.GetState = flag_ShowRef then
                printlog "OK, new settigs for <show references in color> are stored"
        else
                warnlog "Changing <show references in color> failed"
        end if

        ' Close the Options dialog with the new settings

        Kontext "OptionenDlg"
        OptionenDlg.Cancel

        Call hCloseDocument

endcase

'*********************************************************************************************************

testcase tOptionsContentRestore_settings
'/// Documentation is summarized in tOptionsContent_save

        'Restart the complete office
        ExitRestartTheOffice
        Call hNewDocument

        ' restore the default settings
        ToolsOptions
        hToolsOptions("SPREADSHEET", "VIEW")

    ' Grids and Color
    Gitterlinien.check
    Farbe.Select curr_Color
    if curr_Grids = 1 then
        Gitterlinien.check
    else
        Gitterlinien.uncheck
    end if

    ' Page breaks
    if curr_Page = 1 then
        Seitenumbruch.check
    else
        Seitenumbruch.uncheck
    end if

    ' Guides
    if curr_Guides = 1 then
        Hilfslinien.check
    else
        Hilfslinien.uncheck
    end if

    ' Simple Handles
        if  curr_Simple = 1  then
        EinfacheGriffe.check
        else
                EinfacheGriffe.uncheck
        end if

    ' Large Handles
        if curr_Large = 1 then
        GrosseGriffe.check
        else
                GrosseGriffe.uncheck
        end if

        ' Column/Row headers
        ' printlog "curr_ColRow " & curr_ColRow
        if curr_ColRow = 1 then
        ZeilenUndSpaltenkoepfe.check
        else
                ZeilenUndSpaltenkoepfe.uncheck
        end if

        ' Horizonral Scroll
        if curr_HScroll = 1 then
                HorizontalerBildaufbau.check
        else
                HorizontalerBildaufbau.uncheck
        end if

        ' Vertical Scroll
        if curr_VScroll = 1 then
                VertikalerBildaufbau.check
        else
                VertikalerBildaufbau.uncheck
        end if

        ' Sheet tabs
        if curr_Sheet = 1 then
                Tabellenregister.check
        else
                Tabellenregister.uncheck
        end if

        ' Outline symbols
        if curr_Out = 1 then
                Gliederungssymbole.check
        else
                Gliederungssymbole.uncheck
        end if


        '*************************************************************************

        ' Formulas
        if curr_Form = 1 then
                Formeln.check
        else
                Formeln.uncheck
        end if

        ' Zero Values
        if curr_Val = 1 then
                Nullwerte.check
        else
                Nullwerte.uncheck
        end if

        ' Note Indicator
        if curr_Note = 1 then
                Notizanzeiger.check
        else
                Notizanzeiger.uncheck
        end if

        ' Value Highlighting
        if curr_ValHigh = 1 then
                WerteHervorheben.check
        else
                WerteHervorheben.uncheck
        end if

        ' Anchor
        if curr_Anch = 1 then
                Anker.check
        else
                Anker.uncheck
        end if

        ' Text Overflow
        if curr_Text = 1 then
                Textueberlauf.check
        else
                Textueberlauf.uncheck
        end if

        ' Show reference in color
    if curr_ShowRef = 1 then
        Referenzenfarbig.check
    else
                Referenzenfarbig.uncheck
        end if


    Kontext "OptionenDlg"
        OptionenDlg.OK

        Call hCloseDocument

endcase







