'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: querytools.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: msc $ $Date: 2006/02/02 12:47:52 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : marc.neumann@sun.com
'*
'* short description : Helper Routines for Base tests.
'*
'***************************************************************************************
'*
' #1 fFindQuery
' #1 fOpenNewQueryDesign
' #1 fStartQueryWizard
' #1 fCloseQueryDesign
'*
'\***********************************************************************************
'-------------------------------------------------------------------------
function fFindQueryInBeamer(sDSName1,sQueryName1)
    '/// select a query with the given name in the beamer 
    '/// <u>parameter:</u>
    '/// <b>sDSName1:</b> the name of the datasource
    '/// <b>sQueryName1:</b> the name of the query
    
	dim i as integer
	dim bfindQuery as boolean
	dim iNoDS as integer
    dim iNoQuery as integer
    
    bfindQuery = false
	Kontext "DatabaseBeamer"
    Kontext "DatabaseSelection"
		
    iNoDS = DatabaseSelection.getItemCount	
	for i = 1 to iNoDS
		DatabaseSelection.Select i
		if DatabaseSelection.getText = sDSName1 then
			i = iNoDS
		endif
	next i
	
    wait 500
	DatabaseSelection.TypeKeys "<ADD>" , true
    wait 500
	DatabaseSelection.TypeKeys "<DOWN>" , true
    wait 500
	DatabaseSelection.TypeKeys "<DOWN>" , true
    wait 500
	DatabaseSelection.TypeKeys "<ADD>" , true
    wait 500
	DatabaseSelection.TypeKeys "<DOWN>" , true
    wait 500
	
	
    iNoQuery = DatabaseSelection.getItemCount
    dim ii as integer
    ii = DatabaseSelection.GetSelIndex	
	for i = ii to iNoQuery
		DatabaseSelection.Select i
		if DatabaseSelection.getText = sQueryName1 then
			i = iNoQuery
		    sleep 1			
		    bfindQuery = true
		endif
	next i
	
    fFindQuery = bfindQuery
	
end function
'--------------------------------------------------------------------
function fOpenNewQueryDesign() as boolean
    '/// open a new query design 
    '/// <u>parameter:</u>
    printlog "check if Insight exists"
    
    Kontext "Insight"    
        Insight.MouseDown(50,50)
        Insight.MouseUp(50,50)
    
    if ( Insight.NotExists(3) ) then
        fOpenNewQueryDesign = false
        warnlog "The Insight windows doesn't exists"
        exit function
    end if
    
    sleep(1)
    
    printlog "open new query design"
    
    NewQueryDesign
    
    fOpenNewQueryDesign = true
    
end function
'-------------------------------------------------------------------------
function fStartQueryWizard()
    '/// start the query wizard 
    '/// <u>parameter:</u>    

    Kontext "Insight"    
	    if ( Insight.NotExists(3) ) then
	        fStartQueryWizard = false
	        exit function
	    end if

        Insight.MouseDown(50,50)
        Insight.MouseUp(50,50)
    
    sleep(1)
    
    ViewQueries
    StartQueryWizard
    
    sleep(2)
    
    fStartQueryWizard = true
    
end function
'-------------------------------------------------------------------------
function fCloseQueryDesign(optional bSave)
    '/// close the query design
    '/// <u>parameter:</u>
    '/// <b><i>optional</i>bSave:</b> if true the query is saved if false then the changes are lost

    sleep(1)

    Kontext "QueryDesignTable"
        QueryDesignTable.UseMenu
        ' bug file / close close the whole database
        'hMenuSelectNr(1) ' the file menu
        'hMenuSelectNr(4) ' the Close Window
        
        hMenuSelectNr(6) ' the window menu
        hMenuSelectNr(1) ' the Close Window
    
    Kontext "Messagebox"
        if Messagebox.Exists(3) then
            if ( IsMissing( bSave ) ) then
                Messagebox.No
            else
                if bSave then
                    Messagebox.Yes
                else
                    Messagebox.No
                endif
            endif
        end if
        
    sleep(1)
        
end function
'-------------------------------------------------------------------------
function fCloseQueryView
    '/// close an open Query View 
    '/// <u>parameter:</u>    
    
    sleep(1)

    Kontext "DatabaseBeamer"
        DatabaseBeamer.UseMenu    
        ' bug file / close close the whole database
        'hMenuSelectNr(1) ' the file menu
        'hMenuSelectNr(4) ' the Close Window
        
        hMenuSelectNr(5) ' the window menu
        hMenuSelectNr(1) ' the Close Window
                
    Kontext "Messagebox"
        if Messagebox.Exists(3) then
            Messagebox.No
        end if
    
    sleep(1)
    
    fCloseQueryView = true

end function
'-------------------------------------------------------------------------
function fChooseTableInAddTableDialog(sTableName as string) as boolean
    Kontext "AddTables"
        if ( not AddTables.exists(1) ) then
            fChooseTableInQueryAddTableDialog = false    
            exit function            
        endif
        
    'TODO: add a test to click on the execute button, before the add table dialog is closed.
        dim ix as integer 
        dim i as integer
        ix = TableName.getItemCount                
        for i = 1 to ix
            TableName.Select i
            TableName.TypeKeys "<ADD>"
            'printlog "ix = " + ix
            'printlog "TableName.getItemCount = " + TableName.getItemCount 
            if TableName.getItemCount > ix then
                ix = TableName.getItemCount
                'printlog "TableName.getItemCount > ix"
            endif
            'printlog "TableName.getSeltext = " + TableName.getSeltext
            if TableName.getSeltext = sTableName then
                i = ix
            endif
        next
        if TableName.getSeltext <> sTableName then
            warnlog "Can find the table " + sTableName + "." + _
                    "Make sure that the table exists when starting this test."
            DatabaseClose                        
            sleep(5)
            Kontext "Messagebox"
                if Messagebox.Exists(3) then
                    if Messagebox.getRT = 304 then
                        Messagebox.No                        
                    end if                        
                end if                
            call hCloseDocument
            exit function
        endif
        printlog "- Add " + sTableName +" table to query design"
        '/// Add database table to Query.
        AddTable.Click
        sleep(2) 
        if AddTables.exists(2) then 
            CloseDlg.Click ' When the AddTables dialog still exists then close him
        endif
        sleep(1)
        fChooseTableInAddTableDialog = true
        
end function 
