'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: b_lvl1_Performance_General.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: clu $ $Date: 2006/01/18 14:55:33 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : christoph.lukasiak@sun.com
'*
'* short description : general oo db performance - Do not remove or change this line!
'************************************************************************
'*
' #1 tHSQLdb_performance - tests performance of HSQL db, tables and querys
' #1 tHSQLwizard_performance - tests performance of Wizards on HSQL db (Form,Report,Query,Table)
' #1 tAnalizeMP - compares 'read in values' with 'reference values' and warn if they are outside the defined area 
'*
'\***********************************************************************

    ' ************** Global defined variables
    dim sMPDataPath as string       'area where the MP reference data is saved - if the user/work directory is deleted after reinstallation and you want to keep the data, please change the lower path
    dim d_StartDate as date         'start date, that has to be global (because of several callings of fStopwatch)
    dim iValueMax as integer        'global max amount of mesured values (used in different parts of this test)
    dim aValues(1,1)                'global value array (used in different parts of this test)

sub b_lvl1_Performance_General
    
    sMPDataPath = gOfficePath + ConvertPath("user/work/tt_performance_analyze.csv")
    iValueMax = 19                  'amount of measured values (starting from 0!)
    redim aValues(2,iValueMax)      'value array - only works proper with redim, because of the inserted used variable

    call tHSQLdb_performance        'please neither change the direction of the testcases nor leave any of them
    call tHSQLwizard_performance    'tHSQLdb_performance has to run first, because of the needed db & table 
    call tAnalizeMP                 'needs upper testcases to have measured dates to compare with
    
end sub

'--------------------------------------------------------------------------------------

testcase tHSQLdb_performance
    
    ' *********************************************************************
    '   databases specific settings for hsqldb
    ' *********************************************************************
        
    Dim i_fieldcount as integer 'amount of field types - columns
	i_fieldcount = 7 'amount of field types (no primary key supported in dBase) normally: 7
		
	Dim ifieldrow_amount as integer 'amount of inserted rows
	ifieldrow_amount = 3
	
    Dim sFileName as string
	sFileName = gOfficePath + ConvertPath("user/work/tt_performance_hsqldb.odb")
    
	Dim sTableName as string
	sTableName = "tt_performance-table"
	
	Dim sPWD as string
	sPWD = "ignore"
	
	Dim sCatalog as string
	sCatalog = " "     			' not used in this ds
	
	Dim sSchema as string
	sSchema = " "     			' not used in this ds
	
	
    Dim aFieldTypeContent(i_fieldcount,2) as string 'database specific data matrix
        
    aFieldTypeContent(1,1)="tt_boolean"	        'name of fieldtype
    aFieldTypeContent(1,2)="boolean"         	'number of fieldtype (listbox entry)
    
    aFieldTypeContent(2,1)="tt_longvarchar"			
    aFieldTypeContent(2,2)="longvarchar"			
    
    aFieldTypeContent(3,1)="tt_char"		
    aFieldTypeContent(3,2)="char"		
        
    aFieldTypeContent(4,1)="tt_decimal"
    aFieldTypeContent(4,2)="decimal"
        
    aFieldTypeContent(5,1)="tt_varchar"
    aFieldTypeContent(5,2)="varchar"
         
    aFieldTypeContent(6,1)="tt_date"    
    aFieldTypeContent(6,2)="date"
    
    Dim aFieldContent(1,6) as string 'database specific data matrix
        
    aFieldContent(1,1)="<space>"
    aFieldContent(1,2)="this is a memo field"    
    aFieldContent(1,3)="char"			
    aFieldContent(1,4)="1"		
    aFieldContent(1,5)="this is a text field"
    aFieldContent(1,6)="13.05.2004  "
    
        ' Init
        call ExitRestartTheOffice       'restart office is necessary, because the performance change if some recources are already uploaded
        call fpReference                'creates a single reference value (not the reference table) 
    
        dim dbok as boolean
        dbok = fpCreateHSQLDatasource(sFileName)       
        if dbok = true then
             
            call fpOpendatabase(sFileName)    
            call fpCreateTable(aFieldTypeContent(), sTableName)
            call fpCreateQuery(sTableName)
            call fpCreateForm
            call fpSaveDatabase
            
		else 
            warnlog "Data Source could not be created - beyond testcases stopped"
		endif
	
endcase
'--------------------------------------------------------------------------------------

testcase tHSQLwizard_performance
        
        'restart office is necessary, because the performance change if some recources are already uploaded
        call ExitRestartTheOffice       
        call fpFormWizard
        call ExitRestartTheOffice
        call fpReportWizard
        call ExitRestartTheOffice
        call fpQueryWizard
        call ExitRestartTheOffice
        call fpTableWizard        
endcase
'--------------------------------------------------------------------------------------

testcase tAnalizeMP

    dim iNumber As Integer      'file handling variable
    dim sRow As String          'file row variable
    dim sFile As String         'file name & path variable
    dim lFileNum as long        'file position (row number) variable
    dim bAnalyzeOK as boolean   'check variable if everithing goes right (endtext depend on this)
    'Init
    sFile = sMPDataPath         'set filename as global name (defined at the beginning)
    iNumber = Freefile          'file needed value
    bAnalyzeOK = true           'set default - if anything wrong it is changed in 'false'
    
    '/// Open or create proper reference value file 
    Open sFile for Input as iNumber
    
    '/// Search for the reference value row in file
    While (not eof(iNumber)) or  (not lFileNum = 2)  'first line is the header 2'nd the reference value - to compare with other value, change the 'lFileNum' 
    Line Input #iNumber, sRow
    If sRow <>"" then
    lFileNum = Loc(#iNumber)
        if lFileNum = 2 then
            printlog "*** Reference Values (in sec.): " + sRow
            
            '/// Read in reference values and bring in proper format
            dim SplitArray()        'variable need for the 'split' command - split array (with values seperated by , ) in single strings 
            dim icount as integer   'local counter
            SplitArray() = Split (sRow,",", iValueMax)  'split values from global array (already filled from save variable on each MP)
            
            for icount = 0 to iValueMax -1
                dim iMP_Value, iRef_Value as integer    'memo variables to change in proper format (string->number)
                
                iMP_Value = aValues(1,icount)
                iRef_Value = SplitArray(icount)
               'printlog "wert1: " & iMP_Value
               'printlog "wert2: " & iRef_Value
               
               '///  Compare reference with measured values and if differs, check if difference is inside defined borders 
               if iMP_Value > iRef_Value then
                    'printlog "values differ"
                    '7 is the 'divide' value: smaller 7 sec. -> 2 sec. more allowed - bigger equal 7 sec. 3 sec. more allowed (everything else is out of the defined area)
                    if iRef_Value < 7 then      
                        if iRef_Value + 2 < iMP_Value then
                            warnlog "Measured Value is much bigger than Reference Value - allowed are 2 sec. more, but there are: " & (iMP_Value - iRef_Value) & " sec." 
                            printlog "Measured Value is: " & iMP_Value & "; Reference Value is: " & iRef_Value
                            bAnalyzeOK = false
                        end if
                    else
                        if iRef_Value + 3 < iMP_Value then
                            warnlog "Measured Value is much bigger than Reference Value - allowed are 3 sec. more, but there are: " & (iMP_Value - iRef_Value) & " sec." 
                            printlog "Measured Value is: " & iMP_Value & "; Reference Value is: " & iRef_Value
                            bAnalyzeOK = false
                        end if
                    endif
                else
                    'printlog "Values inside defined borders"
                end if
                
            next icount
            
            end if   
    else warnlog "Referenztable is anyway corrupted: No analyse possible"
        goto endsub
    end if
    wend
    Close #iNumber
    
    '/// Print out endresults
    if bAnalyzeOK = true then
        printlog ""
        printlog "*** Analyse complete: Values compared and all inside the defined borders"
    else
        printlog ""
        printlog "*** Analyse complete: Values compared and some of them are not inside the defined borders!"
    end if 
   
endcase
'--------------------------------------------------------------------------------------

function fpReference

        dim dstartdate as date

        printlog ""
        printlog "** Reference Value Performance Test: without weight **"
        dstartdate = fStopwatch(true,"HSQL Reference",0)
        fStopwatch(false,"HSQL Reference",0, dstartdate)
        
end function
'--------------------------------------------------------------------------------------

function fpCreateHSQLDatasource(sFileName, optional sRegister) as boolean
    printlog ""
    printlog "** Database Performance Test: using a HSQL db **"  
    '/// create a new hsql database file with the given filename    
    '/// <u>parameter:</u>fStopwatch(true)
    '/// <b>sFielName:</b> the file name for the database file
    '/// <b><i>optional</i> sRegister:</b> the name under which the database is registered
	dim bOK as boolean
	bOK = FALSE
	
    'make shure that toolbar is closed (disturbs: 'fpCreateForm')
    Kontext "FormControls"
    if FormControls.exists then
        FormControls.Close
    end if
  
    ' delete the file
    if ( app.Dir( ConvertPath(sFileName) ) ) <> "" then
        app.kill(ConvertPath(sFileName))
    endif
      
    try    
        Kontext "DocumentWriter"
            DocumentWriter.UseMenu
            hMenuSelectNr(1)
            hMenuSelectNr(1)
            hMenuSelectNr(5)
        
        sleep(10)
            
        Kontext "DatabaseWizard"    
            CreateNewDatabase.Check
            sleep(1)
            NextBtn.Click
            sleep(1)        
            FinishBtn.Click
            sleep(1)
                          
        Kontext "SpeichernDlg"
            Dateiname.setText ConvertPath(sFileName) 
                           
        '/// measure point begin: 'HSQL DS Create'
            dim dstartdate as date
            dstartdate = fStopwatch(true, "HSQL DS Create",1)
            
            Speichern.click      'trigger
        
            Kontext "Insight"
            do while Insight.exists() = false
                Kontext "Insight"
            loop
            
            fStopwatch(false, "HSQL DS Create", 1, dstartdate)
       '/// measure point end
         sleep(1)
             
        if ( IsMissing(sRegister) ) then
                printlog "don't register datasource"
        else        
            printlog "register datasource with name " + sRegister        
            call fRegisterDatabaseFile(ConvertPath(sFilename),sRegister)
        end if

        call fpCloseDatabase(true)  
        
        bOK = true
    catch
        bOK = false
    endcatch
	
	if bOK = true then
		printlog "End of function: fpCreateHSQLDatasource - *** Succeed ***"
	else
    	warnlog "--- End of function: fpCreateHSQLDatasource - *** Failed *** Data source was not created"
	endif	
	
	fpCreateHSQLDatasource = bOK
	sleep(1)
    
end function
'--------------------------------------------------------------------------------------

function fpOpenDataBase ( sFileName , optional sPassword)    
    '/// attention: must be closed again! f.e. with function: fpCloseDatabase
    '/// open a database file with the given name
    '/// <u>parameter:</u>
    '/// <b>sFileName:</b> the file name which shall be open
    '/// <b><i>optional</i>sFileName:</b> the password for connecting                

    Dim DieDatei as String
    DieDatei = ConvertPath ( sFileName )
    '/// open the File Open dialog
    printlog "open the File Open dialog"
    FileOpen
    sleep (1)
    Kontext "OeffnenDlg"
    '/// open the given file
    printlog "open the given file: " + sFileName
    Dateiname.SetText DieDatei
    sleep (3)
    
    '/// measure point begin: 'HSQL DS Open'
        dim dstartdate as date
        dstartdate = fStopwatch(true, "HSQL DS Open", 2)
        
        Oeffnen.Click     'trigger
        
            Kontext "Insight"
            do while Insight.exists() = false
                Kontext "Insight"
            loop
            
         fStopwatch(false, "HSQL DS Open", 2, dstartdate)
    '/// measure point end
         sleep(1)
         
    Kontext "Insight"
    '/// if the password is given add the password    
    if ( Not IsMissing(sPassword) ) then
        printlog "set password : " + sPassword    
        ViewTables
        sleep(1)
        Kontext "LoginDialog"
        if LoginDialog.Exists then
         	Password.setText sPassword
         	LoginDialog.OK
            sleep(1)
        endif  
    endif
    
    fpOpenDataBase = true
    
end function
'--------------------------------------------------------------------------------------

function fpCreateTable(aFieldTypeContent(),sTableName,optional sCatalog,optional sSchema)
    printlog ""
    printlog "** Table Performance Test: using a HSQL db **"  
    '/// create a table with the given FieldTypes
    '/// sSchema and sCatalog are optional.
    '/// If the optional parameter is not given then it's set to ""
    '/// <u>parameter:</u>
    '/// <b>aFieldTypeContent:</b> an arry with the table field data
    '/// &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; the array have to look like the following
    '/// &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; array(1,1) = first_field_name
    '/// &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; array(1,2) = first_field_type
    '/// &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; array(2,1) = second_field_name
    '/// &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; array(2,2) = second_field_type
    '/// &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ...
    '/// <b>sTableName:</b> the name of the table
    '/// <b><i>optional</i> sCatalog:</b> the name of the table catalog
    '/// <b><i>optional</i> sSchema:</b> the name of the table schema
	
    Dim i as integer			        'icount
	Dim iFieldNumber as integer			'icount
	dim iNoDS as integer                'number of data source in listbox
	Dim iNumberOfFieldTypes as integer          'field type memory
	Dim iFieldTypesIcount as integer   'icount
	Dim iIndex as integer               'icount
	Dim sFieldType as string            'help var for fieldtypes
    Dim sTypeName as String             'help var for fieldtypes
    
    if ( IsMissing(sCatalog) ) then
        sCatalog = ""
    endif
    
    if ( IsMissing(sSchema) ) then
        sSchema = ""
    endif
    
    call fDeleteTable(sTableName) ' delete the table if exists
    
    printlog "fOpenNewTableDesign called"
    printlog "check if Insight exists"  
    Kontext "Insight"    
        Insight.MouseDown(50,50)
        Insight.MouseUp(50,50)  
    if ( Insight.NotExists(3) ) then
        fOpenNewTableDesign = false
        warnlog "The Insight windows doesn't exists"
        exit function
    end if  
    sleep(1)
    
    printlog "open new table design"
    
    '/// measure point begin: 'Table Design Start'
        dim dstartdate as date
        dstartdate = fStopwatch(true, "Table Design Start", 5 )
        
        NewTableDesign     'trigger
        
            Kontext "TableDesignTable"
            do while TableDesignTable.exists() = False
                Kontext "TableDesignTable"
            loop
            
         fStopwatch(false, "Table Design Start", 5 , dstartdate)
    '/// measure point end
            sleep(1)

    Kontext "TableDesignTable"
    
    for iFieldNumber = 1 to ubound(aFieldTypeContent) - 1

        'printlog "create field : " + aFieldTypeContent(iFieldNumber,1)
        Fieldname.TypeKeys aFieldTypeContent(iFieldNumber,1) , TRUE    
        Fieldname.TypeKeys "<RETURN>" , TRUE
        sleep 1
        sTypeName = "[ " + aFieldTypeContent(iFieldNumber,2) + " ]"
        iNumberOfFieldTypes = FieldType.getitemCount()
        for iFieldTypesIcount = 1 to iNumberOfFieldTypes                 
            sFieldType = FieldType.getitemText(iFieldTypesIcount)            
            iIndex = Instr(sFieldType,sTypeName)                
            if iIndex <> 0 then
                'printlog "FieldType : " + sFieldType
                iFieldTypesIcount = iNumberOfFieldTypes ' stops the for loop if proper fieldtype found'
            endif
        next
        '/// choose proper field type
        FieldType.Select(sFieldType)    'listbox entry nr'
        sleep 1
        FieldType.TypeKeys "<RETURN>" , TRUE
        Description.TypeKeys "<RETURN>" , TRUE
        'printlog "-------------------------------"
    next 
    sleep(1)    
    Kontext "TableDesignTable"         
        TableDesignTable.usemenu
        MenuSelect MenuGetItemId (1)
        sleep(1)
        menuselect MenuGetItemId (5)
        sleep(1)
    Kontext "Messagebox"
            Messagebox.Yes  
            printlog "messagebox 'save change?' -> yes"
    Kontext "DatabaseTableSaveAs"
        printlog "save table as "+ sTableName
        TableName.setText sTableName
        sleep(1)
        '/// catalog handling
        if sCatalog <> "" then
            if Catalog.IsVisible then
                Catalog.SetText sCatalog
                printlog "inserting catalog name: " + sCatalog
            else 
                warnlog "The Catalog-Name could not be inserted"
            endif
        endif
        '/// schema handling
        if sSchema <> "" then
            if Schema.IsVisible then
                Schema.SetText sSchema
                printlog "inserting schema name: " + sSchema
            else 
                warnlog "The Schema-Name could not be inserted"
            endif
        endif
        DatabaseTableSaveAs.OK
        sleep 1
        printlog "create a primary key "
        sleep 1	
   
        '/// measure point begin: 'Table Design Save'
            'dim dstartdate as date
            Kontext "Messagebox"
            dstartdate = fStopwatch(true,"Table Design Save",6)
            
            Messagebox.Yes       'trigger
        
            Kontext "TableDesignTable"
            do while TableDesignTable.exists() = true
                Kontext "TableDesignTable"
            loop
            
         fStopwatch(false,"Table Design Save",6,dstartdate)
    '/// measure point end
         sleep(1)
         
end function
'--------------------------------------------------------------------------------------

function fpCreateQuery(sTableName) as boolean
    printlog ""
    printlog "** Query Performance Test: using a HSQL db **"  
    '/// open a new query design 
    '/// <u>parameter:</u>
    printlog "check if Insight exists"
    
    Kontext "Insight"    
        Insight.MouseDown(50,50)
        Insight.MouseUp(50,50)
    
    if ( Insight.NotExists(3) ) then
        fOpenNewQueryDesign = false
        warnlog "The Insight windows doesn't exists"
        exit function
    end if
    sleep(1)
    
    printlog "open new query design"
    
    '/// measure point begin: 'Query Design Start'
        dim dstartdate as date
        dstartdate = fStopwatch(true,"Query Design Start",7)
        
        NewQueryDesign     'trigger
        
            Kontext "AddTables"
            do while AddTables.exists() = False
                Kontext "AddTables"
            loop
            
         fStopwatch(false, "Query Design Start",7,dstartdate)
    '/// measure point end
            sleep(1)
    
    '/// add table
    Kontext "AddTables"
        AddTable.Click
        CloseDlg.Click
        sleep(2)
        
    Kontext "QueryDesignCriterion"
        QueryDesignCriterion.TypeKeys "<MOD1 UP>" , true
        sleep(2)
        QueryDesignCriterion.TypeKeys "<Return>" , true
        sleep(2)
        
    Kontext "QueryDesignTable"    
    QueryDesignTable.useMenu
        MenuSelect MenuGetItemId (1)
        sleep(1)
        menuselect MenuGetItemId (5)
        sleep(1)
        
    Kontext "Messagebox"
        sleep(1)
        Messagebox.Yes  
        printlog "messagebox 'save change?' -> yes"
        sleep(1)
            
    Kontext "DatabaseTableSaveAs"
        printlog "save table as "+ sTableName
        TableName.setText sTableName
        sleep(1)
        
    '/// measure point begin: 'Query Design Save'
        'dim dstartdate as date
        dstartdate = fStopwatch(true,"Query Design Save",8)
        DatabaseTableSaveAs.OK     'trigger
        
            Kontext "QueryDesignTable"
            do while QueryDesignTable.exists() = true
                Kontext "QueryDesignTable"
            loop
            
         fStopwatch(false, "Query Design Save",8,dstartdate)
    '/// measure point end
         sleep(1)
         
end function
'--------------------------------------------------------------------------------------

function fpCreateForm
         
	printlog ""
    printlog "** Form Performance Test: using a HSQL db **"  
    '/// open a new form design 
    '/// <u>parameter:</u>

    printlog "check if Insight exists"
    Kontext "Insight"    
        Insight.MouseDown(50,50)
        Insight.MouseUp(50,50)
    if ( Insight.NotExists(3) ) then
        fOpenNewQueryDesign = false
        warnlog "The Insight windows doesn't exists"
        exit function
    end if
    sleep(1)
    
    '/// measure point begin: 'Form Design Start'
            dim dstartdate as date
        dstartdate = fStopwatch(true,"Form Design Start",9)
        
        NewFormDesign     'trigger
        
            Kontext "FormControls"
            do while FormControls.exists() = False
                Kontext "FormControls"
            loop
            
         fStopwatch(false,"Form Design Start",9,dstartdate)
    '/// measure point end
            sleep(1)
    
    Kontext "Toolbar"
        call hToolbarSelect("FormControls",true)
        
        '/// insert a label field to create a form
   	    Label.Click
        sleep(1)      
        printlog "insert a label"        
        call hDrawingWithSelection ( 20, 20, 30, 30 )
        sleep(2)
        
    Kontext "DocumentWriter"    
        DocumentWriter.useMenu
        MenuSelect MenuGetItemId (1)
        sleep(1)
        menuselect MenuGetItemId (7)
        sleep(1)
        
    Kontext "Messagebox"
        sleep(1)
        Messagebox.Yes  
        printlog "messagebox 'save change?' -> yes"
        sleep(1)
         
    Kontext "FormSaveDialog"
        printlog "save table"
        
    '/// measure point begin: 'Form Design Save'
            'dim dstartdate as date
        dstartdate = fStopwatch(true,"Form Design Save",10)
        
        SaveBtn.click     'trigger
        
            Kontext "FormControls"
            do while FormControls.exists() = true
                Kontext "FormControls"
            loop
            
         fStopwatch(false,"Form Design Save",10,dstartdate)
    '/// measure point end
         sleep(1)
    
end function
'-------------------------------------------------------------------------

function fpCloseDatabase(optional bSave)
    '/// close the database
    '/// <u>parameter:</u>
    '/// <b><i>optional</i>bSave:</b> if true the the database is saved if false then the changes are lost
    sleep(1)
 	Kontext "Insight"
        Insight.MouseDown(50,50)
        Insight.MouseUp(50,50)
        Insight.useMenu   
        
    '/// measure point begin: 'HSQL DS Close'
        dim dstartdate as date
        hMenuSelectNr 1
        hMenuSelectNr 5      'trigger
        dstartdate = fStopwatch(true, "HSQL DS Close",3)
        
            Kontext "Insight"
            do while Insight.exists() = true
                Kontext "Insight"
            loop
            
         fStopwatch(false, "HSQL DS Close",3, dstartdate)
    '/// measure point end  
     
end function
'-------------------------------------------------------------------------

function fpSaveDatabase(optional bSave)
    printlog ""
    printlog "** Database Performance Test: using a HSQL db **"  
    '/// close the database
    '/// <u>parameter:</u>
    '/// <b><i>optional</i>bSave:</b> if true the the database is saved if false then the changes are lost
    sleep(1)
 	Kontext "Insight"
        Insight.MouseDown(50,50)
        Insight.MouseUp(50,50)
        Insight.useMenu
        hMenuSelectNr 1
        hMenuSelectNr 5                   
                    
     '/// measure point begin: 'HSQL DS Save'
        dim dstartdate as date
        Kontext "Messagebox"
        dstartdate = fStopwatch(true,"HSQL DS Save",4)
        
        Messagebox.Yes     'trigger
        
            Kontext "Insight"
            do while Insight.exists() = true
                Kontext "Insight"
            loop
            
         fStopwatch(false,"HSQL DS Save",4,dstartdate)
    '/// measure point end
         sleep(1)
                  
end function
'-------------------------------------------------------------------------

function fpFormWizard
    printlog ""
    printlog "** Form Wizard Performance Test: using a HSQL db **"    

    Dim sFileName as string
    sFileName = gOfficePath + ConvertPath("user/work/tt_performance_hsqldb.odb")
    call fOpenDatabase(sFileName)
        
    Kontext "Insight"
    
    Insight.MouseDown(50,50)
    Insight.MouseUp(50,50)
    sleep(1)
    'fStartDbEngine()
    
    '/// measure point begin: 'Form Wizard Start'
        dim dstartdate as date
        dstartdate = fStopwatch(true,"Form Wizard Start",11)
        
        StartFormWizard     'trigger
        
            Kontext "FormWizard"
            do while FormWizard.exists() = false
                Kontext "FormWizard"
            loop
            
         fStopwatch(false,"Form Wizard Start",11,dstartdate)
    '/// measure point end
         sleep(1)
    
    Kontext "FormWizard"
        TablesOrQueriesMaster.select 1
        '/// add the third field
        'printlog "add the third field"
        AvailableMasterFields.select 3
        sleep(1)
        MasterMoveSelected.click
        sleep(1)
         
        '/// click NEXT
        'printlog "click NEXT"
        NextBtn.click
        sleep(1)
        '/// click NEXT
        'printlog "click NEXT"
        NextBtn.click
        sleep(1)     
        '/// click NEXT
        'printlog "click NEXT"
        NextBtn.click
        sleep(1)     
        '/// click NEXT
        'printlog "click NEXT"
        NextBtn.click
        sleep(1)     
        '/// click NEXT
        'printlog "click NEXT"
        NextBtn.click
        sleep(1)             
        '/// click Finish
        'printlog "click Finish"       
        
    '/// measure point begin: 'Form Wizard Create'
        'dim dstartdate as date
        dstartdate = fStopwatch(true,"Form Wizard Create",12)
        
        FinishBtn.Click     'trigger
       
            Kontext "formsnavigationbar"
            do while formsnavigationbar.exists() = false
                Kontext "formsnavigationbar"
            loop
            
         fStopwatch(false,"Form Wizard Create",12,dstartdate)
    '/// measure point end
         sleep(1)
           
    call fCloseForm

    call fCloseDatabase

end function
'--------------------------------------------------------------------------------------

function fpReportWizard
    printlog ""
    printlog "** Report Wizard Performance Test: using a HSQL db **"    

    call fOpenDatabase(gOfficePath + ConvertPath("user/work/tt_performance_hsqldb.odb"))
        
    Kontext "Insight"
    
    Insight.MouseDown(50,50)
    Insight.MouseUp(50,50)
    sleep(1)
    'fStartDbEngine()
    
    '/// measure point begin: 'Report Wizard Start'
        dim dstartdate as date
        dstartdate = fStopwatch(true,"Report Wizard Start")
        
        StartReportWizard     'trigger
       
            Kontext "ReportWizard"
            do while ReportWizard.exists() = false
                Kontext "ReportWizard"
            loop
            
         fStopwatch(false,"Report Wizard Start",13,dstartdate)
    '/// measure point end
         sleep(1) 
    
    Kontext "ReportWizard"        
        sleep(1)
        Tables.select 1
        '/// add the third field
        'printlog "add the third field"
        AvailableFields.select 3
        sleep(1)
        Add.click
        sleep(1)
        '/// click NEXT
        'printlog "click NEXT"
        NextBtn.click
        sleep(1)        
        '/// click NEXT
        'printlog "click NEXT"
        NextBtn.click
        sleep(1)
        '/// click NEXT
        'printlog "click NEXT"
        NextBtn.click
        sleep(1)
        '/// click NEXT
        'printlog "click NEXT"
        NextBtn.click
        sleep(1)
        '/// click Finish
        'printlog "click Finish"       
        
        '/// measure point begin: 'Report Wizard Create'
        'dim dstartdate as date
        dstartdate = fStopwatch(true,"Report Wizard Create",14)
        
        FinishBtn.Click     'trigger
        
            Kontext "ReportWizard"
            do while ReportWizard.exists() = true
                Kontext "ReportWizard"
            loop
            
         fStopwatch(false, "Report Wizard Create",14,dstartdate)
         '/// measure point end
            sleep(1) 
    
    call fCloseForm ' should be changed to a CloseReport

    call fCloseDatabase

end function
'--------------------------------------------------------------------------------------

function fpQueryWizard
    printlog ""
    printlog "** Query Wizard Performance Test: using a HSQL db **"  
       
	if not fOpendatabase(gOfficePath + ConvertPath("user/work/tt_performance_hsqldb.odb")) then
        warnlog "Database " +gOfficePath + ConvertPath("user/work/tt_performance_hsqldb.odb") + " could not be open."
        exit function
    end if
    
    '/// start the query wizard 
    Kontext "Insight"    
        Insight.MouseDown(50,50)
        Insight.MouseUp(50,50)
    sleep(1)
    'fStartDbEngine()
    
    ViewQueries
    
    '/// measure point begin: 'Query Wizard Start'
        dim dstartdate as date
        dstartdate = fStopwatch(true,"Query Wizard Start",15)
        
        StartQueryWizard     'trigger
        
            Kontext "QueryWizard"
            do while QueryWizard.exists() = False
                Kontext "QueryWizard"
            loop
            
         fStopwatch(false,"Query Wizard Start",15,dstartdate)
    '/// measure point end
            sleep(1) 
    
    Kontext "QueryWizard"
        '/// select the first table (tt_performance-table)
        'printlog "select the first table (tt_performance-table)"
        Tables.select "tt_performance-table"
        sleep(1)
        '/// add the third field
        'printlog "add the third field"
        AvailableFields.select 3
        sleep(1)
        Add.click
        sleep(1)
        '/// click NEXT
        'printlog "click NEXT"
        NextBtn.click
        sleep(1)    
        '/// click NEXT
        'printlog "click NEXT"
        NextBtn.click
        sleep(1)            
        '/// click NEXT
        'printlog "click NEXT"
        NextBtn.click
        sleep(1)    
        '/// click NEXT
        'printlog "click NEXT"
        NextBtn.click
        sleep(1)    
        '/// click FINISH
        'printlog "click FINISH
        
    '/// measure point begin: 'Query Wizard Create'
        'dim dstartdate as date
        dstartdate = fStopwatch(true,"Query Wizard Create",16)
        
        FinishBtn.click     'trigger
        
            Kontext "QueryWizard"
            do while QueryWizard.exists() = true
                Kontext "QueryWizard"
            loop
            
         fStopwatch(false,"Query Wizard Create",16,dstartdate)
    '/// measure point end
            sleep(1) 
    
    Kontext "DatabaseBeamer"
        DatabaseBeamer.UseMenu
        call hMenuSelectnr(1)
        call hMenuSelectnr(4)
        
    call fCloseDatabase(true)
       
end function
'--------------------------------------------------------------------------------------

function fpTableWizard
    printlog ""
    printlog "** Table Wizard Performance Test: using a HSQL db **"  
    
    if ( iSprache = 46 ) then
        printlog "In some languages the fieldnames are wrongly translated, so the test doesn't work."
        exit function
    endif
    
    dim iTablesCount as Integer
    dim iFieldsCount as Integer
    dim i as Integer        

    call fOpenDataBase(gOfficePath + ConvertPath("user/work/tt_performance_hsqldb.odb"))
        
    Kontext "Insight"
    
    Insight.MouseDown(50,50)
    Insight.MouseUp(50,50)
    sleep(1)
    'fStartDbEngine()

    '/// display Tables View
    printlog "display Tables View"
    ViewTables
    Kontext "ContainerView"
    if not TableTree.exists(1) then        
        warnlog "TableTree doesn't appear"
        exit function
    end if
   
    '/// measure point begin: 'Table Wizard Start'
        dim dstartdate as date
        dstartdate = fStopwatch(true,"Table Wizard Start",17)
        
        StartTableWizard     'trigger
        
            Kontext "TableWizard"
            do while TableWizard.exists() = False
                Kontext "TableWizard"
            loop
            
         fStopwatch(false, "Table Wizard Start",17,dstartdate)
    '/// measure point end
            sleep(1) 
    
    Kontext "TableWizard"
        AddAll.click
        'sleep(1)
        '/// click NEXT
        'printlog "click NEXT"
        NextBtn.click
        'sleep(1)        
        '/// click NEXT
        'printlog "click NEXT"
        NextBtn.click
        'sleep(1)            
        '/// click CANCEL
        'printlog "click Finish"       
        
    '/// measure point begin: 'Table Wizard Create'
        'dim dstartdate as date
        dstartdate = fStopwatch(true,"Table Wizard Create",18)
        
        FinishBtn.click     'trigger
        
            Kontext "TableWizard"
            do while TableWizard.exists() = true
                Kontext "TableWizard"
            loop
            
         fStopwatch(false, "Table Wizard Create",18,dstartdate)
    '/// measure point end
            sleep(1) 
    
    call fCloseTableView()

    call fClosedatabase()
    
    'make shure that toolbar is close (disturbs: 'fpCreateForm')
    Kontext "FormControls"
    if FormControls.exists then
        FormControls.Close
    end if
    
end function
'-------------------------------------------------------------------------

function fStopwatch(bStart as boolean, sMPName as string, iMPNumb as integer, optional dfStartdate as date) as date 
        'Start: bStart = true - Stop: bStart = false (MP = Measure Point)
        'sMPName is the single name of each MP, where the time is stopped
        'iMPNumb is the number of each MP (is sorted in the array in ascending direction - to change the position, this number is to change - do not use numbers twice of leave any out)
        'dfStartdate is the overgiven date from this function (by start overgiven) - if this function is triggered second (stop) this value is used to get the result date
        '/// Stopwatch stops the time on each measure point (MP) and give back time result and other data
        dim d_StartDate as date
        dim d_ResultDate as date
        dim i_ResultDate as integer 'necessary to convert values in number format - only works that way, else format conflicts
        
        if bStart = true then 
            dfStartdate = Now
        else d_StartDate = Now
            printlog 
            d_ResultDate = d_StartDate - dfStartdate    'get the result date from the overgiven date and the current measured
            printlog "- Measure Point Performance (MP): " & sMPName & ": Running time: " & d_ResultDate & " --- Start time: " & dfStartdate & " ,Stop time: " & d_StartDate
            i_ResultDate = Second(TimeValue (d_ResultDate)) 'get the sec. value out of the whole date format
            
            fSaveValues(iMPNumb, sMPName, i_ResultDate)
 
        endif    
        
        fStopwatch = dfStartdate
        
end function

function fSaveValues(iMPNumb, sMPName, i_ResultDate)
    'overgiven variables described further in upper function fStopwatch'
    '/// Save the overgiven data (stopped with stopwatch on every measure point (MP))

    '/// Read in overgiven value (measured value)   
    aValues(0,iMPNumb) = sMPName
    aValues(1,iMPNumb) = i_ResultDate    
    'printlog "OutValue1: " + i_ResultDate

    '/// If the last value is read in, bring into proper format
    if iMPNumb = iValueMax -1 then
        dim sfMPValues, sfMPNames  as string    'local variables to handle array values, added to one string
        dim iValueIcount as integer             'local counter
        
        '/// Overtake header in string
        for iValueIcount = 0 to iValueMax -1      'read array in value string
            sfMPNames = sfMPNames & aValues(0,iValueIcount)
            sfMPNames = sfMPNames & ","
            'any further info is added at the 'back, so it does not disturb the value handling in front of the row'
            if iValueIcount = iValueMax -1 then sfMPNames = sfMPNames & "Office Version" 
            'printlog "OutValue12: " & sfMPNames
        next iValueIcount
        
        '/// Overtake value in string
        for iValueIcount = 0 to iValueMax -1      'read array in value string
            sfMPValues = sfMPValues & aValues(1,iValueIcount)
            sfMPValues = sfMPValues & ","
            'any further info is added at the 'back, so it does not disturb the value handling in front of the row'
            if iValueIcount = iValueMax -1 then 
                sfMPValues = sfMPValues & gVersionsnummer
                printlog ""
                printlog "*** All Measured Points: " & sfMPNames
                printlog "*** MP Results (in sec.): " & sfMPValues
            end if
        next iValueIcount
        
        '/// Write values (header) string in file
            Dim iCount As Integer   'local filehandling variable
            iCount = Freefile
        
        '///Check if file exist (if yes: add values , if not: create a new one and add values), write data and close file
        if FileExists(sMPDataPath) then
            open sMPDataPath for Append as iCount
            Print #iCount,sfMPValues
        else
            open sMPDataPath for Append as iCount
            Print #iCount,sfMPNames
            Print #iCount,sfMPValues       
            printlog ""
            printlog "** Attention: First time usage (values are compared with themselves) => no 'real' analysis possible!"
            printlog "     You have to run this test again, to get a proper analysis"
            printlog ""
        end if
            close #iCount   
            
    end if
    
end function

function fStartDbEngine()
	viewtables
	sleep (15)
	printlog "HSQL db Engine start"
	viewforms
	sleep (2)
end function
