// $Id: SDLImage.hh 11073 2009-12-30 12:10:00Z m9710797 $

#ifndef SDLIMAGE_HH
#define SDLIMAGE_HH

#include "BaseImage.hh"
#include "SDLSurfacePtr.hh"
#include <string>

namespace openmsx {

class SDLImage : public BaseImage
{
public:
	explicit SDLImage(const std::string& filename);
	explicit SDLImage(SDLSurfacePtr image);
	SDLImage(const std::string& filename, double scaleFactor);
	SDLImage(const std::string& filename, int width, int height);
	SDLImage(int width, int height, byte alpha,
	         byte r = 0, byte g = 0, byte b = 0);

	virtual void draw(OutputSurface& output, int x, int y,
	                  byte alpha = 255);
	virtual int getWidth() const;
	virtual int getHeight() const;

private:
	void allocateWorkImage();

	SDLSurfacePtr image;
	SDLSurfacePtr workImage;
	int a;
	bool flipX, flipY;
};

} // namespace openmsx

#endif
