// $Id: utf8_checked.cc 11268 2010-02-15 17:41:47Z mfeingol $

#ifdef _WIN32

#include "utf8_checked.hh"
#include "vla.hh"
#include "StringOp.hh"
#include "MSXException.hh"
#include <windows.h>

namespace utf8 {

bool ansitouf16(const std::string& ansi, UINT cp, DWORD dwFlags, std::wstring& utf16)
{
	const char* ansiA = ansi.c_str();
	int len = MultiByteToWideChar(cp, dwFlags, ansiA, -1, NULL, 0);
	if (len) {
		VLA(wchar_t, utf16W, len);
		len = MultiByteToWideChar(cp, dwFlags, ansiA, -1, utf16W, len);
		if (len) {
			utf16 = utf16W;
			return true;
		}
	}
	return false;
}

std::wstring utf8to16(const std::string& utf8)
{
	std::wstring utf16;
	if (!ansitouf16(utf8, CP_UTF8, MB_ERR_INVALID_CHARS, utf16))
	{
		throw openmsx::FatalError(StringOp::Builder() <<
		"MultiByteToWideChar failed: " << GetLastError());
	}
	return utf16;
}

std::string utf16to8(const std::wstring& utf16)
{
	const wchar_t* utf16W = utf16.c_str();
	int len = WideCharToMultiByte(CP_UTF8, 0, utf16W, -1, NULL, 0, NULL, NULL);
	if (len) {
		VLA(char, utf8, len);
		len = WideCharToMultiByte(CP_UTF8, 0, utf16W, -1, utf8, len, NULL, NULL);
		if (len) {
			return utf8;
		}
	}
	throw openmsx::FatalError(StringOp::Builder() <<
		"WideCharToMultiByte failed: " << GetLastError());
}

} // namespace utf8

#endif // _WIN32
