// $Id: Ram.hh 9796 2009-05-11 19:02:15Z m9710797 $

#ifndef RAM_HH
#define RAM_HH

#include "openmsx.hh"
#include "noncopyable.hh"
#include <string>
#include <cassert>
#include <memory>

namespace openmsx {

class MSXMotherBoard;
class RamDebuggable;

class Ram : private noncopyable
{
public:
	/** Create Ram object with an associated debuggable. */
	Ram(MSXMotherBoard& motherBoard, const std::string& name,
	    const std::string& description, unsigned size);

	/** Create Ram object without debuggable. */
	explicit Ram(unsigned size);

	~Ram();

	const byte& operator[](unsigned addr) const {
		assert(addr < size);
		return ram[addr];
	}
	byte& operator[](unsigned addr) {
		assert(addr < size);
		return ram[addr];
	}
	unsigned getSize() const { return size; }
	const std::string& getName() const;
	void clear();

	template<typename Archive>
	void serialize(Archive& ar, unsigned version);

private:
	byte* ram;
	unsigned size; // must come before debuggable
	const std::auto_ptr<RamDebuggable> debuggable;
};

} // namespace openmsx

#endif
