// $Id: Disk.hh 5740 2006-10-03 16:51:29Z m9710797 $

#ifndef DISK_HH
#define DISK_HH

#include "MSXException.hh"
#include "openmsx.hh"

namespace openmsx {

class NoSuchSectorException : public MSXException {
public:
	explicit NoSuchSectorException(const std::string &desc)
		: MSXException(desc) {}
};
class DiskIOErrorException  : public MSXException {
public:
	explicit DiskIOErrorException(const std::string &desc)
		: MSXException(desc) {}
};
class DriveEmptyException  : public MSXException {
public:
	explicit DriveEmptyException(const std::string &desc)
		: MSXException(desc) {}
};
class WriteProtectedException  : public MSXException {
public:
	explicit WriteProtectedException(const std::string &desc)
		: MSXException(desc) {}
};


class Disk
{
public:
	virtual ~Disk();

	const std::string& getName() const;

	virtual void read (byte track, byte sector,
	                   byte side, unsigned size, byte* buf) = 0;
	virtual void write(byte track, byte sector,
	                   byte side, unsigned size, const byte* buf) = 0;
	virtual void getSectorHeader(byte track, byte sector,
	                             byte side, byte* buf);
	virtual void getTrackHeader(byte track,
	                            byte side, byte* buf);
	virtual void initWriteTrack(byte track, byte side);
	virtual void writeTrackData(byte data);
	virtual void initReadTrack(byte track, byte side);
	virtual byte readTrackData();

	virtual bool ready() = 0;
	virtual bool writeProtected() = 0;
	virtual bool doubleSided() = 0;

	virtual void applyPatch(const std::string& patchFile);

protected:
	static const int RAWTRACK_SIZE = 6850;

	explicit Disk(const std::string& name);
	int physToLog(byte track, byte side, byte sector);
	void logToPhys(int log, byte& track, byte& side, byte& sector);

	virtual void detectGeometry();
	virtual int getImageSize();

	int sectorsPerTrack;
	int nbSides;

private:
	void detectGeometryFallback();

	const std::string name;
};

} // namespace openmsx

#endif
