#ifndef MIDIOUTLOGGER_HH
#define MIDIOUTLOGGER_HH

#include "MidiOutDevice.hh"
#include <fstream>
#include <memory>

namespace openmsx {

class CommandController;
class FilenameSetting;

class MidiOutLogger final : public MidiOutDevice
{
public:
	explicit MidiOutLogger(CommandController& commandController);
	~MidiOutLogger();

	// Pluggable
	void plugHelper(Connector& connector, EmuTime::param time) override;
	void unplugHelper(EmuTime::param time) override;
	const std::string& getName() const override;
	string_ref getDescription() const override;

	// SerialDataInterface (part)
	void recvByte(byte value, EmuTime::param time) override;

	template<typename Archive>
	void serialize(Archive& ar, unsigned version);

private:
	const std::unique_ptr<FilenameSetting> logFilenameSetting;
	std::ofstream file;
};

} // namespace openmsx

#endif
