/*
 * Copyright (c) 2017, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @bug 8087112 8180044 8256459
 * @modules java.net.http
 *          java.logging
 *          jdk.httpserver
 * @library /test/lib
 * @build jdk.test.lib.net.SimpleSSLContext
 * @compile ../../../com/sun/net/httpserver/LogFilter.java
 * @compile ../../../com/sun/net/httpserver/EchoHandler.java
 * @compile ../../../com/sun/net/httpserver/FileServerHandler.java
 * @build ManyRequests ManyRequests2
 * @run main/othervm/timeout=40 -Dtest.XFixed=true
 *                              -Djdk.tracePinnedThreads=full
 *                              -Djdk.httpclient.HttpClient.log=channel ManyRequests2
 * @run main/othervm/timeout=40 -Dtest.XFixed=true -Dtest.insertDelay=true
 *                              -Djdk.tracePinnedThreads=full
 *                              -Djdk.httpclient.HttpClient.log=channel ManyRequests2
 * @run main/othervm/timeout=40 -Dtest.XFixed=true -Dtest.chunkSize=64
 *                              -Djdk.tracePinnedThreads=full
 *                              -Djdk.httpclient.HttpClient.log=channel ManyRequests2
 * @run main/othervm/timeout=400 -Djdk.internal.httpclient.debug=true
 *                              -Djdk.tracePinnedThreads=full
 *                              -Djdk.httpclient.HttpClient.log=channel
 *                              -Dtest.XFixed=true -Dtest.insertDelay=true
 *                              -Dtest.chunkSize=64 ManyRequests2
 * @summary Send a large number of requests asynchronously.
 *          The server echoes back using known content length.
 */
 // * @run main/othervm/timeout=40 -Djdk.httpclient.HttpClient.log=ssl ManyRequests

public class ManyRequests2 {

    public static void main(String[] args) throws Exception {
        ManyRequests.main(args);
    }
}
