# -*- coding: utf-8 -*-

# Copyright (C) 2004-2005 Johan Svedberg <johan@svedberg.com>

# This file is part of ontv.

# ontv is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ontv is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ontv; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from gettext import gettext as _

import gtk

from GUI import GUI

class ToggleButton(GUI, gtk.ToggleButton):
    def __init__(self, config, xmltvfile, pw):
        GUI.__init__(self)
        gtk.ToggleButton.__init__(self)
        self.config = config
        self.xmltvfile = xmltvfile
        self.pw = pw

        self.xmltvfile.connect("loading", self.__xmltvfile_loading)
        self.xmltvfile.connect("loaded", self.__xmltvfile_loaded)

        self.connect("toggled", self.__toggled)
        self.connect("button-press-event", self.__button_press)

        self.set_relief(gtk.RELIEF_NONE)

        image = gtk.Image()
        scaled_icon = self.icon.scale_simple(24, 24, gtk.gdk.INTERP_BILINEAR)
        image.set_from_pixbuf(scaled_icon)

        hbox = gtk.HBox()
        hbox.pack_start(image)
        hbox.show()

        self.add(hbox)

        self.tooltips = gtk.Tooltips()

    def set_tooltip(self, text):
        self.tooltips.set_tip(self, text)

    def __xmltvfile_loading(self, xmltvfile):
        self.set_tooltip(_("Loading XMLTV file..."))

    def __xmltvfile_loaded(self, xmltvfile, listings):
        self.set_tooltip(None)

    def __toggled(self, togglebutton):
        if togglebutton.get_active():
            self.pw.position_window(self)
            self.pw.show_all()
            self.pw.grab_focus()
        else:
            self.pw.hide()

        if not self.config.display_current_programs:
            self.pw.cpt.hide()
        if not self.config.display_upcoming_programs:
            self.pw.upt.hide()

    def __button_press(self, button, event):
        if event.type == gtk.gdk.BUTTON_PRESS and event.button == 3:
            button.stop_emission("button-press-event")

# vim: set sw=4 et sts=4 tw=79 fo+=l:
