# -*- coding: utf-8 -*-

# Copyright (C) 2004-2005 Johan Svedberg <johan@svedberg.com>

# This file is part of ontv.

# ontv is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ontv is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ontv; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gtk
import gobject

from GUI import GUI

TIMEOUT = 100

class SearchDialog(GUI):
    def __init__(self, xmltvfile):
        GUI.__init__(self)
        xmltvfile.connect("loaded", self.__xmltvfile_loaded)

        self.__get_widgets()
        self.search_label.set_mnemonic_widget(self.search_entry)
        self.__connect_widgets()
        self.dialog.set_icon(self.icon)
        self.__make_search_treeview()
        self.__timeout_id = 0

    def __get_widgets(self):
        self.dialog = self.xml.get_widget("search_dialog")
        self.closebutton = self.xml.get_widget("closebutton2")
        self.search_label = self.xml.get_widget("search_label")
        self.search_entry = self.xml.get_widget("search_entry")
        self.search_treeview = self.xml.get_widget("search_treeview")

    def __connect_widgets(self):
        self.dialog.connect("close", self.__dialog_close)
        self.closebutton.connect("clicked", self.__closebutton_click)
        self.search_entry.connect("changed", self.__search_entry_changed)

    def __make_search_treeview(self):
        ls = gtk.ListStore(object)
        self.search_treeview.set_model(ls)

        crt = gtk.CellRendererText()
        crt.props.xpad = 3
        crt.props.ypad = 3
        time_column = gtk.TreeViewColumn("Air time", crt)
        time_column.set_cell_data_func(crt, self.__crt_cell_data_func)
        self.search_treeview.append_column(time_column)

        crtext = gtk.CellRendererText()
        crtext.props.xpad = 3
        crtext.props.ypad = 3
        program_column = gtk.TreeViewColumn("Program", crtext)
        program_column.set_cell_data_func(crtext, self.__crtext_cell_data_func)
        self.search_treeview.append_column(program_column)

    def show(self, uicomponent=None, verb=None):
        self.search_treeview.set_cursor(0)

        self.search_entry.grab_focus()
        self.dialog.show()

    def __search(self):
        model = self.search_treeview.get_model()
        model.clear()
        search = self.search_entry.get_text().strip().lower().split()

        if len(search) > 0:
            matches = self.listings.search_program(search)
            iter = model.get_iter_first()
            for row in model:
                program = row[0]
                if not program in matches:
                    model.remove(iter)
                else:
                    matches.remove(program)
                    model.iter_next(iter)

            for program in matches:
                model.append([program])

        self.search_treeview.set_cursor(0)
        return False

    def __xmltvfile_loaded(self, xmltvfile, listings):
        self.listings = listings
        self.search_entry.emit("changed")

    def __dialog_close(self, dialog):
        self.dialog.hide()

    def __closebutton_click(self, button):
        self.dialog.hide()

    def __search_entry_changed(self, entry):
        if self.__timeout_id > 0:
            gobject.source_remove(self.__timeout_id)

        self.__timeout_id = gobject.timeout_add(TIMEOUT, self.__search)

    def __crt_cell_data_func(self, column, cell, model, iter):
        program = model.get_value(iter, 0)
        markup = "<b>%s-%s</b>\n<i>%s</i>"
        cell.props.markup = markup % (program.start_time, program.stop_time,
                                      program.date)

    def __crtext_cell_data_func(self, column, cell, model, iter):
        program = model.get_value(iter, 0)
        markup = "<b>%s</b>\n<i>%s</i>"
        cell.props.markup = markup % (program.title, program.channel_name)

# vim: set sw=4 et sts=4 tw=79 fo+=l:
