# -*- coding: utf-8 -*-

# Copyright (C) 2004-2005 Johan Svedberg <johan@svedberg.com>

# This file is part of ontv.

# ontv is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ontv is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ontv; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gettext
import locale
import os.path

import pygtk
pygtk.require("2.0")
import gtk
import gnome
import gnomeapplet

from Configuration import Configuration
from XMLTVFile import XMLTVFile
from ProgramWindow import ProgramWindow
from ToggleButton import ToggleButton
from PreferencesDialog import PreferencesDialog
from SearchDialog import SearchDialog
from AboutDialog import AboutDialog
from ontv import NAME, VERSION, UI_DIR, LOCALE_DIR

class OnTVApplet:
    def __init__(self, applet):
        self.config = Configuration()
        self.xmltvfile = XMLTVFile(self.config)

        self.pw = ProgramWindow(self.xmltvfile, applet.get_orient)
        self.tb = ToggleButton(self.config, self.xmltvfile, self.pw)
        self.pd = PreferencesDialog(self.config, self.xmltvfile, self.pw)
        self.sd = SearchDialog(self.xmltvfile)

        ui_file = os.path.join(UI_DIR, "GNOME_OnTVApplet.xml")
        verb_list = [("Reload XMLTV file", self.xmltvfile.load),
                     ("Preferences", self.pd.show),
                     ("Search Program", self.sd.show),
                     ("About", self.__run_ad)]
        applet.setup_menu_from_file(None, ui_file, NAME, verb_list)

        applet.add(self.tb)

        applet.show_all()

    def __run_ad(self, uicomponent=None, verb=None):
        self.ad = AboutDialog()
        self.ad.run()

    def run(self):
        if self.config.xmltv_file == '':
            self.pd.show()
            self.pd.notebook.set_current_page(0)
        else:
            self.xmltvfile.props.path = self.config.xmltv_file
            if self.config.auto_reload_xmltv_file:
                self.pd.start_auto_reload(self.config.auto_reload_xmltv_file_rate)

def main():
    gettext.bindtextdomain(NAME.lower(), LOCALE_DIR)
    gettext.textdomain(NAME.lower())

    locale.bindtextdomain(NAME.lower(), LOCALE_DIR)
    locale.textdomain(NAME.lower())

    gnome.init(NAME, VERSION)
    gtk.threads_init()

    activate_factory()

def applet_factory(applet, iid=None):
    ontvapplet = OnTVApplet(applet)
    ontvapplet.run()
    return True

def activate_factory():
    gnomeapplet.bonobo_factory("OAFIID:GNOME_OnTVApplet_Factory",
                               gnomeapplet.Applet.__gtype__, NAME, VERSION,
                               applet_factory)

# vim: set sw=4 et sts=4 tw=79 fo+=l:
