.suffixes
# dir.mms for omniORB shared library
#
# Build a shared library in this directory
# **** DO NOT forget to update the $(VERSION) number.
#

# The Version number is constructed as follows:
#    <major version no.>.<minor version no.>.<micro version no.>
#
# The <minor version no.> changes when:
#   1. Public interfaces have been extended but remains backward compatible
#      with earlier minor version.
#   2. Internal interfaces have been changed.
#
# The <micro version no.> changes when the implementation has been changed
# but both the public and internal interfaces remain the same. This usually
# corresponds to a pure bug fix release.
#
# (Note that this is backwards from dir.mk since MMS has no $(word...).

major_version = 3
minor_version = 0
micro_version = 0

VERSION = $(major_version).$(minor_version).$(micro_version)

# assume that the parent directory is built and that therefore
# $(libpath)omniORB3$(DebugSuffix).olb exists.

staticlib=[-]omniORB3$(DebugSuffix).olb
shareableimage=omniORB3$(ShareableImageSuffix).exe
exportshareableimage=$(libpath)$(shareableimage)
dir_cxxlinkflags=/map/full

.ifdef CXX5

# DEC/Comopaq C++ 5.6 stupidly thinks it needs omniDyanmic3.olb

STUPIDSTUB=cxx5dllstub
STUPIDSTUB_OBJ=cxx5dllstub.obj
DIR_FIRSTACTIONS = pipe ( echo "omnilib:omnithread_rt$(DebugSuffix).exe/share"\
	; echo "sys$disk:[]$(STUPIDSTUB_OBJ)"\
	) | type sys$input > share$(DebugSuffix).opt

.endif

OBJ_LIBS = $(OMNIORB_SHAREDLIB)/include=omnithread$(ShareableImageSuffix)

all :: $(shareableimage)

.IFDEF CXX5
STUPIDSTUB_OPT=SYS$DISK:[]$(STUPIDSTUB).OPT/OPT\
	SYS$DISK:[]SHARE$(Debugsuffix).LCL/opt
.ENDIF

$(shareableimage) : $(staticlib) $(OMNITHREAD_SHAREDLIB_DEPEND)\
	$(STUPIDSTUB_OBJ)
	$(CxxShareableImage) $(STUPIDSTUB_OPT)

export :: all

export :: $(exportshareableimage)

$(exportshareableimage) : $(shareableimage)
	$(ExportShareable)

veryclean ::
	@- $(RM) $(shareableimage)
	@- $(RM) *.opt *.dat *.obj *.mar

.IFDEF CXX5
$(STUPIDSTUB_OBJ) : $(STUPIDSTUB).cc
	$(CxxCompile)
.ENDIF
