# Copyright (C) 2006 by Szilveszter Farkas (Phanatic) <szilveszter.farkas@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os
import sys

try:
    import pygtk
    pygtk.require("2.0")
except:
    pass
try:
    import gtk
    import gtk.glade
except:
    sys.exit(1)

import bzrlib.errors as errors

class OliveRename:
    """ Display the Rename dialog and perform the needed actions. """
    def __init__(self, gladefile, comm, dialog):
        """ Initialize the Rename dialog. """
        self.gladefile = gladefile
        self.glade = gtk.glade.XML(self.gladefile, 'window_rename')
        
        # Communication object
        self.comm = comm
        # Dialog object
        self.dialog = dialog
        
        self.window = self.glade.get_widget('window_rename')
        
        # Dictionary for signal_autoconnect
        dic = { "on_button_rename_rename_clicked": self.rename,
                "on_button_rename_cancel_clicked": self.close }
        
        # Connect the signals to the handlers
        self.glade.signal_autoconnect(dic)
        
    def display(self):
        """ Display the Rename dialog. """
        self.window.show_all()

    def rename(self, widget):
        # Get entry
        entry = self.glade.get_widget('entry_rename')
        
        old_filename = self.comm.get_selected_right()
        new_filename = entry.get_text()
            
        if old_filename is None:
            self.dialog.error_dialog(_('No file was selected'),
                                     _('Please select a file from the list to proceed.'))
            return
        
        if new_filename == "":
            self.dialog.error_dialog(_('Filename not given'),
                                     _('Please specify a new name for the file.'))
            return
        
        source = self.comm.get_path() + '/' + old_filename
        destination = self.comm.get_path() + '/' + new_filename
        
        # Rename the file
        try:
            wt1, path1 = WorkingTree.open_containing(source)
            wt2, path2 = WorkingTree.open_containing(source)

            if wt1.base != wt2.base:
                self.dialog.error_dialog(_('Not the same branch'),
                                         _('The destination is not in the same branch.'))
                return
            wt1.rename_one(source, destination)
        except errors.NotBranchError:
            self.dialog.error_dialog(_('File is not in a branch'),
                                     _('The selected file is not in a branch.'))
            return

        self.close()
        self.comm.refresh_right()
    
    def close(self, widget=None):
        self.window.destroy()
