#include "screenshot_win.h"

#include <klocale.h>
#include <klineedit.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <kfiledialog.h>

ScreenshotWin::ScreenshotWin(QWidget* parent) : KDialogBase(parent,"",true,i18n("Take screenshot"),Ok|Cancel,Ok)
{
 QFrame* page = makeMainWidget();

 QVBoxLayout* layout = new QVBoxLayout(page,0,marginHint());

 withspu = new QCheckBox(i18n("With subtitle"),page);
 layout->addWidget(withspu);

 QHBoxLayout* hbox = new QHBoxLayout(layout);

 QLabel* lfn = new QLabel(i18n("Filename:"),page);
 hbox->addWidget(lfn);

 filename = new KLineEdit(page);
 connect(filename,SIGNAL(textChanged(const QString&)),this,SLOT(fileNameChanged()));
 hbox->addWidget(filename);

 filechooser = new QPushButton("...",page);
 filechooser->setFixedSize(filechooser->sizeHint());
 connect(filechooser,SIGNAL(clicked()),this,SLOT(chooseFile()));
 hbox->addWidget(filechooser);

 layout->addSpacing(10);

 layout->activate();
}

ScreenshotWin::~ScreenshotWin()
{}

void ScreenshotWin::setWithSPU(bool b)
{
 withspu->setChecked(b);
}

bool ScreenshotWin::withSPU()const
{
 return withspu->isChecked();
}

void ScreenshotWin::setFileName(const QString& fn)
{
 filename->setText(fn);
}

QString ScreenshotWin::fileName()const
{
 return filename->text();
}

void ScreenshotWin::fileNameChanged()
{
 if(filename->text().isEmpty())
  enableButtonOK(false);
 else
  enableButtonOK(true);
}

void ScreenshotWin::chooseFile()
{
 QString f = KFileDialog::getSaveFileName();
 if(!f.isEmpty())
  filename->setText(f);
}

#include "screenshot_win.moc"
