#include "dvdinfo_win.h"

#include <klocale.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qlabel.h>

DVDInfoWin::DVDInfoWin(QWidget* parent) : KDialogBase(parent,"",true,i18n("DVD information"),Ok,Ok)
{
 QFrame* page = makeMainWidget();

 QVBoxLayout* layout = new QVBoxLayout(page,0,marginHint());

 QGridLayout* grid = new QGridLayout(layout,4,2,spacingHint());

 QLabel* l1 = new QLabel(i18n("Number of volumes:"),page);
 grid->addWidget(l1,0,0);

 _nrofvols = new QLabel("-",page);
 grid->addWidget(_nrofvols,0,1);

 QLabel* l2 = new QLabel(i18n("Volume:"),page);
 grid->addWidget(l2,1,0);

 _vol = new QLabel("-",page);
 grid->addWidget(_vol,1,1);

 QLabel* l3 = new QLabel(i18n("Side:"),page);
 grid->addWidget(l3,2,0);

 _side = new QLabel("-",page);
 grid->addWidget(_side,2,1);

 QLabel* l4 = new QLabel(i18n("Number of titles:"),page);
 grid->addWidget(l4,3,0);

 _nroftitles = new QLabel("-",page);
 grid->addWidget(_nroftitles,3,1);

 layout->activate();
}

DVDInfoWin::~DVDInfoWin()
{}

void DVDInfoWin::setNrOfVolumes(int nrofvolumes)
{
 _nrofvols->setText(QString::number(nrofvolumes));
}

void DVDInfoWin::setVolume(int volume)
{
 _vol->setText(QString::number(volume));
}

void DVDInfoWin::setSide(int side)
{
 _side->setText(QString::number(side));
}

void DVDInfoWin::setNrOfTitles(int nroftitles)
{
 _nroftitles->setText(QString::number(nroftitles));
}

#include "dvdinfo_win.moc"
