      SUBROUTINE ODESSA_PREPDF (NEQ, Y, SRUR, SAVF, FTEM, DFDP, PAR,
     1   F, DF, JPAR)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      EXTERNAL F, DF
      DIMENSION NEQ(*), Y(*), SAVF(*), FTEM(*), DFDP(*), PAR(*)
      COMMON /ODE001/ ROWND, ROWNS(173),
     1   RDUM1(43), TN, RDUM2,
     2   IOWND1(14), IOWNS(4),
     3   IDUM1(10), MITER, IDUM2(4), N, IDUM3(2), NFE, IDUM4(2)
      COMMON /ODE002/ RDUM3(3),
     1   IOWND2(3), IDUM5(2), NDFE, IDUM6, IDF, IDUM7(3)
C-----------------------------------------------------------------------
C ODESSA_PREPDF IS CALLED BY ODESSA_SPRIME AND ODESSA_STESA TO COMPUTE
C THE INHOMOGENEITY VECTORS DF(I)/DP(JPAR). HERE DF/DP IS COMPUTED BY
C THE USER-SUPPLIED ROUTINE DF IF IDF = 1, OR BY FINITE DIFFERENCING IF
C IDF = 0. 
C
C IN ADDITION TO VARIABLES DESCRIBED PREVIOUSLY, COMMUNICATION WITH
C ODESSA_PREPDF USES THE FOLLOWING..
C Y     = REAL ARRAY OF LENGTH NYH CONTAINING DEPENDENT VARIABLES.
C         ODESSA_PREPDF USES ONLY THE FIRST N ENTRIES OF Y(*).
C SRUR  = SQRT(UROUND) (= WM(1)).
C SAVF  = REAL ARRAY OF LENGTH N CONTAINING DERIVATIVES DY/DT.
C FTEM  = REAL ARRAY OF LENGTH N USED TO TEMPORARILY STORE DY/DT FOR
C         NUMERICAL DIFFERENTIATION.
C DFDP  = REAL ARRAY OF LENGTH N USED TO STORE DF(I)/DP(JPAR), I = 1,N.
C PAR   = REAL ARRAY OF LENGTH NPAR CONTAINING EQUATION PARAMETERS
C         OF INTEREST.
C JPAR  = INPUT PARAMETER, 2 .LE. JPAR .LE. NSV, DESIGNATING THE
C         APPROPRIATE SOLUTION VECTOR CORRESPONDING TO PAR(JPAR).
C THIS ROUTINE ALSO USES THE COMMON VARIABLES TN, MITER, N, NFE, NDFE,
C AND IDF.
C-----------------------------------------------------------------------
      NDFE = NDFE + 1
      IDF1 = IDF + 1
      GO TO (100, 200), IDF1
C IDF = 0, CALL F TO APPROXIMATE DFDP. ---------------------------------
 100  RPAR = PAR(JPAR)
      R = DMAX1(SRUR*DABS(RPAR),SRUR)
      PAR(JPAR) = RPAR + R
      FAC = 1.0D0/R
      CALL F (NEQ, TN, Y, PAR, FTEM)
      DO 110 I = 1,N
 110    DFDP(I) = (FTEM(I) - SAVF(I))*FAC
      PAR(JPAR) = RPAR
      NFE = NFE + 1
      RETURN
C IDF = 1, CALL USER SUPPLIED DF. --------------------------------------
 200  DO 210 I = 1,N
 210    DFDP(I) = 0.0D0
      CALL DF (NEQ, TN, Y, PAR, DFDP, JPAR)
      RETURN
C -------------------- END OF SUBROUTINE ODESSA_PREPDF ------------------------
      END









