(* ocamlgsl - OCaml interface to GSL                        *)
(* Copyright () 2002 - Olivier Andrieu                     *)
(* distributed under the terms of the GPL version 2         *)

type params = {
  iters_fixed_T : int;
  step_size     : float;
  k             : float;
  t_initial     : float;
  mu_t          : float;
  t_min         : float;
} 

val solve :
  Gsl_rng.t -> 'a ->
  energ_func:('a -> float) ->
  step_func:(Gsl_rng.t -> 'a -> float -> 'a) ->
  ?print_func:('a -> unit) -> 
  params -> 'a
