
let compute f =
  let _ =
    Unix.setitimer Unix.ITIMER_VIRTUAL 
      { Unix.it_interval = 0. ; 
	Unix.it_value = 2. } in
  let finished = ref false in
  let cnt = ref 0 in
  Sys.set_signal Sys.sigvtalrm (Sys.Signal_handle (fun _ -> finished := true)) ;
  while not !finished do
    ignore (f ()) ;
    incr cnt
  done ;
  !cnt


let res (int_cnt, flt_cnt, name) =
  Format.printf "%6d k ints/sec, %6d k doubles/sec, %s@."
    (int_cnt / 10000) (flt_cnt / 10000) name

let compute_caml () =
  let int_cnt = compute Random.bits in
  let flt_cnt = compute (fun () -> Random.float 1.) in
  (int_cnt, flt_cnt, "Caml")

let compute_gsl t =
  let rng = Gsl_rng.make t in
  let int_cnt = compute (fun () -> Gsl_rng.get rng) in
  let flt_cnt = compute (fun () -> Gsl_rng.uniform rng *. 1.) in
  (int_cnt, flt_cnt, Gsl_rng.name rng)

let main () = 
  res (compute_caml ()) ;
  List.iter (fun t -> res (compute_gsl t)) 
    [ Gsl_rng.MT19937 ;
      Gsl_rng.RANLXS0 ;
      Gsl_rng.RANLXS1 ;
      Gsl_rng.RANLXS2 ;
      Gsl_rng.RANLXD1 ;
      Gsl_rng.RANLXD2 ;
      Gsl_rng.RANLUX ;
      Gsl_rng.RANLUX389 ;
      Gsl_rng.CMRG ;
      Gsl_rng.MRG ;
      Gsl_rng.TAUS ;
      Gsl_rng.TAUS_2 ;
      Gsl_rng.GFSR4 ;
    ]
    
let _ = main ()
