
open Graph

(* les types pour les noeuds et les artes *)

type node = Service of string | Condition of string * string
type color = Green | Red
type kind = Depend of string | InterDepend of string * string
type edge = { color : color; kind : kind }

(* la cration d'un module G pour des graphes
   impratifs (i.e. modifis en place) et orients, dont les noeuds
   et les artes sont respectivement tiquets par les types node et
   edge ci-dessus. *)

module V = struct 
  type t = node
end
module E = struct 
  type t = edge
  let compare = compare 
  let hash = Hashtbl.hash 
  let equal = (=)
  let default = { color = Green; kind = Depend "" }
end
module G = Imperative.Graph.AbstractLabeled(V)(E)

(* la cration d'un graphe particulier *)

let g = G.create ()
let v1 = G.V.create (Service "s1")
let v2 = G.V.create (Service "s2")
let () = G.add_edge_e g (G.E.create v1 { color = Red; kind = Depend "C" } v2)
(* etc. *)

module Display = struct
  include G
  let vertex_name v = match V.label v with
    | Service s -> "service " ^ s
    | Condition (s1,s2) -> "condition " ^ s1 ^ " " ^ s2
  let graph_attributes _ = []
  let default_vertex_attributes _ = []
  let vertex_attributes _ = []
  let default_edge_attributes _ = []
  let edge_attributes _ = []
end
module Dot = Graphviz.Dot(Display)

let dot_output g f = 
  let oc = open_out f in
  Dot.output_graph oc g;
  close_out oc

let display_with_gv g =
  let tmp = Filename.temp_file "graph" ".dot" in
  dot_output g tmp;
  ignore (Sys.command ("dot -Tps " ^ tmp ^ " | gv -"));
  Sys.remove tmp

let () = display_with_gv g
