
open Format
open Graph.Pack.Graph
let g = create ()
let n = 5
let nodes = Array.init n V.create
let node i = nodes.(i)
let () = for i = 0 to n-1 do add_vertex g (node i) done
let edge i j = add_edge g (node i) (node j)
let () = 
  edge 1 0(*; edge 1 2; edge 0 2; edge 2 3; edge 3 4; 
  edge 2 4; edge 0 4; edge 1 4; edge 1 3; edge 0 3*)
let display g =
  iter_vertex (fun v -> printf "node %d: %d@." (V.label v) (Mark.get v)) g
module C = Graph.Coloring.Mark(Graph.Pack.Graph)
(*let g = Classic.de_bruijn 2*)
let () = display_with_gv g
let () = C.coloring g 5
let () = display g
(* check *)
let () =
  iter_vertex 
    (fun v -> iter_succ (fun w -> assert (Mark.get v <> Mark.get w)) g v) g

(***
open Delaunay.Float

let random_point () = float (50 + Random.int 500), float (40 + Random.int 320)

(* let () = Random.self_init () *)
let n = 25
let points = Array.init n (fun _ -> random_point ())

let t = triangulate points

open Graphics
let () = open_graph " 600x400"

let () = 
  set_color red;
  for i = 0 to n - 1 do
    let x,y = points.(i) in
    draw_circle (truncate x) (truncate y) 3
  done

let () = 
  set_color black;
  iter (fun (xu,yu) (xv,yv) -> 
	  moveto (truncate xu) (truncate yu);
	  lineto (truncate xv) (truncate yv)) t

let _ = while not (key_pressed ()) do () done
***)

(***
open Unix
  
let utime f x =                                                   
  let u = (times()).tms_utime in                                  
  let y = f x in
  let ut = (times()).tms_utime -. u in
  (y,ut)

let print_utime f x = 
  let (y,ut) = utime f x in
  Printf.printf "user time: %2.2f\n" ut; flush Pervasives.stdout;
  y

open Graph.Pack.Digraph

let g = print_utime (fun e -> Rand.random ~v:200000 ~e) 500000

let () = print_utime (Dfs.iter ~pre:(fun _ -> ())) g

let () = print_utime (Dfs.prefix (fun _ -> ())) g

let () = print_utime Marking.dfs g
***)
